package iDSS.tidalData;



import java.beans.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.table.AbstractTableModel;
import java.sql.Timestamp;
import java.util.*;
import javax.swing.ListSelectionModel;
import java.awt.image.*;
import javax.swing.event.*;



//import iDSS.math.*;
import iDSS.xyGraph.*;
import iDSS.disp.*;
import iDSS.tables.*;
import iDSS.utils.*;
import iDSS.beans2.*;



public class DataManager extends DisplayFrame
    implements ItemListener,ActionListener,ChangeListener,PropertyChangeListener {



  private JPanel dataTablePanel;
  private JTable dataTable;
  private JScrollPane dataTableScrollPane;

  private JPanel processOptionsPanel;
  private JComboBox processTypesCombo;
  private String[] processTypes = {"Table","XYGraph","Devise Tidal Model","Statistics","Moving Average","Correlation","Select Tidal Model","Dispose"};
  private JButton processDoItButton;
  private JButton selectDataModelButton;

  private JPanel processTypesPanel;

  private JPanel processFurtherOptionsPanel;
  private JPanel processTablePanel;
  private JPanel processXYGraphPanel;
  private JPanel processDataModelPanel;
  private JPanel processStatisticsPanel;
  private JPanel processMovingAveragePanel;
  private JPanel processCorrelationPanel;
  private JPanel selectPanel;
  private JPanel noOptionsPanel;
  

  private TimestampPanel tableStartDatePanel, tableEndDatePanel;
  private TimestampPanel xyGraphStartDatePanel, xyGraphEndDatePanel;
  private TimestampPanel dataModelStartDatePanel, dataModelEndDatePanel;
  private TimestampPanel statisticsStartDatePanel, statisticsEndDatePanel;
  private TimestampPanel movingAverageStartDatePanel, movingAverageEndDatePanel;
  private TimestampPanel correlationStartDatePanel, correlationEndDatePanel;
  private TimestampPanel selectStartDatePanel, selectEndDatePanel;


  private JLabel processTypesLabel;
  private JLabel superimposeLabel;
  private JComboBox superimposeCombo;
  private Vector superimposeVector;
  private JLabel correlateLabel;
  private JComboBox correlateCombo,selectCombo;


  private JLabel dataModelIterationsLabel;
  private JSlider dataModelIterationsSlider;
  private int numberOfFourierIterations = 0;


  private JLabel movingAverageLengthLabel;
  private JLabel movingAverageUnitLabel;
  private JSlider movingAverageLengthSlider;
  private JComboBox movingAverageUnitCombo;
  private String[] movignAverageUnits = {"Days","Hours"};

  private GridBagLayout gbLayout = new GridBagLayout();
  private GridBagConstraints gbConstraints = new GridBagConstraints();

  private boolean ALLOW_ROW_SELECTION = true;

  private Vector currentRow;
  private String tidalModelKey;


    private DataManagerJBean dataManagerJBean;


  public DataManager(ClientDataSet aDataSet) {

    super (IDSSAppConstants.dataManager,false,false,false,true,null);

    dataManagerJBean = new DataManagerJBean();
    dataManagerJBean.addPropertyChangeListener(this);
    dataManagerJBean.addToDataSet(aDataSet);

    //dataSetHashtable = new Hashtable();
    //dataSetHashtable.put(aDataSet.getSqlString(),aDataSet);
    //xyGraphsHashtable = new Hashtable();

    //tidalModelHashtable = new Hashtable();

    getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
    
    gbConstraints.fill = GridBagConstraints.BOTH;
    gbConstraints.weightx = 0;
    gbConstraints.weighty = 0;
    gbConstraints.ipadx = 5;
    gbConstraints.ipady = 5;


  //dataTablePanel

    dataTablePanel = new JPanel();
    dataTablePanel.setBorder(BorderFactory.createTitledBorder("Data Fetched So Far"));

    Vector columnNames = new Vector();
    columnNames.add("SQL String");
    columnNames.add("Station");
    columnNames.add("Start Date");
    columnNames.add("End Date");

    Vector row = new Vector();
    row.add(aDataSet.getDataSetVector());



    GeneralTableModel tm = new GeneralTableModel(row,columnNames);

    dataTable = new JTable(tm);
    dataTable.setPreferredScrollableViewportSize(new Dimension(500,70));

    dataTableScrollPane = new JScrollPane(dataTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    dataTablePanel.add(dataTableScrollPane,BorderLayout.CENTER);

  //dataTablePanel completed


  //processTypesPanel

    processTypesPanel = new JPanel();
    processTypesPanel.setBorder(BorderFactory.createTitledBorder("Process Types"));
    processTypesPanel.setLayout(new BoxLayout(processTypesPanel,BoxLayout.Y_AXIS));

    processTypesCombo = new JComboBox(processTypes);
    processDoItButton = new JButton("Do it!");
    processDoItButton.setActionCommand("doIt");
    processDoItButton.addActionListener(this);

    processTypesCombo.addItemListener(this);

    processTypesPanel.add(processTypesCombo);
    processTypesPanel.add(processDoItButton);

  //processTypesPanel completed


  //Initializing date TextFields and JLabels - converted to Timestamp panels

    tableStartDatePanel = new TimestampPanel("Start",1900,2050);
    tableEndDatePanel = new TimestampPanel("End",1900,2050);

    xyGraphStartDatePanel = new TimestampPanel("Start",1900,2050);
    xyGraphEndDatePanel = new TimestampPanel("End",1900,2050);

    dataModelStartDatePanel = new TimestampPanel("Start",1900,2050);
    dataModelEndDatePanel = new TimestampPanel("End",1900,2050);

    statisticsStartDatePanel = new TimestampPanel("Start",1900,2050);
    statisticsEndDatePanel = new TimestampPanel("End",1900,2050);

    movingAverageStartDatePanel = new TimestampPanel("Start",1900,2050);
    movingAverageEndDatePanel = new TimestampPanel("End",1900,2050);

    correlationStartDatePanel = new TimestampPanel("Start",1900,2050);
    correlationEndDatePanel = new TimestampPanel("End",1900,2050);

    selectStartDatePanel = new TimestampPanel("Start",1900,2050);
    selectEndDatePanel = new TimestampPanel("End",1900,2050);

  //Initializing date TextFields and JLabels - completed



  //processTablePanel

    processTablePanel = new JPanel();
    processTablePanel.setBorder(BorderFactory.createTitledBorder("Table"));

    processTablePanel.setLayout(gbLayout);

    addComponent(processTablePanel,tableStartDatePanel,0,0,3,1);
    addComponent(processTablePanel,tableEndDatePanel,1,0,3,1);

  //processTablePanel completed





  //processXYGraphPanel

    processXYGraphPanel = new JPanel();
    processXYGraphPanel.setBorder(BorderFactory.createTitledBorder("XY Graph"));
    processXYGraphPanel.setLayout(gbLayout);

    superimposeLabel = new JLabel("Superimpose on");
    superimposeVector = new Vector();
    superimposeVector.add("None");
    superimposeCombo = new JComboBox(superimposeVector);

    addComponent(processXYGraphPanel,superimposeLabel,0,0,2,1);
    addComponent(processXYGraphPanel,superimposeCombo,0,2,2,1);

    addComponent(processXYGraphPanel,xyGraphStartDatePanel,1,0,4,1);
    addComponent(processXYGraphPanel,xyGraphEndDatePanel,2,0,4,1);


  //processXYGraphPanel completed





  //processDataModelPanel

    processDataModelPanel = new JPanel();
    processDataModelPanel.setBorder(BorderFactory.createTitledBorder("Devise Tidal Model"));
    processDataModelPanel.setLayout(gbLayout);

    dataModelIterationsLabel = new JLabel("Number of iterations");
    dataModelIterationsSlider = new JSlider(JSlider.HORIZONTAL,0,3000,numberOfFourierIterations);

    Hashtable labelTable = new Hashtable();
    labelTable.put( new Integer( 0 ), new JLabel("0") );
    labelTable.put( new Integer( 500 ), new JLabel("500") );
    labelTable.put( new Integer( 1000 ), new JLabel("1000") );
    labelTable.put( new Integer( 1500 ), new JLabel("1500") );
    labelTable.put( new Integer( 2000 ), new JLabel("2000") );
    labelTable.put( new Integer( 2500 ), new JLabel("2500") );
    labelTable.put( new Integer( 3000 ), new JLabel("3000") );


    dataModelIterationsSlider.setMajorTickSpacing(500);
    dataModelIterationsSlider.setMinorTickSpacing(100);
    dataModelIterationsSlider.setPaintTicks(true);
    dataModelIterationsSlider.setLabelTable(labelTable);
    dataModelIterationsSlider.setPaintLabels(true);
    dataModelIterationsSlider.setSnapToTicks(true);
    dataModelIterationsSlider.setBorder(BorderFactory.createEmptyBorder(0,0,10,0));

    dataModelIterationsSlider.addChangeListener(this);

    addComponent(processDataModelPanel,dataModelIterationsLabel,0,0,1,1);
    addComponent(processDataModelPanel,dataModelIterationsSlider,0,1,3,1);

    addComponent(processDataModelPanel,dataModelStartDatePanel,1,0,4,1);
    addComponent(processDataModelPanel,dataModelEndDatePanel,2,0,4,1);

  //processDataModelPanel completed



  //processStatisticsPanel

    processStatisticsPanel = new JPanel();
    processStatisticsPanel.setBorder(BorderFactory.createTitledBorder("Statistics"));
    processStatisticsPanel.setLayout(gbLayout);

    addComponent(processStatisticsPanel,statisticsStartDatePanel,0,0,3,1);
    addComponent(processStatisticsPanel,statisticsEndDatePanel,1,0,3,1);


  //processStatisticsPanel completed





  //movingAveragePanel

    processMovingAveragePanel = new JPanel();
    processMovingAveragePanel.setBorder(BorderFactory.createTitledBorder("Moving Average"));
    //processMovingAveragePanel.setLayout(new BoxLayout(processMovingAveragePanel,BoxLayout.Y_AXIS));
    processMovingAveragePanel.setLayout(gbLayout);

    movingAverageLengthLabel = new JLabel("Length");
    movingAverageUnitLabel = new JLabel("Unit");
    movingAverageLengthSlider = new JSlider(JSlider.HORIZONTAL,1,100,50);
    movingAverageUnitCombo = new JComboBox(movignAverageUnits);


    addComponent(processMovingAveragePanel,movingAverageLengthSlider,0,0,3,1);
    addComponent(processMovingAveragePanel,movingAverageUnitCombo,0,3,1,1);
    addComponent(processMovingAveragePanel,movingAverageStartDatePanel,1,0,4,1);
    addComponent(processMovingAveragePanel,movingAverageEndDatePanel,2,0,4,1);


  //movignAevragePanel completed


  //correlationPanel

    processCorrelationPanel = new JPanel();
    processCorrelationPanel.setBorder(BorderFactory.createTitledBorder("Correlation"));


    processCorrelationPanel.setLayout(gbLayout);

    correlateLabel = new JLabel("Correlate with:");
    correlateCombo = new JComboBox();

    addComponent(processCorrelationPanel,correlateLabel,0,0,1,1);
    addComponent(processCorrelationPanel,correlateCombo,0,1,3,1);
    addComponent(processCorrelationPanel,correlationStartDatePanel,1,0,4,1);
    addComponent(processCorrelationPanel,correlationEndDatePanel,2,0,4,1);


  //correlationPanel completed



  //selectPanel

    selectPanel = new JPanel();
    selectPanel.setBorder(BorderFactory.createTitledBorder("Select Tidal Model"));

    selectCombo = new JComboBox();
    selectCombo.addItem("None");
    selectCombo.addItemListener(this);

    selectDataModelButton = new JButton("Select");
    selectDataModelButton.setActionCommand("selectDataModel");
    selectDataModelButton.addActionListener(this);
    selectDataModelButton.setEnabled(false);

    selectPanel.setLayout(new BoxLayout(selectPanel,BoxLayout.Y_AXIS));
    selectPanel.add(selectCombo);
    selectPanel.add(selectDataModelButton);


  //selectPanel completed



  //noOptionsPanel

    noOptionsPanel = new JPanel();
    noOptionsPanel.setBorder(BorderFactory.createTitledBorder("No options"));
    noOptionsPanel.add(new JLabel("No options available"), BorderLayout.CENTER);

  //noOptionsPanel completed

  //processFurtherOptionsPanel

    processFurtherOptionsPanel = new JPanel();

    processFurtherOptionsPanel.setLayout(new CardLayout());


    processFurtherOptionsPanel.add(processTablePanel,"Table");
    processFurtherOptionsPanel.add(processXYGraphPanel,"XYGraph");
    processFurtherOptionsPanel.add(processDataModelPanel,"Devise Tidal Model");
    processFurtherOptionsPanel.add(processStatisticsPanel,"Statistics");
    processFurtherOptionsPanel.add(processMovingAveragePanel,"Moving Average");
    processFurtherOptionsPanel.add(processCorrelationPanel,"Correlation");
    processFurtherOptionsPanel.add(selectPanel,"Select Tidal Model");
    processFurtherOptionsPanel.add(noOptionsPanel,"Dispose");

  //processFurtherOptionsPanel completed





  //processOptionsPanel
    //contains processTypesPanel and processFurtherOptionsPanel

    processOptionsPanel = new JPanel();
    processOptionsPanel.setBorder(BorderFactory.createTitledBorder("Process Options"));

    processDoItButton.setEnabled(false);

  //processOptionsPanel completed




    //Adding components to processOptionsPanel with gbLayout or GridLayout

    addComponent(processOptionsPanel,processTypesPanel,0,0,1,1);
    addComponent(processOptionsPanel,processFurtherOptionsPanel,0,1,2,1);

    getContentPane().add(dataTablePanel);
    getContentPane().add(processOptionsPanel);


    pack();
    setVisible(true);

    dataTable.setPreferredScrollableViewportSize(new Dimension(500,50));


    //Detecting row selection


    if (ALLOW_ROW_SELECTION) { // true by default
        ListSelectionModel rowSM = dataTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                //Ignore extra messages.
                if (e.getValueIsAdjusting()) return;
                
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    System.out.println("No rows are selected.");


                    //String s = (String) processTypesCombo.getSelectedItem();

                    //if (!s.equals("Select Tidal Model"))
                    processDoItButton.setEnabled(false);

                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    System.out.println("Row " + selectedRow
                                       + " is now selected.");


                    processDoItButton.setEnabled(true);

                    String currentDataSet = (String) dataTable.getValueAt(selectedRow,0);
                    String currentStation = (String) dataTable.getValueAt(selectedRow,1);
                    Timestamp startDate = (Timestamp) dataTable.getValueAt(selectedRow,2);
                    Timestamp endDate = (Timestamp) dataTable.getValueAt(selectedRow,3);

                    currentRow = new Vector();
                    currentRow.add(currentDataSet);
                    currentRow.add(currentStation);
                    currentRow.add(startDate);
                    currentRow.add(endDate);

                    dataManagerJBean.setCurrentRow(currentRow);

                    System.out.println(startDate.toString());
                    System.out.println(endDate.toString());

                    Calendar aCalendar = Calendar.getInstance();
                    aCalendar.setTime(startDate);
                    int startYear = aCalendar.get(Calendar.YEAR);
                    aCalendar.setTime(endDate);
                    int endYear = aCalendar.get(Calendar.YEAR);

                    tableStartDatePanel.resetYearCombo(startYear,endYear);
                    tableEndDatePanel.resetYearCombo(startYear,endYear);

                    tableStartDatePanel.setTime(startDate);
                    tableEndDatePanel.setTime(endDate);

                    xyGraphStartDatePanel.resetYearCombo(startYear,endYear);
                    xyGraphEndDatePanel.resetYearCombo(startYear,endYear);

                    xyGraphStartDatePanel.setTime(startDate);
                    xyGraphEndDatePanel.setTime(endDate);

                    dataModelStartDatePanel.resetYearCombo(startYear,endYear);
                    dataModelEndDatePanel.resetYearCombo(startYear,endYear);

                    dataModelStartDatePanel.setTime(startDate);
                    dataModelEndDatePanel.setTime(endDate);

                    statisticsStartDatePanel.resetYearCombo(startYear,endYear);
                    statisticsEndDatePanel.resetYearCombo(startYear,endYear);

                    statisticsStartDatePanel.setTime(startDate);
                    statisticsEndDatePanel.setTime(endDate);

                    movingAverageStartDatePanel.resetYearCombo(startYear,endYear);
                    movingAverageEndDatePanel.resetYearCombo(startYear,endYear);

                    movingAverageStartDatePanel.setTime(startDate);
                    movingAverageEndDatePanel.setTime(endDate);

                    correlationStartDatePanel.resetYearCombo(startYear,endYear);
                    correlationEndDatePanel.resetYearCombo(startYear,endYear);

                    correlationStartDatePanel.setTime(startDate);
                    correlationEndDatePanel.setTime(endDate);


                    selectStartDatePanel.resetYearCombo(startYear,endYear);
                    selectEndDatePanel.resetYearCombo(startYear,endYear);

                    selectStartDatePanel.setTime(startDate);
                    selectEndDatePanel.setTime(endDate);


                } //else
            } //public void valueChanged(ListSelectionEvent e)
        });
    } else {
        dataTable.setRowSelectionAllowed(false);
    }



  } //public DataManager();





  //Method addComponent for adding components in panels with GridBagLayout


  private void addComponent (Container aContainer, Component c, int row, int column, int width, int height) {


    //set gridx and gridy
    gbConstraints.gridx = column;
    gbConstraints.gridy = row;

    //set gridwidth and gridheight
    gbConstraints.gridwidth = width;
    gbConstraints.gridheight = height;

    //set constraints
    gbLayout.setConstraints(c,gbConstraints);
    aContainer.add(c);


  } //private void addComponent (Container aContainer, Component c, int row, int column, int width, int height)











  public void addToDataSet(ClientDataSet aDataSet) {

    boolean success = dataManagerJBean.addToDataSet(aDataSet);

    if(success) {

        GeneralTableModel tm = (GeneralTableModel) dataTable.getModel();
        Vector rowVector = aDataSet.getDataSetVector();

        tm.addRow(rowVector);
        dataTable.setModel(tm);

    } //if(success)

    //System.out.println("Hashtable size = " + dataSetHashtable.size());


  } //public void addToDataSet(aDataSet)










    private void removeFromDataSet() {

        //dataSetHashtable.remove(currentDataSet);

        String key = (String)currentRow.elementAt(0);
        dataManagerJBean.removeFromDataSet(key);

        GeneralTableModel tm = (GeneralTableModel) dataTable.getModel();

        tm.removeRow(currentRow);
        dataTable.setModel(tm);

        dataTable.clearSelection();
        processDoItButton.setEnabled(false);

        Vector historyRow = new Vector();
        historyRow.add(currentRow.elementAt(1));
        historyRow.add(currentRow.elementAt(2));
        historyRow.add(currentRow.elementAt(3));

        firePropertyChange(IDSSAppConstants.disposeData,new Boolean(false),historyRow);

        //System.out.println("Hashtable size = " + dataSetHashtable.size());

    } //private void removeFromDataSet()







    public void stateChanged(ChangeEvent ce) {

        if (ce.getSource() == dataModelIterationsSlider) {

            if (dataModelIterationsSlider.getValueIsAdjusting()) {      //slider is being dragged

                numberOfFourierIterations = dataModelIterationsSlider.getValue();

            } //if (dataModelIterationsSlider.getValueIsAdjusting())
            

        } //if (ce.getSource() == dataModelIterationsSlider)

    } //public void stateChanged(ChangeEvent e)







  public void itemStateChanged (ItemEvent ie) {

    if (ie.getSource() == processTypesCombo) {

      CardLayout cl = (CardLayout) (processFurtherOptionsPanel.getLayout());
      cl.show(processFurtherOptionsPanel, (String) ie.getItem());

    }//if (ie.getSource == processTypesCombo) 

    else if (ie.getSource() == selectCombo) {

        selectDataModelButton.setEnabled(true);
        tidalModelKey = (String) selectCombo.getSelectedItem();
        //TidalModel currentTidalModel = (TidalModel) tidalModelhashtable.get(key);
        System.out.println("Current tidal model : " + tidalModelKey);
        if(tidalModelKey.equals("None"))
            selectDataModelButton.setEnabled(false);

    } //else if (ie.getSource() == selectCombo)





  } //public void itemStateChanged (ItemEvent ie)







  public void actionPerformed(ActionEvent ae) {

    if (ae.getActionCommand().equals("doIt")) {

      String processOption = (String) processTypesCombo.getSelectedItem();

      System.out.println("do some process with " + processOption);

      if (processOption.equals("Table")) {

        //ClientDataSet ds = (ClientDataSet) dataSetHashtable.get(currentDataSet);
        //TabularDisplay tabularDisplay =
            //ds.makeTable(tableStartDatePanel.getTimestamp(),tableEndDatePanel.getTimestamp());

        String key= (String)currentRow.elementAt(0);
        TabularDisplay tabularDisplay =
                            dataManagerJBean.getTable(key,tableStartDatePanel.getTimestamp(),
                                    tableEndDatePanel.getTimestamp());


        if (tabularDisplay != null) {

            addToModelView(tabularDisplay);
        }
        else {
            JOptionPane.showMessageDialog (null, "No data found within the given range");
        }

      } //if (processOption.equals("Table"))


      else if (processOption.equals("XYGraph")) {

        //ClientDataSet ds = (ClientDataSet) dataSetHashtable.get(currentDataSet);
        //drawXYGraph(ds);

        String key= (String)currentRow.elementAt(0);
        String selectedGraph = (String)superimposeCombo.getSelectedItem();

        Timestamp start = xyGraphStartDatePanel.getTimestamp();
        Timestamp end = xyGraphEndDatePanel.getTimestamp();

        String startDateString = xyGraphStartDatePanel.getYear() + "/" +
                                 xyGraphStartDatePanel.getMonth() + "/" +
                                 xyGraphStartDatePanel.getDay();

        String endDateString = xyGraphEndDatePanel.getYear() + "/" +
                                 xyGraphEndDatePanel.getMonth() + "/" +
                                 xyGraphEndDatePanel.getDay();

        String stationName = (String)currentRow.elementAt(1);

        String graphKey = stationName + "," +
                                    startDateString + "-" +
                                    endDateString;

        GraphicalDisplay2 gDisp = dataManagerJBean.drawXYGraph(key,graphKey,start,end,selectedGraph);

        if(gDisp != null) {

            gDisp.addPropertyChangeListener(this);
            addToModelView(gDisp);
            superimposeCombo.addItem(graphKey);

        } //


      } //else if (processOption.equals("XYGraph"))


      else if (processOption.equals("Statistics")) {


      }



      else if (processOption.equals("Devise Tidal Model")) {

        System.out.println("Tidal model selected");

        String key = (String)currentRow.elementAt(0);
        Timestamp start = dataModelStartDatePanel.getTimestamp();
        Timestamp end = dataModelEndDatePanel.getTimestamp();

        Vector tidalModelRow = dataManagerJBean.makeTidalModel(key,start,end,numberOfFourierIterations);

        if(tidalModelRow != null) {

            String tmKey = (String)tidalModelRow.elementAt(0);
            selectCombo.addItem(tmKey);

            GeneralTableModel tm = (GeneralTableModel) dataTable.getModel();

            tm.addRow(tidalModelRow);
            dataTable.setModel(tm);

        } //if(tidalModelRow != null)



      } //else if (processOption.equals("Fit Data Model"))




      else if (processOption.equals("Moving Average")) {


      }


      else if (processOption.equals("Correlation")) {


      }




      else if (processOption.equals("Dispose")) {

            removeFromDataSet();
      }

    } //if (ae.getActionCommand().equals("doIt"))


    else if (ae.getActionCommand().equals("selectDataModel")) {

        if(!tidalModelKey.equals("None")) {


            dataManagerJBean.setTidalModel(tidalModelKey);

        } //if(!tidalModelKey.equals("None"))

    } //else if (ae.getActionCommand().equals("selectDataModel"))


  } //public void actionPerformed(ActionEvent ae)








    public boolean containsSql(String sqlString) {

        return dataManagerJBean.containsSql(sqlString);

    } //public boolean containsSql(String sqlString)





    private void addToModelView(DisplayFrame panel) {

        firePropertyChange(IDSSAppConstants.addToModelView,null,panel);

    } //private void addToModelView(DisplayFrame panel)





    public void propertyChange(PropertyChangeEvent evt) {


        if(evt.getPropertyName().equals(IDSSAppConstants.internalFrameClosing)) {

            String key = (String)evt.getNewValue();
            superimposeCombo.removeItem(key);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.internalFrameClosing))


        if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel)) {

            firePropertyChange(IDSSAppConstants.setTidalModel,evt.getOldValue(),evt.getNewValue());

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel))




    } //public void propertyChange(PropertyChangeEvent evt) 






} //public class DataManager extends DisplayFrame



