package iDSS.tidalData;


import java.sql.Timestamp;
import java.util.*;
import java.io.*;




public class TidalModel implements Serializable {


    private Vector fourierA,fourierB;
    private double fourierC;
    private int numberOfIterations;

    private String basisStation;
    private Timestamp basisStart,basisEnd;
    private int weightage;
    private double period;


    public TidalModel(Vector a,Vector b,double c,int iterations,
                        String station,Timestamp start,Timestamp end,double timePeriod) {

        fourierA = a;
        fourierB = b;
        fourierC = c;

        numberOfIterations = iterations;

        basisStation = station;
        basisStart = start;
        basisEnd = end;

        period = timePeriod;

        weightage = 1;

    } //public TidalModel(...)




    public Vector getFourierA() {

        return fourierA;

    } //public Vector getFourierA()





    public Vector getFourierB() {

        return fourierB;

    } //public Vector getFourierB()





    public double getFourierC() {

        return fourierC;

    } //public double getFourierC()





    public int getFourierIterations() {

        return numberOfIterations;

    } //public int getFourierIterations()





    public String getBasisStation() {

        return basisStation;

    } //public String getBasisStation()





    public Timestamp getBasisStart() {

        return basisStart;

    } //public Timestamp getBasisStart()





    public Timestamp getBasisEnd() {

        return basisEnd;

    } //public Timestamp getBasisEnd()




    public void setWeightage(int wt) {

        weightage = wt;

    } //public void setWeightage()



    public int getWeightage() {

        return weightage;

    } //public int setWeightage()




    public double getFourierPeriod() {

        return period;

    } //public double getFourierPeriod()




    public static void main(String args[]) {


        Vector a = new Vector();
        Vector b = new Vector();
        double c = 0;
        int iterations = 0;
        String station = "station";
        Timestamp start = new Timestamp(0);
        Timestamp end = new Timestamp(1000000);
        double period = 10;

        TidalModel tm = new TidalModel(a,b,c,iterations,station,start,end,period);
        System.out.println("c,iterations,station,start,end \n" +
                                tm.getFourierC() + "\n" +
                                tm.getFourierIterations() + "\n" +
                                tm.getBasisStation() + "\n" +
                                tm.getBasisStart() + "\n" +
                                tm.getBasisEnd());
        


    } //public static void main(String args[]) 



} //public class TidalModel

