package iDSS.tidalData;

import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.IllegalArgumentException;
import java.sql.Timestamp;


public class TimestampPanel extends JPanel implements ItemListener {

  private JComboBox yearCombo;
  private JComboBox monthCombo;
  private JComboBox dayCombo;
  private JComboBox hourCombo;
  private JComboBox minuteCombo;
  private JComboBox secondCombo;

  private JLabel yearLabel;
  private JLabel monthLabel;
  private JLabel dayLabel;
  private JLabel hourLabel;
  private JLabel minuteLabel;
  private JLabel secondLabel;

  private JLabel identifierLabel;


  public TimestampPanel (String identifier, int startYear, int endYear) {

    identifierLabel = new JLabel(identifier,JLabel.CENTER);

    Vector yearComboFiller = new Vector();
    Vector monthComboFiller = new Vector();
    Vector dayComboFiller = new Vector();
    Vector hourComboFiller = new Vector();
    Vector minuteComboFiller = new Vector();

    for(int i=startYear;i<=endYear;i++) {
      yearComboFiller.add(String.valueOf(i));
    }

    yearCombo = new JComboBox(yearComboFiller);

    for(int i=1;i<=12;i++) {
      monthComboFiller.add(String.valueOf(i));
    }

    monthCombo = new JComboBox(monthComboFiller);

    for(int i=1;i<=31;i++) {
      dayComboFiller.add(String.valueOf(i));
    }

    dayCombo = new JComboBox(dayComboFiller);


    for(int i=0;i<=23;i++) {
      hourComboFiller.add(String.valueOf(i));
    }

    hourCombo = new JComboBox(hourComboFiller);


    for(int i=0;i<=59;i++) {
      minuteComboFiller.add(String.valueOf(i));
    }

    minuteCombo = new JComboBox(minuteComboFiller);
    secondCombo = new JComboBox(minuteComboFiller);


    yearCombo.addItemListener(this);
    monthCombo.addItemListener(this);
    dayCombo.addItemListener(this);
    hourCombo.addItemListener(this);
    minuteCombo.addItemListener(this);
    secondCombo.addItemListener(this);



    yearLabel = new JLabel("Year");
    monthLabel = new JLabel("Month");
    dayLabel = new JLabel("Day");
    hourLabel = new JLabel("Hour");
    minuteLabel = new JLabel("Minute");
    secondLabel = new JLabel("Second");

    setLayout(new FlowLayout());

    add(identifierLabel);
    add(yearCombo);
    add(monthCombo);
    add(dayCombo);
    add(hourCombo);
    add(minuteCombo);
    add(secondCombo);


  } //public TimestampPanel ()



    public void resetYearCombo(int startYear, int endYear) {

        //System.out.println("Resetting yearCombo with " + startYear + " and " + endYear);
        yearCombo.removeAllItems();

        for(int i=startYear;i<=endYear;i++) {
          yearCombo.addItem(String.valueOf(i));
          //System.out.println("adding .. " + i);
        }


    } //public void resetYearCombo(int startYear, int endYear)




  public String getYear() {

    String aString = (String) yearCombo.getSelectedItem();
    return aString;

  }


  public String getMonth() {

    String aString = (String) monthCombo.getSelectedItem();
    return aString;

  }

  public String getDay() {

    String aString = (String) dayCombo.getSelectedItem();
    return aString;

  }

  public String getHour() {

    String aString = (String) hourCombo.getSelectedItem();
    return aString;

  }

  public String getMinute() {

    String aString = (String) minuteCombo.getSelectedItem();
    return aString;

  }

  public String getSecond() {

    String aString = (String) secondCombo.getSelectedItem();
    return aString;

  }





  public void setTime(Timestamp aTimestamp) {

    String aString = aTimestamp.toString();

    Calendar aCalendar = Calendar.getInstance();
    aCalendar.setTime(aTimestamp);


    int yearInt = aCalendar.get(Calendar.YEAR);
    String yearString = String.valueOf(yearInt);

    int monthInt = aCalendar.get(Calendar.MONTH) + 1;
    String monthString = String.valueOf(monthInt);

    int dayInt = aCalendar.get(Calendar.DAY_OF_MONTH);
    String dayString = String.valueOf(dayInt);

    int hourInt = aCalendar.get(Calendar.HOUR_OF_DAY);
    String hourString = String.valueOf(hourInt);

    int minuteInt = aCalendar.get(Calendar.MINUTE);
    String minuteString = String.valueOf(minuteInt);

    int secondInt = aCalendar.get(Calendar.SECOND);
    String secondString = String.valueOf(secondInt);


    yearCombo.setSelectedItem(yearString);
    monthCombo.setSelectedItem(monthString);
    dayCombo.setSelectedItem(dayString);
    hourCombo.setSelectedItem(hourString);
    minuteCombo.setSelectedItem(minuteString);
    secondCombo.setSelectedItem(secondString);




  } //public void setTime(Timestamp aTimestamp)











  public Timestamp getTimestamp() {

    String aString;
    Timestamp timestamp = new Timestamp(0);
    String year = getYear();
    String month = getMonth();
    String day = getDay();
    String hour = getHour();
    String minute = getMinute();
    String second = getSecond();
    
    aString = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;

    try {
      timestamp = Timestamp.valueOf(aString);
    }
    catch(java.lang.IllegalArgumentException exc) {
      System.out.println("Timestamp java.lang.IllegalArgumentException : " + exc);
    }

    return timestamp;

  }



  public void itemStateChanged(ItemEvent ie) {

    //System.out.println("Date Selected is : " + getTimestamp().toString());

  }






  public static void main(String args[]) {

    JFrame aFrame = new JFrame("Testing TimestampPanel");
    TimestampPanel aPanel = new TimestampPanel("Start",1960,1999);

    aFrame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent we) {
        System.exit(0);
      }
    });

    aFrame.getContentPane().add(aPanel,BorderLayout.CENTER);
    aFrame.pack();
    aFrame.setVisible(true);


    String date = "1962-02-22 20:30:30";
    Timestamp timestamp;

    try {
      timestamp = Timestamp.valueOf(date);
      aPanel.setTime(timestamp);
    }
    catch(java.lang.IllegalArgumentException exc) {
      System.out.println("Timestamp java.lang.IllegalArgumentException : " + exc);
    }



    aPanel.resetYearCombo(1991,1992);
    int startYear = Integer.parseInt(aPanel.getYear());
    System.out.println("startYear = " + startYear);

  } //main()


} //public class TimestampPanel extends JPanel

