package iDSS.utils;

import java.io.*;
import java.util.*;


public class DebugWriter {




    private static String debugFile = "error.log";




    public static void writeDebug(String s) {

       writeDebug(s,debugFile); 

    } //public void writeDebug(String s)





    public static void writeDebug(String s, String sFile) {

        FileOutputStream fos = null;

        try {
            //test for existence of the file
            File f = new File(sFile);

            if(!f.exists()) {
                fos = new FileOutputStream(f);
            } //if
            else {
                //append to the end of the file
                fos = new FileOutputStream(sFile,true);
            }

            s += "\n";
            //pre-pend a date time string
            fos.write ((new Date(System.currentTimeMillis()).toString() + ":" + s).getBytes());

        } // try

        catch (Exception ex) {

            System.out.println("Error writing debug log in writeDebug : " + ex);


        } //catch (Exception ex)

        finally {

            try {
                fos.close();
            } //try
            catch(Exception ex) {}

        } //finally

    } //public void writeDebug(String s, String sFile)


    public static void main (String args[]) {

        DebugWriter.writeDebug("Error 1");
        DebugWriter.writeDebug("Error 2");
        DebugWriter.writeDebug("Error 3 in another file", "error2.log");
        DebugWriter.writeDebug("Error 4 in the same file", "error.log");

    } //main()


} //public class DebugWriter
