package iDSS.utils;

import javax.swing.*;
import java.io.*;


public class FileNameDialog {


    private static int fileNum = 0;
    private static int imgFileNum = 0;


    public static String getTempFileName() {

        String s = IDSSAppConstants.tempFilePrefix + String.valueOf(fileNum) + IDSSAppConstants.tempFileSufix;
        fileNum++;
        return s;

    } //public static String getTempFileName()





    public static String getTempImgFileName() {

        String s = IDSSAppConstants.tempFilePrefix + String.valueOf(imgFileNum) + IDSSAppConstants.tempImgFileSufix;
        imgFileNum++;
        return s;

    } //public static String getTempImgFileName()






    public static File[] getInputFileNames(String approveButtonText,File path,JFrame aFrame) {

        JFileChooser fc;

        if (path != null)
            fc = new JFileChooser(path);
        else
            fc = new JFileChooser();

        fc.setApproveButtonText(approveButtonText);
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        File[] inputFiles = null;

        int returnVal = fc.showOpenDialog(aFrame);

        if (returnVal == JFileChooser.APPROVE_OPTION) {

            if (fc.getSelectedFiles().length>0) {

                inputFiles = fc.getSelectedFiles();

            } // (!fc.getSelectedFiles().length>0)

            else { // (!fc.getSelectedFiles().length>0)
                JOptionPane.showMessageDialog(aFrame,
                    "No file selected",
                    "Warning", JOptionPane.WARNING_MESSAGE);

            } // (!fc.getSelectedFiles().length>0)


        } //if (returnVal == JFileChooser.APPROVE_OPTION)


        return inputFiles;


    } //private static File[] getInputFileNames(String approveButtonText,File path,JFrame aFrame)









    public static File getInputFileName(String approveButtonText,File path,JFrame aFrame) {

        JFileChooser fc;

        if (path != null)
            fc = new JFileChooser(path);
        else
            fc = new JFileChooser();


        fc.setApproveButtonText(approveButtonText);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        File inputFile = null;

        int returnVal = fc.showOpenDialog(aFrame);

        if (returnVal == JFileChooser.APPROVE_OPTION) {

            if (fc.getSelectedFile().exists()) {

                inputFile = fc.getSelectedFile();
                System.out.println("Selected file : " + inputFile.toString());

            } // (!fc.getSelectedFile().exists())

            else { // (!fc.getSelectedFile().exists())
                JOptionPane.showMessageDialog(aFrame,
                    "Specified input file doesn't exists",
                    "Error", JOptionPane.ERROR_MESSAGE);

            } // (!fc.getSelectedFile().exists())


        } //if (returnVal == JFileChooser.APPROVE_OPTION)


        return inputFile;

    } //private static File getInputFileName(String approveButtonText,File path,JFrame aFrame)







    public static File getOutputFileName(String approveButtonText,File path,JFrame aFrame) {

        JFileChooser fc;

        if (path != null)
            fc = new JFileChooser(path);
        else
            fc = new JFileChooser();

        fc.setApproveButtonText(approveButtonText);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        File outputFile = null;

        int returnVal = fc.showSaveDialog(aFrame);

        if (returnVal == JFileChooser.APPROVE_OPTION) {

            if (!fc.getSelectedFile().exists()) {

                outputFile = fc.getSelectedFile();
                System.out.println("Selected file : " + outputFile.toString());

            } // (!fc.getSelectedFile().exists())

            else { // (fc.getSelectedFile().exists())

                int yesNo = JOptionPane.showConfirmDialog(aFrame,"Specified output file already exists, overwrite?",
                                                "Confirm",JOptionPane.YES_NO_OPTION);

                if(yesNo == JOptionPane.YES_OPTION) {

                    outputFile = fc.getSelectedFile();
                    outputFile.delete();

                } //if(yesNo == JOptionPane.YES_OPTION)


            } // (!fc.getSelectedFile().exists())

        } //if (returnVal == JFileChooser.APPROVE_OPTION)

        return outputFile;

    } //private static File getOutputFileName(String approveButtonText,File path,JFrame aFrame)




    public static File getOutputDirectory(String approveButtonText,String dialogTitle,File path,JFrame aFrame) {


        JFileChooser fc;
        File outDir = null;

/**
        if (saveLocationFile != null)
            fc = new JFileChooser(saveLocationFile);
        else
            fc = new JFileChooser();
**/

        fc = new JFileChooser();

        if(approveButtonText != null)
            fc.setApproveButtonText(approveButtonText);

        if(dialogTitle != null)
            fc.setDialogTitle(dialogTitle);

        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);


        int returnVal = fc.showOpenDialog(aFrame);

        if (returnVal == JFileChooser.APPROVE_OPTION) {

            if (fc.getSelectedFile().exists()) {

                outDir = fc.getSelectedFile();
                System.out.println("Selected file : " + outDir.toString());


            } // (!fc.getSelectedFile().exists())

            else { // (!fc.getSelectedFile().exists())
                JOptionPane.showMessageDialog(aFrame,
                    "Specified input file doesn't exists",
                    "Error", JOptionPane.ERROR_MESSAGE);

            } // (!fc.getSelectedFile().exists())


        } //if (returnVal == JFileChooser.APPROVE_OPTION)


        return outDir;


    } //public static File getOutputDirectory (String approveButtonText,String dialogTitle,File path,JFrame aFrame)


} //public class FileNameDialog
