package iDSS.xyGraph;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.BufferedImage;


public class GraphAxis {


    String axisName;
    Vector axisLabels;
    int axisStartX,axisStartY,axisEndX,axisEndY;
    Color axisColor;
    int ticLength;

    public GraphAxis(String name,Vector labels,int startX,int startY,int endX,int endY,Color color) {

        axisName = name;
        axisLabels = labels;
        axisStartX = startX;
        axisStartY = startY;
        axisEndX = endX;
        axisEndY = endY;

        if (color == null)
            axisColor = Color.black;
        else
            axisColor = color;

        ticLength = Math.min((endX-startX)/100,(endY-startY)/100);
        ticLength = Math.max(ticLength,7);



        System.out.println("axisName,axisStartX,axisStartY,axisEndX,axisEndY\n" +
                            axisName + ", " + axisStartX + ", " + axisStartY + ", " + axisEndX + ", " + axisEndY);


    } //public GraphAxis(String name,int numTics,Vector labels)




    public void drawXAxis(Graphics g) {

        System.out.println("In GraphAxis drawXAxis()");

        g.setColor(axisColor);
        g.drawLine(axisStartX,axisStartY,axisEndX,axisEndY);

        int numTics = axisLabels.size();

        //draw xAxis tics
        int ticDist = (axisEndX-axisStartX)/(numTics-1);

        for(int i=0;i<numTics;i++) {
            g.drawLine((axisStartX+i*ticDist),axisStartY,(axisStartX+i*ticDist),(axisStartY-ticLength));

        }//for(int i=;i<numTics;i++)


        //draw axis labels
        for(int i=0;i<numTics;i++) {
            g.drawString((String)axisLabels.elementAt(i),(axisStartX+i*ticDist-ticDist/5),(axisStartY+2*ticLength));

        }//for(int i=;i<numTics;i++)

        Font font = g.getFont();
        g.setFont(new Font(font.getName(),Font.BOLD,font.getSize()));

        g.drawString(axisName,axisStartX,(axisStartY+4*ticLength));

        g.setFont(font);


    } //public void drawXAxis(g)











    public void drawYAxis(Graphics g) {

        System.out.println("In GraphAxis drawYAxis()");

        g.setColor(axisColor);
        g.drawLine(axisStartX,axisStartY,axisEndX,axisEndY);

        int numTics = axisLabels.size();

        //draw xAxis tics
        int ticDist = Math.abs(axisEndY-axisStartY)/(numTics-1);

        for(int i=0;i<numTics;i++) {
            g.drawLine(axisStartX,(axisStartY-i*ticDist),(axisStartX+ticLength),(axisStartY-i*ticDist));

        }//for(int i=;i<numTics;i++)


        //draw axis labels
        for(int i=0;i<numTics;i++) {
            g.drawString((String)axisLabels.elementAt(i),(axisStartX-5*ticLength),(axisStartY-i*ticDist));

        }//for(int i=;i<numTics;i++)

        Font font = g.getFont();
        g.setFont(new Font(font.getName(),Font.BOLD,font.getSize()));

        g.drawString(axisName,axisStartX,(axisEndY-2*ticLength));

        g.setFont(font);


    } //public void drawYAxis(g)













    public void setName(String name) {

        axisName = name;

    }

    public void addName(String name) {

        axisName = axisName + ", " + name;

    }



    public String getName() {

        return axisName;

    }



    public void setLabels(Vector labels) {

        axisLabels = labels;

    }



    public Vector getLabels() {

        return axisLabels;

    }






} //public class GraphAxis
