package iDSS.xyGraph;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import java.awt.image.*;
import javax.swing.event.*;



import iDSS.*;
import iDSS.gridDisp.*;
import iDSS.disp.*;
import iDSS.utils.*;




public class GraphicalDisplay2 extends DisplayFrame {


    //private DrawingPanel aCanvas;
    private DrawingPanel2 aCanvas;
    private JScrollPane aScrollPane;
    private String graphTitle;
    private Vector graphs;
    private Graph parentGraph;
    private String key;



    public GraphicalDisplay2(int width,int height) {

        super ("Graphical View",true,true,true,true,null);

        parentGraph = null;

        setPreferredSize (new Dimension(width,height));
        aCanvas = new DrawingPanel2(width,height,this);
        aScrollPane = new JScrollPane(aCanvas);
        getContentPane().add(aScrollPane);
        pack();
        setVisible(true);

    }//public GraphicalDisplay2(int cancasX,int canvasY)





    public GraphicalDisplay2(String title,int width,int height) {

        super (title,true,true,true,true,null);

        parentGraph = null;
        key = title;

        setPreferredSize (new Dimension(width,height));
        aCanvas = new DrawingPanel2(width,height,this);
        aScrollPane = new JScrollPane(aCanvas);
        getContentPane().add(aScrollPane);
        pack();
        setVisible(true);

    }//public GraphicalDisplay2(int cancasX,int canvasY)







    public void setParentGraph(Graph aGraph) {

        parentGraph = aGraph;

    } //public void setParentGraph()











    public void resizeCanvas() {


        firePropertyChange(IDSSAppConstants.drawGraph,new Integer(0),new Integer(1));

/**
        if (parentGraph != null) {
            System.out.println("In GraphicalDisplay2.java, Canvas resized, parentGraph not null");
            parentGraph.drawGraph();
        }
**/

    } //public void resizeCanvas()















    public void addGraph(Graph graph) {

        //graphs.add(graph);

    } //public void addGraph(Graph)




    public int getCanvasX() {

        int x = aCanvas.getCanvasX();
        System.out.println("GraphicalDisplay2:getCanvasX() = " + x);
        return x;

    }//public int getCanvasX()




    public int getCanvasY() {

        int y = aCanvas.getCanvasY();
        System.out.println("GraphicalDisplay2:getCanvasY() = " + y);
        return y;

    }//public int getCanvasY()





    public BufferedImage getCanvas() {

        System.out.println("GraphicalDisplay2:getCanvas()");
        BufferedImage bi = aCanvas.getCanvas();
        System.out.println("returned from DrawingPanel2:getCanvas()");
        return bi;

    } //public BufferedImage getCanvas() 




    public void refreshCanvas(BufferedImage image) {

        aCanvas.refreshCanvas(image);

    } //public void refresjCanvas()



    public void drawXYGraph(String title, double[] xValues, double[] yValues) {

        graphTitle = graphTitle+title;
        setTitle(graphTitle);
        aCanvas.drawXYGraph(xValues,yValues);

    }//public void drawXYGraph(String title, double[] xValues, double[] yValues)




    public void clearBuffer() {

        aCanvas.clearBuffer();

    } //public void clearBuffer()







    public void internalFrameClosing(InternalFrameEvent e) {

        firePropertyChange(IDSSAppConstants.internalFrameClosing,null,key);

    }//public void internalFrameClosing(InternalFrameEvent e)









    public static void main(String args[]) {

        JFrame aFrame = new JFrame("GraphicalDisplay test");

        aFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });


        GraphicalDisplay2 aCanvas = new GraphicalDisplay2(300,200);

        JDesktopPane dPane = new JDesktopPane();

        dPane.putClientProperty("JDesktopPane.dragMode", "outline");
        dPane.add(aCanvas);
        aFrame.setContentPane(dPane);

        aFrame.pack();
        aFrame.setSize(500,400);
        aFrame.setVisible(true);

        double[] x = {0,1,2,3,4,5};
        double[] y = {0,1,4,9,16,25};

        aCanvas.drawXYGraph("Graph view",x,y);

    }//main()


}

