package iDSS.xyGraph;

import java.awt.*;
import java.util.*;


public class Legend {


    private Hashtable legendSet;
    private int x1,y1;

    final int LEGEND_WIDTH = 160;
    final int LEGEND_HEIGHT = 20;

    final int LEGEND_LM = 5;
    final int LEGEND_STRING_WIDTH = 100;
    final int LEGEND_LINE_LENGTH = 50;

    public Legend(String sqlString, String name, Color color,int startX,int startY) {

        x1 = startX;
        y1 = startY;

        legendSet = new Hashtable();

        Vector legendVector = new Vector();
        legendVector.add(name);
        legendVector.add(color);

        legendSet.put(sqlString,legendVector);

    } //public Legend(String name, Color color,int x1,inty1,intx2,int y2)



    public void drawLegend(Graphics g) {

        int numberOfLegends = legendSet.size();
        int legendWidth = LEGEND_WIDTH;
        int legendHeight = (numberOfLegends+1)*LEGEND_HEIGHT;

        g.setColor(Color.white);
        //g.setXORMode(Color.cyan);
        g.fillRect(x1,y1-legendHeight,legendWidth,legendHeight);

        g.setColor(Color.black);
        g.drawRect(x1,y1-legendHeight,legendWidth,legendHeight);

        Enumeration legends = legendSet.elements();

        int i = 0;
        while(legends.hasMoreElements()) {

            i++;

            Vector vector = (Vector) legends.nextElement();
            String name = (String) vector.elementAt(0);
            Color color = (Color) vector.elementAt(1);

            g.drawString(name,x1+LEGEND_LM,y1-legendHeight+i*LEGEND_HEIGHT);

            g.setColor(color);
            g.drawLine(x1+LEGEND_LM+LEGEND_STRING_WIDTH,y1-legendHeight+i*LEGEND_HEIGHT,
                        x1+LEGEND_LM+LEGEND_STRING_WIDTH+LEGEND_LINE_LENGTH,y1-legendHeight+i*LEGEND_HEIGHT);

            g.setColor(Color.black);


        } //while(legemds.hasMoreElements())

    } //public void drawLegend(Graphics g)


    public void setX(int x) {

        x1 = x;

    } //public void setX(int x)


    public void setY(int y) {

        y1 = y;

    } //public void setY(int y)



    public void addToLegend(String sql,String name,Color color) {

        Vector vector = new Vector();

        vector.add(name);
        vector.add(color);

        legendSet.put(sql,vector);

    } //public void addToLegend(String sql,String name,Color color)


}
