/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.grids;

import java.util.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.sql.Timestamp;

import helpers.*;
import utils.*;
import java.io.*;




//client classes
import iDSS.grids.*;

public class GridsClient {

    public static void main(String[] args) {

        try {
            Context initial = new InitialContext();
            Object objref = initial.lookup("GridsEJB");

            GridsHome home = 
               (GridsHome)PortableRemoteObject.narrow(objref, 
                                            GridsHome.class);

/**
            Timestamp t = new Timestamp(System.currentTimeMillis());
            String ipFile = "130.159.78.177,F:\\iDSSApplet\\iDSS\\demGrids\\highGround.txt";
            String ip = "130.159.78.177";
            String fileName = "f:\\iDSSApplet\\iDSS\\demGrids\\normalDEM.txt";
            File file = new File(fileName);
            Grid g = new Grid("nameOfGrid",0,0,file);
            g.read();
            ServerGrid sg = g.getServerGrid();
            System.out.println("SG created");

            Grids grids = home.create(ipFile,ip,fileName,t,sg);
            System.out.println("Grids created");


            Grids felix = home.findByPrimaryKey(ipFile);
            System.out.println("felix found");
**/

            //String ipFile = "130.159.78.177,F:\\iDSSApplet\\iDSS\\demGrids\\highGround.txt";
            //Grids felix = home.findByPrimaryKey(ipFile);


            Collection c = home.findAll();

            Iterator allGrids = c.iterator();


            while(allGrids.hasNext()) {

                Grids felix = (Grids)allGrids.next();

                System.out.println("Station name : " + felix.getIpFileName());

                System.out.println("Station name : " + felix.getIp());
                System.out.println("Station name : " + felix.getFileName());
                System.out.println("Station name : " + felix.getCreatDate().toString());
                System.out.println("Station name : " + felix.getGrid().getName());


                ServerGrid g2 = felix.getGrid();

                System.out.println("g2.getName() : " + g2.getName());
                System.out.println("g2.getType() : " + g2.getType());
                System.out.println("g2.getUnits() : " + g2.getUnits());
                System.out.println("g2.getFileName() : " + g2.getFileName());
                System.out.println("g2.getCellSize() : " + g2.getCellSize());
                System.out.println("g2.getNRows() : " + g2.getNRows());
                System.out.println("g2.getNColumns() : " + g2.getNColumns());
                System.out.println("g2.getXLLCorner() : " + g2.getXLLCorner());
                System.out.println("g2.getYLLCorner() : " + g2.getYLLCorner());
                System.out.println("g2.getNoDataValue() : " + g2.getNoDataValue());


                Vector z = g2.getZ();


                for(int i=0;i<z.size();i++) {

                    Vector oneRow = (Vector)z.elementAt(i);
                    System.out.println("");

                    for(int j=0;j<oneRow.size();j++) {

                        String s = (String)oneRow.elementAt(j);
                        System.out.print(s + "  ");

                    } //for(int j=0;oneRow.size();j++)

                } //for(int i=0;i<z.size();i++)


            }//while(allGrids.hasNext())


            //felix.remove();
            //System.out.println("felix removed");

/**

           Collection c = home.findAll();
           Iterator i=c.iterator();

           while (i.hasNext()) {
                Grids t = (Grids)i.next();
                System.out.println("Station name : " + t.getStationName());
                System.out.println("Start date   : " + t.getStartDate().toString());
                System.out.println("End date     : " + t.getEndDate().toString());
                System.out.println("Data table   : " + t.getDataTable());
           }

***/

       } //try


       catch (Exception ex) {

           System.err.println("Caught an exception." );
           ex.printStackTrace();

       } //catch (Exception ex)

   }//public static void main(String[] args)

} 
