/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.slr;

import java.util.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.sql.Timestamp;



public class SLRClient {

   public static void main(String[] args) {

       try {
           Context initial = new InitialContext();
           Object objref = initial.lookup("SLREJB");

           SLRHome home = 
               (SLRHome)PortableRemoteObject.narrow(objref, 
                                            SLRHome.class);


            SLR aSLR = home.create("scenName","storyLineName","scenTableName");


            aSLR = home.findByPrimaryKey("scenName");

            System.out.println("Scenario name : " + aSLR.getName());
            System.out.println("StoryLine     : " + aSLR.getStoryLine());
            System.out.println("ScenarioTable : " + aSLR.getScenarioTable());

            aSLR.remove();



            Collection c = home.findAll();
            Iterator i=c.iterator();

            while (i.hasNext()) {
                SLR t = (SLR)i.next();
                System.out.println("Scenario name : " + t.getName());
                System.out.println("StoryLine     : " + t.getStoryLine());
                System.out.println("ScenarioTable : " + t.getScenarioTable());
            }//while()



        } //try


        catch (Exception ex) {

            System.err.println("Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

    }//public static void main(String[] args)

}
