/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */


package ejb.slrData;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import javax.rmi.*;
import java.rmi.*;
import utils.*;
import ejb.dataAccess.*;




public class SLRDataEJB implements EntityBean {



    private EntityContext context;
    private Data dataAccess;
    private String dbName = ServerConstants.slrDB;
    private String dataAccessSessionBean = ServerConstants.dataAccessBean;


    String scenarioName;
    int year;
    double sens1_5;
    double sens4_5;
    double sens2_5;
    double sens2_5nosulf;



    public PKey ejbCreate(String scenarioName,int year,double sens1_5,double sens4_5,
                                double sens2_5,double sens2_5nosulf)
                                    throws CreateException {


        try {

            insertRow(scenarioName,year,sens1_5,sens4_5,sens2_5,sens2_5nosulf);

        } //try

        catch (Exception ex) {

            throw new EJBException("SLRDataEJB.ejbCreate(): " + 
                ex.getMessage());

        } //catch (Exception ex)

        this.scenarioName = scenarioName;
        this.year = year;
        this.sens1_5 = sens1_5;
        this.sens4_5 = sens4_5;
        this.sens2_5 = sens2_5;
        this.sens2_5nosulf = sens2_5nosulf;

        return new PKey(scenarioName,year);

    } //public PKey ejbCreate(...)





    public PKey ejbFindByPrimaryKey(String scenarioName,int year) 
        throws FinderException {

        boolean result;

        try {
            result = selectByPrimaryKey(scenarioName,year);
        }

        catch (Exception ex) {
            throw new EJBException("SLRDataEJB.ejbFindByPrimaryKey(): " + 
                ex.getMessage());
        }
        if (result) {
            return new PKey(scenarioName,year);
        }
        else {
            throw new ObjectNotFoundException
                ("SLRDataEJB.ejbFindByPrimaryKey():Row for scenario " + scenarioName + " " +
                                        year + " not found.");
        }

    } //public PKey ejbFindByPrimaryKey(String scenarioName,int year)










    public Collection ejbFindByScenarioName(String scenarioName) 
        throws FinderException {

        Collection result = new ArrayList();

        try {
            result = selectByScenarioName(scenarioName);
        }

        catch (Exception ex) {
            throw new EJBException("SLRDataEJB.ejbFindByScenarioName(): " + 
                ex.getMessage());
        }


        return result;

    } //public Collection ejbFindByScenarioName(String scenarioName)









    public Collection ejbFindAll()
        throws FinderException {


        //System.out.println("SLRDataEJB.ejbFindAll() starts");

        Collection result = null;

        try {
            result = selectAll();
            
        }

        catch (Exception ex) {
            throw new EJBException("SLRDataEJB.ejbFindAll(): " + 
                ex.getMessage());
        }
        if (result.isEmpty()) {
            throw new ObjectNotFoundException("SLRDataEJB.ejbAll():No rows found.");
        }
        else {
            return result;
        }

    }//public Collection ejbFindAll()







    public void ejbRemove() {

        try {
            deleteRow(scenarioName,year);
        }

        catch (Exception ex) {
            throw new EJBException("SLRDataEJB.ejbRemove(): " + 
                ex.getMessage());
        }
    } //public void ejbRemove()






    public void setEntityContext(EntityContext context) {

        this.context = context;

        try {

            Context initial = new InitialContext();
            Object objref = initial.lookup(dataAccessSessionBean);

            DataHome home = 
                (DataHome)PortableRemoteObject.narrow(objref, 
                                            DataHome.class);

            dataAccess = home.create();


        } //try

        catch(NamingException e) {

            System.out.println("SLRDataEJB.setEntityContext(), NamingException : " + e.toString());
            e.printStackTrace();
            System.exit(0);

        } //catch(NamingException e)


        catch(RemoteException re) {

            System.out.println("SLRDataEJB.setEntityContext(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        catch(CreateException re) {

            System.out.println("SLRDataEJB.setEntityContext(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



   }//public void setEntityContext(EntityContext context)






    public void unsetEntityContext() {

        dataAccess = null;

    } //public void unsetEntityContext()





    public void ejbActivate() {

        //System.out.println("SLRDataEJB.ejbActivate()");

        PKey pKey = (PKey)context.getPrimaryKey();

        //System.out.println(pKey.toString());

        scenarioName = pKey.getScenarioName();

        //System.out.println("scenarioName : + scenarioName");

        year = pKey.getYear();

        //System.out.println("year : + year");

    }//public void ejbActivate()






   public void ejbPassivate() {

        scenarioName = null;
        year = 0;

   }//public void ejbPassivate()






    public void ejbLoad() {

        try {
            loadRow();
        } //try

        catch (Exception ex) {
           throw new EJBException("SLRDataEJB.ejbLoad(): " + 
              ex.getMessage());
        } //catch (Exception ex)
    }
   






   public void ejbStore() {

        try {
           storeRow();
        }//try

        catch (Exception ex) {
            throw new EJBException("ejbLoad: " + 
                ex.getMessage());
        }//catch (Exception ex)

    }//public void ejbStore()






    public void ejbPostCreate(String scenarioName,int year,double sens1_5,double sens4_5,
                                double sens2_5,double sens2_5nosulf) { }



/*********************** Business Methods *************************/


    public String getScenarioName() {

        return scenarioName;

    } //public String getScenarioName()



    public int getYear() {

        return year;

    } //public int getYear()




    public double getSens1_5() {

        return sens1_5;

    } //public double getSens1_5()



    public double getSens4_5() {

        return sens4_5;

    } //public double getSens4_5()



    public double getSens2_5() {

        return sens2_5;

    } //public double getSens2_5()



    public double getSens2_5nosulf() {

        return sens2_5nosulf;

    } //public double getSens2_5nosulf()






    public void setScenarioName(String scenario) {

        scenarioName = scenario;

    } //public void setScenarioName(String scenario)



    public void setYear(int y) {

        year = y;

    } //public void setYear(int y)




    public void setSens1_5(double d) {

        sens1_5 = d;

    } //public void setSens1_5(double d)



    public void setSens4_5(double d) {

        sens4_5 = d;

    } //public void setSens4_5(double d)



    public void setSens2_5(double d) {

        sens2_5 = d;

    } //public void setSens2_5(double d)



    public void setSens2_5nosulf(double d) {

        sens2_5nosulf = d;

    } //public void setSens2_5nosulf(double d)













/*********************** Database Routines *************************/


    private void insertRow (String scenarioName,int year,double sens1_5,double sens4_5,
                                double sens2_5,double sens2_5nosulf)
                                    throws SQLException {



        String sql = "insert into scenarioDetails " +
                    "(scenarioName,yearColumn,sens1_5,sens4_5,sens2_5,sens2_5nosulf) values " + 
                    "(" +
                    "'" + scenarioName + "'" + ","
                    + year + ","
                    + sens1_5 + ","
                    + sens4_5 + ","
                    + sens2_5 + ","
                    + sens2_5nosulf + ")";

        try {

            dataAccess.insert(sql,dbName);
            //System.out.println("SLRDataEJB.insertRow(), sql : " + sql);

        } //try

        catch(RemoteException re) {

            System.out.println("SLRDataEJB.insertRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


   } //private void insertRow (...)





    private void deleteRow(String scenarioName,int year) throws SQLException {

        String deleteStatement = "delete from scenarioDetails where scenarioName='" + scenarioName +
                                     "' and yearColumn=" + year;

        try {
            dataAccess.delete(deleteStatement,dbName);
            //System.out.println("SLRDataEJB.deleteRow(), deleteSql : " + deleteStatement);
        }

        catch(RemoteException re) {

            System.out.println("SLRDataEJB.deleteRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


    } //private void deleteRow(String scenarioName,int year) throws SQLException




    private boolean selectByPrimaryKey(String scenarioName,int year) 
                                        throws SQLException {

        boolean result = false;

        String selectStatement = "select scenarioName,yearColumn " +
                                    "from scenarioDetails where scenarioName='" +
                                     scenarioName + "' and yearColumn=" + year;

        try {
            DataSet ds = dataAccess.select(selectStatement,dbName);

            Vector rows = ds.getRowsOfDataVector();

            if(rows.size() > 0)
                result = true;

            return result;


        } //try

        catch(RemoteException re) {

            System.out.println("SLRDataEJB.selectByPrimaryKey(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)

        return result;

    } //private boolean selectByPrimaryKey(String scenarioName,int year)










    private Collection selectByScenarioName(String scenarioName) throws SQLException {


        String selectStatement = "select * from scenarioDetails where scenarioname='" + scenarioName + "'" ;

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLRDataEJB.selectByScenarioName(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        ArrayList a = new ArrayList();

        Vector rows = ds.getRowsOfDataVector();

        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            String name = (String)oneRow.elementAt(0);
            int year = Integer.parseInt(oneRow.elementAt(1).toString());

            PKey pKey = new PKey(name,year);

            a.add(pKey);

        } //for(int i=0;i<rows.size();i++)

        return a;



   } //private Collection selectByScenarioName(String scenarioName) throws SQLException











    private Collection selectAll() throws SQLException {


        //System.out.println("SLRDataEJB.selectAll() starts");
        String selectStatement = "select * from scenarioDetails" ;

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLRDataEJB.selectAll(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        //System.out.println("SLRDataEJB.selectAll() continues");

        ArrayList a = new ArrayList();

        Vector rows = ds.getRowsOfDataVector();

        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            String name = (String)oneRow.elementAt(0);
            int year = Integer.parseInt(oneRow.elementAt(1).toString());

            //System.out.println("name, year : " + name + ", " + year );

            PKey pKey = new PKey(name,year);

            a.add(pKey);

        } //for(int i=0;i<rows.size();i++)

        return a;



   } //private Collection selectAll()










    private void loadRow() throws SQLException {


        String selectStatement = "select * " +
                                    "from scenarioDetails where scenarioName='" +
                                     scenarioName + "' and yearColumn=" + year;

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLRDataEJB.loadRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        Vector rows = ds.getRowsOfDataVector();

        if(rows.size() > 0) {

            Vector oneRow = (Vector)rows.elementAt(0);

            this.scenarioName = (String)oneRow.elementAt(0);
            //this.year = ((Integer)oneRow.elementAt(1)).intValue();
            this.year = Integer.parseInt(oneRow.elementAt(1).toString());

            this.sens1_5 = ((Double)oneRow.elementAt(2)).doubleValue();

            this.sens4_5 = ((Double)oneRow.elementAt(3)).doubleValue();

            this.sens2_5 = ((Double)oneRow.elementAt(4)).doubleValue();

            this.sens2_5nosulf = ((Double)oneRow.elementAt(5)).doubleValue();

        } //if(rows.size() > 0)

        else {

            throw new NoSuchEntityException("SLRDataEJB.loadRow(), Row for  " + scenarioName + ", " + year +
                    " not found in database.");


        } //else



    } //private void loadRow() throws SQLException








    private void storeRow() throws SQLException {


        String updateStatement = "update scenarioDetails set " +
                            "scenarioName='" + scenarioName + "'," +
                            "yearColumn=" + year + "," +
                            "sens1_5=" + sens1_5 + "," +
                            "sens4_5=" + sens4_5 + "," +
                            "sens2_5=" + sens2_5 + "," +
                            "sens2_5nosulf=" + sens2_5nosulf + " " +
                            "where scenarioName='" + scenarioName + "' and " +
                            "yearColumn=" + year;



        try {
            int rowCount = dataAccess.update(updateStatement,dbName);

            if (rowCount == 0) {

                throw new EJBException("SLRDataEJB.storeRow(), Storing row for " + scenarioName +
                                        ", " + year + " failed.");

            } //if (rowCount == 0)

        } //try


        catch(RemoteException re) {

            System.out.println("SLRDataEJB.storeRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



    }//private void storeRow() throws SQLException 


} // SLRDataEJB

