/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */


package ejb.stations;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import javax.rmi.*;
import java.rmi.*;
import utils.*;
import ejb.dataAccess.*;




public class TidalStationsEJB implements EntityBean {


    private String dataCategory;
    private String dataType;
    private String dataSet;
    private String stationName;
    private Timestamp startDate;
    private Timestamp endDate;
    private String dataTable;

    private EntityContext context;
    private Data dataAccess;
    private String dbName = ServerConstants.tidalStationDB;
            //"java:comp/env/jdbc/TidalStations";
    private String dataAccessSessionBean = ServerConstants.dataAccessBean;
            //"java:comp/env/ejb/DataAccessBean";



    public String ejbCreate(String dataCategory,String dataType,String dataSet,
                                String stationName,Timestamp startDate,
                                Timestamp endDate,String dataTable)
                                throws CreateException {


       try {

          insertRow(dataCategory,dataType,dataSet,stationName,startDate,endDate,dataTable);

       } //try

       catch (Exception ex) {

           throw new EJBException("ejbCreate: " + 
              ex.getMessage());

       } //catch (Exception ex)

        this.dataCategory = dataCategory;
        this.dataType = dataType;
        this.dataSet = dataSet;
        this.stationName = stationName;
        this.startDate = startDate;
        this.endDate = endDate;
        this.dataTable = dataTable;

        return stationName;

    }





   public String ejbFindByPrimaryKey(String stationName) 
      throws FinderException {

      boolean result;

      try {
         result = selectByPrimaryKey(stationName);
       } catch (Exception ex) {
           throw new EJBException("ejbFindByPrimaryKey: " + 
              ex.getMessage());
       }
      if (result) {
         return stationName;
      }
      else {
         throw new ObjectNotFoundException
            ("Row for stationName " + stationName + " not found.");
      }
   }








   public Collection ejbFindAll()
      throws FinderException {

      Collection result;

      try {
         result = selectAll();
            
       } catch (Exception ex) {
           throw new EJBException("ejbFindInRange: " + 
              ex.getMessage());
       }
      if (result.isEmpty()) {
         throw new ObjectNotFoundException("No rows found.");
      }
      else {
         return result;
      }
   }




   public Collection ejbFindInRange(String start,String end)
      throws FinderException {

      Collection result;

      try {
         result = selectInRange(start, end);
            
       } catch (Exception ex) {
           throw new EJBException("ejbFindInRange: " + 
              ex.getMessage());
       }
      if (result.isEmpty()) {
         throw new ObjectNotFoundException("No rows found.");
      }
      else {
         return result;
      }
   }









   public void ejbRemove() {

      try {
         deleteRow(stationName);
       } catch (Exception ex) {
           throw new EJBException("ejbRemove: " + 
              ex.getMessage());
       }
   } 






    public void setEntityContext(EntityContext context) {

        this.context = context;


        try {

            Context initial = new InitialContext();
            Object objref = initial.lookup(dataAccessSessionBean);

            DataHome home = 
                (DataHome)PortableRemoteObject.narrow(objref, 
                                            DataHome.class);

            dataAccess = home.create();


        } //try

        catch(NamingException e) {

            System.out.println("TidalStationsEJB.setEntityContext(), NamingException : " + e.toString());
            e.printStackTrace();
            System.exit(0);

        } //catch(NamingException e)


        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.setEntityContext(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        catch(CreateException re) {

            System.out.println("TidalStationsEJB.setEntityContext(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



   }//public void setEntityContext(EntityContext context)






    public void unsetEntityContext() {

        dataAccess = null;

    } //public void unsetEntityContext()





    public void ejbActivate() {

        stationName = (String)context.getPrimaryKey();

    }//public void ejbActivate()






   public void ejbPassivate() {

      stationName = null;

   }//public void ejbPassivate()






    public void ejbLoad() {

        try {
            loadRow();
        } //try

        catch (Exception ex) {
           throw new EJBException("ejbLoad: " + 
              ex.getMessage());
        } //catch (Exception ex)
    }
   






   public void ejbStore() {

        try {
           storeRow();
        }//try

        catch (Exception ex) {
            throw new EJBException("ejbLoad: " + 
                ex.getMessage());
        }//catch (Exception ex)

    }//public void ejbStore()






    public void ejbPostCreate(String dataCategory,String dataType,String dataSet,
                                String stationName,Timestamp startDate,
                                Timestamp endDate,String dataTable) { }



/*********************** Business Methods *************************/


    public String getDataCategory() {

        return dataCategory;

    } //public String getDataCategory()



    public String getDataType() {

        return dataType;

    } //public String getDataType()




    public String getDataSet() {

        return dataSet;

    } //public String getDataSet()



    public String getStationName() {

        return stationName;

    } //public String getStationName()



    public Timestamp getStartDate() {

        return startDate;

    } //public Timestamp getStartDate()



    public Timestamp getEndDate() {

        return endDate;

    } //public Timestamp getEndDate()




    public String getDataTable() {

        return dataTable;

    } //public String getDataTable()



    public void setDataCategory(String s) {

        this.dataCategory = s;

    } //public void setDataCategory(String s)




    public void setDataType(String s) {

        this.dataType = s;

    } //public void setDataType(String s)


    public void setDataSet(String s) {

        this.dataSet = s;

    } //public void setDataSet(String s)





    public void setStationName(String s) {

        this.stationName = s;

    } //public void setStationName(String s)




    public void setStartDate(Timestamp t) {

        this.startDate = t;

    } //public void setStartDate(Timestamp t)





    public void setEndDate(Timestamp t) {

        this.endDate = t;

    } //public void setEndDate(Timestamp t)


    public void setDataTable(String s) {

        this.dataTable = s;

    } //public void setDataTable(String s)





/*********************** Database Routines *************************/


    private void insertRow (String dataCategory,String dataType,String dataSet,
                            String stationName,Timestamp startDate,
                            Timestamp endDate,String dataTable)
                        throws SQLException {



        String sql = "insert into tidalStations " +
                    "(dataCategory,dataType,dataSet,stationName,startDate,endDate,dataTable) values " + 
                    "(" +
                    "'" + dataCategory + "'" + "," +
                    "'" + dataType + "'" + "," +
                    "'" + dataSet + "'" + "," +
                    "'" + stationName + "'" + "," +
                    "'" + startDate.toString() + "'" + "," +
                    "'" + endDate.toString() + "'" + "," +
                    "'" + dataTable + "'" + ")";

        try {

            dataAccess.insert(sql,dbName);

        } //try

        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.insertRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


   } //private void insertRow (....)





    private void deleteRow(String stationName) throws SQLException {

        String deleteStatement = "delete from tidalStations where stationName='" + stationName + "'";

        try {
            dataAccess.delete(deleteStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.deleteRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)




    } //private void deleteRow(String stationName) throws SQLException




    private boolean selectByPrimaryKey(String stationName) 
                                        throws SQLException {

        boolean result = false;

        String selectStatement = "select stationName " +
                                    "from tidalStations where stationName='" + stationName + "'";

        try {
            DataSet ds = dataAccess.select(selectStatement,dbName);


            Vector rows = ds.getRowsOfDataVector();

            if(rows.size() > 0)
                result = true;

            return result;


        } //try

        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.selectByPrimaryKey(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)

        return result;

    } //private boolean selectByPrimaryKey(String stationName) 








    private Collection selectAll() throws SQLException {


        String selectStatement = "select * from tidalStations" ;

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.selectInRange(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)




        ArrayList a = new ArrayList();

        Vector rows = ds.getRowsOfDataVector();

        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            String station = (String)oneRow.elementAt(3);
            a.add(station);

        } //for(int i=0;i<rows.size();i++)

        return a;



   } //private Collection selectAll()

















    private Collection selectInRange(String start,String end) 
                                        throws SQLException {

/**
        String selectStatement = "select stationName from tidalStations where " +
                                "stationName between '" + start + "' and '" + end + "'";

**/

        String selectStatement = "select stationName from tidalStations where " +
                                "stationName>='" + start + "' and stationName<='" + end + "'";

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.selectInRange(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)




        ArrayList a = new ArrayList();

        Vector rows = ds.getRowsOfDataVector();

        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            String station = (String)oneRow.elementAt(3);
            a.add(station);

        } //for(int i=0;i<rows.size();i++)

        return a;



   } //private Collection selectInRange(String start,String end)





    private void loadRow() throws SQLException {


        String selectStatement =
            "select dataCategory,dataType,dataSet,stationName,startDate,endDate,dataTable " +
            "from tidalStations where stationName='" + stationName + "'";

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.loadRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



        Vector rows = ds.getRowsOfDataVector();

        if(rows.size() > 0) {

            Vector oneRow = (Vector)rows.elementAt(0);

            this.dataCategory = (String)oneRow.elementAt(0);
            this.dataType = (String)oneRow.elementAt(1);
            this.dataSet = (String)oneRow.elementAt(2);
            this.stationName = (String)oneRow.elementAt(3);
            this.startDate = (Timestamp)oneRow.elementAt(4);
            this.endDate = (Timestamp)oneRow.elementAt(5);
            this.dataTable = (String)oneRow.elementAt(6);

        } //if(rows.size() > 0)

        else {

            throw new NoSuchEntityException("Row for stationName " + stationName +
                    " not found in database.");


        } //else



    } //private void loadRow() throws SQLException








    private void storeRow() throws SQLException {


        String updateStatement = "update tidalStations set " +
                            "dataCategory='" + dataCategory + "'," +
                            "dataType='" + dataType + "'," +
                            "dataSet='" + dataSet + "'," +
                            "startDate='" + startDate.toString() + "'," +
                            "endDate='" + endDate.toString() + "'," +
                            "dataTable='" + dataTable + "'" +
                            " where stationName='" + stationName + "'";



        try {
            int rowCount = dataAccess.update(updateStatement,dbName);

            if (rowCount == 0) {

                throw new EJBException("Storing row for stationName " + stationName + " failed.");

            } //if (rowCount == 0)

        } //try


        catch(RemoteException re) {

            System.out.println("TidalStationsEJB.storeRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



    }//private void storeRow() throws SQLException 


} // TidalStationsEJB

