/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.tide;


import java.util.*;
import javax.ejb.*;
import javax.sql.*;
import java.sql.*;
import javax.naming.*;
import sun.jdbc.rowset.*;
import ejb.dataAccess.*;
import javax.rmi.*;
import java.rmi.*;


import ejb.dataAccess.*;
import utils.*;



public class TidalDataEJB implements SessionBean {



    private String dbName = ServerConstants.tidalDataDB;
    private String dataAccessSessionBean = ServerConstants.dataAccessBean;


    public void ejbCreate() throws CreateException {}



    private Data makeConnection() throws NamingException, SQLException {

        Data dataAccess = null;

        try {

            Context initial = new InitialContext();
            Object objref = initial.lookup(dataAccessSessionBean);

            DataHome home = 
                (DataHome)PortableRemoteObject.narrow(objref, 
                                            DataHome.class);

            dataAccess = home.create();


        } //try

        catch(NamingException e) {

            System.out.println("TidalDataEJB.makeConnection(), NamingException : " + e.toString());
            e.printStackTrace();
            System.exit(0);

        } //catch(NamingException e)


        catch(RemoteException re) {

            System.out.println("TidalDataEJB.makeConnection(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        catch(CreateException re) {

            System.out.println("TidalDataEJB.makeConnection(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        return dataAccess;

    } //private Data makeConnection()





    private void closeConnection(Data dataAccess) {

        dataAccess = null;

    } //private void closeConnection(Data dataAccess)






    public int insert(String table,Timestamp observDate,double observ,String dbName) {

        int i = 0;
        String sqlQuery = "insert into " + table + " (observ_date,observation) values " +
                            "('" + observDate.toString() + "'," + observ + ")";

        try {
            Data dataAccess = makeConnection();
            i = dataAccess.insert(sqlQuery,dbName);
            closeConnection(dataAccess);
        } //try

        catch(SQLException e) {
            System.out.println("sqlQuery : " + sqlQuery);
            System.out.println("TidalDataEJB.insert(), SQLException : " + e.toString());
        } //catch(SQLException e)

        catch(RemoteException e) {
            System.out.println("TidalDataEJB.insert(), RemoteException : " + e.toString());
            return 0;
        } //catch(RemoteException e)

        catch(NamingException e) {
            System.out.println("TidalDataEJB.insert(), NamingException : " + e.toString());
            return 0;
        } //catch(NamingException e)


        return i;

    } //public int insert(String table,Timestamp observDate,double observ,String dbName)






    public int update(String table,Timestamp ovservDate,double observ,String dbName) {

        int i = 0;
        String sqlQuery = "update " + table + " set " +
                            "observ_date='" + ovservDate.toString() + "'," +
                            "observation=" + observ;

        try {
            Data dataAccess = makeConnection();
            i = dataAccess.update(sqlQuery,dbName);
            closeConnection(dataAccess);
        }//try

        catch(SQLException e) {
            System.out.println("sqlQuery : " + sqlQuery);
            System.out.println("TidalDataEJB.update(), SQLException : " + e.toString());
        } //catch(SQLException e)

        catch(RemoteException e) {
            System.out.println("TidalDataEJB.update(), RemoteException : " + e.toString());
            return 0;
        } //catch(RemoteException e)

        catch(NamingException e) {
            System.out.println("TidalDataEJB.update(), NamingException : " + e.toString());
            return 0;
        } //catch(NamingException e)


        return i;

    } //public int update(String table,Timdetamp ovservDate,double observ,String dbName)





    public int delete(String table,Timestamp observDate,String dbName) {

        int i = 0;
        String sqlQuery = "delete from " + table + " where " +
                            "observ_date='" + observDate.toString() + "'";


        try {
            Data dataAccess = makeConnection();
            i = dataAccess.delete(sqlQuery,dbName);
            closeConnection(dataAccess);
        }//try


        catch(SQLException e) {
            System.out.println("sqlQuery : " + sqlQuery);
            System.out.println("TidalDataEJB.delete(), SQLException : " + e.toString());
        } //catch(SQLException e)

        catch(RemoteException e) {
            System.out.println("TidalDataEJB.delete(), RemoteException : " + e.toString());
            return 0;
        } //catch(RemoteException e)

        catch(NamingException e) {
            System.out.println("TidalDataEJB.delete(), NamingException : " + e.toString());
            return 0;
        } //catch(NamingException e)

        return i;

    } //public int delete(String table,Timestamp observdate,String dbName)





    public int delete(String table,Timestamp start,Timestamp end,String dbName) {

        int i = 0;
        String sqlQuery = "delete from " + table + " where " +
                            "observ_date>='" + start.toString() + "' and " +
                            "observ_date<='" + end.toString() + "'";


        try {
            Data dataAccess = makeConnection();
            i = dataAccess.delete(sqlQuery,dbName);
            closeConnection(dataAccess);
        }//try


        catch(SQLException e) {
            System.out.println("sqlQuery : " + sqlQuery);
            System.out.println("TidalDataEJB.delete(), SQLException : " + e.toString());
        } //catch(SQLException e)

        catch(RemoteException e) {
            System.out.println("TidalDataEJB.delete(), RemoteException : " + e.toString());
            return 0;
        } //catch(RemoteException e)

        catch(NamingException e) {
            System.out.println("TidalDataEJB.delete(), NamingException : " + e.toString());
            return 0;
        } //catch(NamingException e)

        return i;

    } //public int delete(String table,Timestamp start,Timestamp end,String dbName)









    public DataSet select(String table,Timestamp start,Timestamp end,String dbName) {

        DataSet ds = null;
        String selectStatement = "select * from " + table + " where " +
                                    "observ_date>='" + start.toString() + "' and " +
                                    "observ_date<='" + end.toString() + "'";

        try {
            Data dataAccess = makeConnection();
            ds = dataAccess.select(selectStatement,dbName);
            closeConnection(dataAccess);
        } //try


        catch(SQLException e) {
            System.out.println("selectStatement : " + selectStatement);
            System.out.println("TidalDataEJB.select(), SQLException : " + e.toString());
            return null;
        } //catch(SQLException e)

        catch(RemoteException e) {
            System.out.println("TidalDataEJB.select(), RemoteException : " + e.toString());
            return null;
        } //catch(RemoteException e)

        catch(NamingException e) {
            System.out.println("TidalDataEJB.select(), NamingException : " + e.toString());
            return null;
        } //catch(NamingException e)


        return ds;

    } //public DataSet select(String table,Timestamp start,Timestamp end,String dbName)











   public TidalDataEJB() {}
   public void ejbRemove() {} 
   public void ejbActivate() {}
   public void ejbPassivate() {}
   public void setSessionContext(SessionContext sc) {}






} //public class TidalDataEJB implements SessionBean
