/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.users;

import java.util.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.sql.Timestamp;



public class UserClient {

   public static void main(String[] args) {

       try {
           Context initial = new InitialContext();
           Object objref = initial.lookup("UserEJB");

           UserHome home = 
               (UserHome)PortableRemoteObject.narrow(objref, 
                                            UserHome.class);


            Timestamp t1 = new Timestamp(System.currentTimeMillis());
            Timestamp t2 = new Timestamp(System.currentTimeMillis()*10);

            String email = "sayeed.ahmed@strath.ac.uk";

            User sayeed = home.findByPrimaryKey(email);


            User felix = home.create("Felix","felix@strath.ac.uk",t1,0);
            User felix2 = home.create("Felix2","felix2@strath.ac.uk",t2,0);


            User f = home.findByPrimaryKey("felix@strath.ac.uk");

            System.out.println("Name             : " + f.getName());
            System.out.println("Email            : " + f.getEmail());
            System.out.println("Last visited     : " + f.getLastVisited().toString());
            System.out.println("Total time spent : " + f.getTotalTimeSpent());

            User f2 = home.findByPrimaryKey("felix2@strath.ac.uk");

            System.out.println("Name             : " + f2.getName());
            System.out.println("Email            : " + f2.getEmail());
            System.out.println("Last visited     : " + f2.getLastVisited().toString());
            System.out.println("Total time spent : " + f2.getTotalTimeSpent());

            Collection c = home.findAll();
            Iterator i=c.iterator();

            System.out.println("\nFull list\n");

            long l = 1000;
            long l2 = 2000;

            f.setTotalTimeSpent(l);
            f2.setTotalTimeSpent(l2);

            while (i.hasNext()) {
                User t = (User)i.next();

                System.out.println("Name             : " + t.getName());
                System.out.println("Email            : " + t.getEmail());
                System.out.println("Last visited     : " + t.getLastVisited().toString());
                System.out.println("Total time spent : " + t.getTotalTimeSpent());
            }


            f.remove();
            f2.remove();

       } //try


       catch (Exception ex) {

           System.err.println("UserClient.main(), caught an exception." );
           ex.printStackTrace();

       } //catch (Exception ex)

   }//public static void main(String[] args)

} 
