package helpers;

import java.io.*;
import java.util.*;
import java.sql.*;

import utils.*;


public class ServerGrid implements SQLData, Serializable {

    private int type;
    private String name;
    private int units;
    private String fileName;

    private double cellSize;
    private int nRows,nColumns;
    private double xLLCorner,yLLCorner;
    private double xURCorner,yURCorner;
    private int noDataValue = -9999;

    private File inFile,outFile;

    private Vector z;
    private double zMax = -9999999.0;
    private double zMin = 9999999.0;


    private String sql_type;



    public ServerGrid(String name,int type,int units,String fileName,
                        double cellSize,int nRows,int nColumns,double xLLCorner,double yLLCorner,
                        int noDataValue,Vector z) {

        this.name = name;
        this.type = type;
        this.units = units;
        this.fileName = fileName;


        this.cellSize = cellSize;
        this.nRows = nRows;
        this.nColumns = nColumns;
        this.xLLCorner = xLLCorner;
        this.yLLCorner = yLLCorner;
        this.noDataValue = noDataValue;
        this.z = z;


        System.out.println("ServerGrid.constructor(...), name : " + this.name);


    } //public ServerGrid(...)





    public ServerGrid() {

        this.name = "noName";
        this.type = 0;
        this.units = 0;
        this.fileName = "noFileName";


        this.cellSize = 0;
        this.nRows = 0;
        this.nColumns = 0;
        this.xLLCorner = 0;
        this.yLLCorner = 0;
        this.noDataValue = -9999;
        this.z = new Vector();

        System.out.println("ServerGrid.constructor(), name : " + this.name);

    } //public ServerGrid()





    public String getName() {

        return name;

    } //public String getName()


    public int getType() {

        return type;

    } //public int getType()


    public int getUnits() {

        return units;

    } //public int getUnits()


    public String getFileName() {

        return fileName;

    } //public String getFileName()



    public double getCellSize() {

        return cellSize;

    }//public double getCellSize()
        


    public int getNRows() {

        return nRows;

    }//public int getNRows()



    public int getNColumns() {

        return nColumns;

    }//public int getNColumns()


    public double getXLLCorner() {

        return xLLCorner;

    }//public double getXLLCorner()


    public double getYLLCorner() {

        return yLLCorner;

    }//public double getYLLCorner()


    public int getNoDataValue() {

        return noDataValue;

    }//public int getNoDataValue()



    public Vector getZ() {

        return z;

    }//public Vector getZ()


    public String toString() {

        return name;

    } //public String toString()




/****Methods for interface SQLData****/


    public String getSQLTypeName() {
      return sql_type;
    }



    public void readSQL(SQLInput stream, String sqlType)
                        throws SQLException {

        sql_type = sqlType;

        name = stream.readString();
        type = Double.valueOf(stream.readString()).intValue();
        units = Double.valueOf(stream.readString()).intValue();
        fileName = stream.readString();
        cellSize = Double.valueOf(stream.readString()).doubleValue();
        xLLCorner = Double.valueOf(stream.readString()).doubleValue();
        yLLCorner = Double.valueOf(stream.readString()).doubleValue();
        noDataValue = Double.valueOf(stream.readString()).intValue();
        nRows = Double.valueOf(stream.readString()).intValue();
        nColumns = Double.valueOf(stream.readString()).intValue();

        z = new Vector();

        for(int i=0;i<nRows;i++) {

            Vector oneRow = new Vector();

            for (int j=0;j<nColumns;j++) {

                String s = stream.readString();
                oneRow.add(s);

            } //for (int j=0;j<oneRow.size();j++)

            z.add(oneRow);

        } //for(int i=0;i<z.kength;i++)


        if(ServerConstants.debug) {

            System.out.println("ServerGrid.readSQL():");
            System.out.println("name : " + name);
            System.out.println("type : " + type);
            System.out.println("units : " + units);
            System.out.println("fileName : " + fileName);
            System.out.println("cellSize : " + cellSize);
            System.out.println("nRows : " + nRows);
            System.out.println("nColumns : " + nColumns);
            System.out.println("xLLCorner : " + xLLCorner);
            System.out.println("yLLCorner : " + yLLCorner);
            System.out.println("noDataValue : " + noDataValue);

        } //if(ServerConstants.debug)


    }//public void readSQL(SQLInput stream, String sqlType)



    public void writeSQL(SQLOutput stream) 
     throws SQLException {


        stream.writeString(name);
        stream.writeString(String.valueOf(type));
        stream.writeString(String.valueOf(units));
        stream.writeString(fileName);
        stream.writeString(String.valueOf(cellSize));
        stream.writeString(String.valueOf(xLLCorner));
        stream.writeString(String.valueOf(yLLCorner));
        stream.writeString(String.valueOf(noDataValue));
        stream.writeString(String.valueOf(nRows));
        stream.writeString(String.valueOf(nColumns));

        for(int i=0;i<z.size();i++) {

            Vector oneRow = (Vector)z.elementAt(i);
            for (int j=0;j<oneRow.size();j++) {

                String s = (String)oneRow.elementAt(j);
                stream.writeString(s);

            } //for (int j=0;j<oneRow.size();j++)

        } //for(int i=0;i<z.kength;i++)


        if(ServerConstants.debug) {

            System.out.println("ServerGrid.writeSQL():");
            System.out.println("name : " + name);
            System.out.println("type : " + type);
            System.out.println("units : " + units);
            System.out.println("fileName : " + fileName);
            System.out.println("cellSize : " + cellSize);
            System.out.println("nRows : " + nRows);
            System.out.println("nColumns : " + nColumns);
            System.out.println("xLLCorner : " + xLLCorner);
            System.out.println("yLLCorner : " + yLLCorner);
            System.out.println("noDataValue : " + noDataValue);

        } //if(ServerConstants.debug)


    }//public void writeSQL(SQLOutput stream) 





} //public class ServerGrid implements SQLData, Serializable

