package applets;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.beans.*;

import iDSS.disp.*;
import iDSS.utils.*;
import iDSS.*;




public class TestAnim implements PropertyChangeListener {


    JFrame frame;
    JDesktopPane desktopPane;


    public TestAnim() {

        frame  = new JFrame("AnimationAppletTest");
        frame.setSize(400,400);

        desktopPane = new JDesktopPane();

        GridViewControlApplet gvc = new GridViewControlApplet();
        gvc.addPropertyChangeListener(this);

        addToView(gvc);

        //desktopPane.add(gvc);
        //desktopPane.setPosition(gvc,0);
        //frame.setContentPane(desktopPane);

        frame.setVisible(true);

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });




    } //public TestAnim()




    public void propertyChange(PropertyChangeEvent evt) {


        if (evt.getPropertyName().equals(IDSSAppConstants.addToModelView)) {

            DisplayFrame frame = (DisplayFrame)evt.getNewValue();

            if(frame != null) {

                addToView(frame);

            } //if(frame != null)

            else {

                if(IDSSAppConstants.debug)
                    System.out.println("ModelSetupTree.propertyChange(), " +
                            evt.getPropertyName() + " frame = null");

            } //else

        } //if (evt.getPropertyName().equals(IDSSAppConstants.addToModelView))

    } //public void propertyChange(PropertyChangeEvent evt)






    private void addToView(DisplayFrame f) {

        desktopPane.add(f);
        desktopPane.setPosition(f,0);
        frame.setContentPane(desktopPane);

    } //private void addToView(DisplayFrame f)





    public static void main(String args[]) {


        TestAnim t = new TestAnim();


    } //public static main()String args[])


} //public class TestAnim implements PropertyChangeListener
