/*
 * $Id: LexicalEventListener.java,v 1.2 1999/04/04 19:31:05 db Exp $
 * 
 * Copyright (c) 1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.parser;

import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;


/**
 * Provides notification of information which DOM permits to be exposed.
 * This consists of lexical information (comments; and alternative
 * representations and modularizations of content) which is generally
 * intended to be relevant only to document authors.
 *
 * <P> Even when combined with other information provided by SAX
 * parsers, this information is not sufficient to physically recreate
 * the source document.  Certain classes of white space are not
 * presented (e.g. whitespace separating attributes in start tags,
 * and outside of the document element), and line ending characters
 * are normalized (per the XML specification) to a single newline.
 *
 * @see DtdEventListener
 *
 * @author David Brownell (from xml-dev discussions)
 * @version $Revision: 1.2 $
 */
public interface LexicalEventListener extends DocumentHandler
{
    /**
     * Receive notification that the named entity is being included
     * in document content (not element attributes).
     * The name identifies either an internal or external entity,
     * as reported to the DtdEventListener.  <em>Note that the XML
     * specification defines two types of parsed entities:   general
     * entities, and parameter entities.  This event refers only to
     * general parsed entities.</em>
     *
     * @see DtdEventListener
     * @see #endParsedEntity
     *
     * @param name the name of the entity now being included
     * @exception SAXException any SAX exception, possibly wrapping
     *	another exception
     */
    public void startParsedEntity (String name)
    throws SAXException;


    /**
     * Receive notification that the named entity inclusion into document
     * content is completed.  The name identifies either an internal or
     * external entity, as reported to the DtdEventListener.
     *
     * <p> The XML specification requires nonvalidating XML processors to
     * tell applications when they recognize, but do not include, external
     * parsed entities.  (Section 4.4.3 defines entity inclusion in this
     * manner.)  That notification is provided through this method.
     * <em>Applications might request, through EntityResolver, that an
     * entity not be included ... such a mechanism remains TBS.</em>
     *
     * @see #startParsedEntity
     *
     * @param name the name of the entity whose inclusion is completed.
     * @param included true iff the entity was included; always true
     *	for validating parsers.
     * @exception SAXException any SAX exception, possibly wrapping
     *	another exception
     */
    public void endParsedEntity (String name, boolean included)
    throws SAXException;


    /**
     * Receive notification that a CDATA section is beginning.  Data in a
     * CDATA section is is reported through the appropriate event, either
     * <em>characters()</em> or <em>ignorableWhitespace</em>.
     *
     * @see #endCDATA
     * @see org.xml.sax.DocumentHandler#characters
     * @see org.xml.sax.DocumentHandler#ignorableWhitespace
     *
     * @exception SAXException any SAX exception, possibly wrapping
     *	another exception
     */
    public void startCDATA () throws SAXException;


    /**
     * Receive notification that the CDATA section finished.
     *
     * @see #startCDATA
     *
     * @exception SAXException any SAX exception, possibly wrapping
     *	another exception
     */
    public void endCDATA () throws SAXException;


    /**
     * Receive notification that a comment has been read.
     *
     * <P> Note that processing instructions are the mechanism designed
     * to hold information for consumption by applications, not comments.
     * XML systems may rely on applications being able to access information
     * found in processing instructions; this is not true of comments, which
     * are typically discarded.
     *
     * @param text the text within the comment delimiters.
     * @exception SAXException any SAX exception, possibly wrapping
     *	another exception
     */
    public void comment (String text) throws SAXException;
}
