/*
 * $Id: SAXParserImpl.java,v 1.6 2000/02/18 21:58:28 mode Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.parser;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

/**
 * @author Rajiv Mordani
 * @version $Revision: 1.6 $
 */

/**
 * This is the implementation specific class for the
 * <code>javax.xml.parsers.SAXParser</code>. 
 */
public class SAXParserImpl extends SAXParser {
    private SAXParserFactory spf = null;
    private Parser parser = null;

    private boolean validating = false;
    private boolean namespaceAware = false;
    
    SAXParserImpl (SAXParserFactory spf) throws SAXException,
    						ParserConfigurationException 
    {
        super();
	this.spf = spf;

	if (spf.isValidating ()) {
	    parser = new ValidatingParser();
	    validating = true;
        }
	else {
	    parser = new Parser();
        }

	if (spf.isNamespaceAware ()) {
	    namespaceAware = true;
	    throw new ParserConfigurationException 
			("Namespace not supported by SAXParser");
	}
    }

    public org.xml.sax.Parser getParser () throws SAXException {
        return parser;
    }

    public boolean isNamespaceAware () {
	return namespaceAware;
    }

    public boolean isValidating () {
	return validating;
    }
}
