/**
 * $Id: SAXParserFactoryImpl.java,v 1.10 2000/02/18 21:58:28 mode Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.parser;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.parser.SAXParserImpl;
import com.sun.xml.util.MessageCatalog;
import com.sun.xml.tree.XmlDocumentBuilder;
import org.xml.sax.SAXException;

/**
 * @author Rajiv Mordani
 * @version $Revision: 1.10 $
 */

/**
 * This is the implementation specific class for the
 * <code>javax.xml.parsers.SAXParserFactory</code>. This is the platform
 * default implementation for the platform.
 */
public class SAXParserFactoryImpl extends SAXParserFactory {

    public SAXParserFactoryImpl() {
   	 
    }

    /**
     * Creates a new instance of <code>SAXParser</code> using the currently
     * configured factory parameters.
     * @return javax.xml.parsers.SAXParser
     */
    public SAXParser newSAXParser() throws SAXException,
    					   ParserConfigurationException
    {
    	SAXParserImpl saxParserImpl = new SAXParserImpl (this);
	return saxParserImpl;
    }

}
