// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>The <A HREF='CharacterData.html'><CODE>CharacterData</CODE></A> interface extends Node with a set 
	of attributes
	and methods for accessing character data in the DOM. 
	For clarity this set is defined
	here rather than on each object that uses these attributes and methods. No DOM objects correspond directly to <A HREF='CharacterData.html'><CODE>CharacterData</CODE></A>,
	 though <A HREF='Text.html'><CODE>Text</CODE></A> and
	others do inherit the interface from it. All <code>offset</code>s in
	this interface start from 0.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-data><CODE>&nbsp;data</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getData()'>getData</a>
<a href='#setData(java.lang.String)'>setData</a>
</TD>
<TD><P>The character data of the node
	that implements this interface. The DOM implementation may not
        put arbitrary limits on the amount of data that may be stored in a 
        <A HREF='CharacterData.html'><CODE>CharacterData</CODE></A> node. However, implementation limits may 
	mean that the entirety of a node's data may not fit into a single
	<code>String</code>. In such cases, the user may call
	<code>substringData</code> to retrieve the data in appropriately sized
	pieces.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-length><CODE>&nbsp;length</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLength()'>getLength</a>
</TD>
<TD><P>The number of characters that
    are available through <code>data</code> and the
    <code>substringData</code> method below.  This may have the value zero, 
    i.e., <A HREF='CharacterData.html'><CODE>CharacterData</CODE></A> nodes may be empty.
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface CharacterData
extends Node
{
	/** Assigns the value of the <code><a href=#att-data>data</a></code> property.
	 * @exception DOMException <P>NO_MODIFICATION_ALLOWED_ERR: Raised when the node is
	    readonly.

 */
	void setData (String data) throws DOMException;

	/**
	 * Returns the value of the <code><a href=#att-data>data</a></code> property.
	* @exception DOMException <P>DOMSTRING_SIZE_ERR: Raised when it would return more
	    characters than fit in a <code>String</code> variable on the
	    implementation platform.

 */
	String getData () throws DOMException;


	/**
	 * Returns the value of the <code><a href=#att-length>length</a></code> property.
	*/
	int getLength ();


/**
<P>Extracts a range of data from the node.

@return The specified substring. If the sum of
	    <code>offset</code> and <code>count</code> exceeds the
            <code>length</code>, then all characters to the end of the data are
            returned.
@param offset
Start offset of substring to extract.
@param count
The number of characters to extract.
@exception INDEX_SIZE_ERR: Raised if the specified offset is negative or
	greater than the number of characters in <code>data</code>, or if the
	  specified <code>count</code> is negative.<P>DOMSTRING_SIZE_ERR: Raised if the specified range of text does
	not fit into a <code>String</code>.

*/
String substringData (int offset, int count) throws DOMException;

/**
<P>Append the string to the end of the character data of the node.
	Upon success, <code>data</code> provides access to the concatenation of
	<code>data</code> and the <code>String</code> specified.

@param arg
The <code>String</code> to append.
@exception NO_MODIFICATION_ALLOWED_ERR: Raised if this node is
	readonly.
*/
void appendData (String arg) throws DOMException;

/**
<P>Insert a string at the specified character offset.

@param offset
The character offset at which to insert.
@param arg
The <code>String</code> to insert.
@exception INDEX_SIZE_ERR: Raised if the specified offset is negative or
	greater than the number of characters in <code>data</code>.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

*/
void insertData (int offset, String arg) throws DOMException;

/**
<P>Remove a range of characters from the node. Upon success,
	<code>data</code> and <code>length</code> reflect the change.

@param offset
The offset from which to remove characters.
@param count
The number of characters to delete. If the sum of
	<code>offset</code> and <code>count</code> exceeds
	<code>length</code> then all characters from <code>offset</code>
	to the end of the data are deleted.
@exception INDEX_SIZE_ERR: Raised if the specified offset is negative or
	greater than the number of characters in <code>data</code>, or if the
	  specified <code>count</code> is negative.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

*/
void deleteData (int offset, int count) throws DOMException;

/**
<P>Replace the characters starting at the specified character
	offset with the specified string.

@param offset
The offset from which to start replacing.
@param count
The number of characters to replace. If the sum of
	    <code>offset</code> and <code>count</code> exceeds
	    <code>length</code>, then all characters to the end of the data
	    are replaced (i.e., the effect is the same as a
	    <code>remove</code> method call with the same range, followed
	    by an <code>append</code> method invocation).
@param arg
The <code>String</code> with which the range must
	    be replaced.
@exception INDEX_SIZE_ERR: Raised if the specified offset is negative or
	greater than the number of characters in <code>data</code>, or if the
	  specified <code>count</code> is negative.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

*/
void replaceData (int offset, int count, String arg) throws DOMException;

}
