/*
 * @(#)IIOException.java	1.11 00/11/03
 *
 * Copyright 2000 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.imageio;

import java.io.IOException;

/**
 * An exception class used for signaling run-time failure of reading
 * and writing operations.
 *
 * <p> In addition to a message string, a reference to another
 * <code>Throwable</code> (<code>Error</code> or
 * <code>Exception</code>) is maintained.  This reference, if
 * non-<code>null</code>, refers to the event that caused this
 * exception to occur.  For example, an <code>IOException</code> while
 * reading from a <code>File</code> would be stored there.
 *
 * @version 0.5
 */
public class IIOException extends IOException {

    // Remove in Merlin
    /**
     * The underlying <code>Error</code> or <code>Exception</code> that
     * caused this exception to be generated.
     */
    private Throwable cause;

    /**
     * Constructs an <code>IIOException</code> with a given message
     * <code>String</code>.  No underlying cause is set;
     * <code>getCause</code> will return <code>null</code>.
     *
     * @param message the error message.
     *
     * @see #getCause
     * @see #getMessage
     */
    public IIOException(String message) {
        super(message);
        this.cause = null;
    }

    /**
     * Constructs an <code>IIOException</code> with a given message
     * <code>String</code> and a <code>Throwable</code> that was its
     * underlying cause.
     *
     * @param message the error message.
     * @param cause the <code>Throwable</code> (<code>Error</code> or
     * <code>Exception</code>) that caused this exception to occur.
     *
     * @see #getCause
     * @see #getMessage
     */
    public IIOException(String message, Throwable cause) {
        // In Merlin, change to super(message, cause);
        super(message);
        this.cause = cause;
    }

    // Remove in Merlin
    /**
     * Returns the cause of this throwable or <code>null</code> if the
     * cause is nonexistent or unknown.  (The cause is the throwable that
     * caused this throwable to get thrown.)
     *
     * <p>This implementation returns the cause that was supplied via one
     * of the constructors requiring a <tt>Throwable</tt>, or that was
     * set after creation with the {@link #initCause(Throwable)} method.
     * While it is typcially unnecessary, a subclass can override this
     * method to return a cause set by some other means.  (This is
     * appropriate for a legacy throwable whose cause was stored in
     * a public or protected field, or that provided a public cause-setter
     * method that could be invoked repeatedly.)  If this method is
     * overridden, it is generally appropriate to override {@link 
     * #initCause(Throwable)} as well.  It is <i>not</i> necessary 
     * to override any of the <tt>PrintStackTrace</tt> methods, all of which
     * invoke the <tt>getCause</tt> method to determine the cause of a
     * throwable.
     *
     * @return  the cause of this throwable or <code>null</code> if the
     *          cause is nonexistent or unknown.
     */
    public Throwable getCause() {
        return (cause==this ? null : cause);
    }

    // Remove in Merlin
    /**
     * Initializes the <i>cause</i> of this throwable to the specified value.
     * (The cause is the throwable that caused this throwable to get thrown.) 
     *
     * <p>This method can be called at most once.  It is generally called from 
     * within the constructor, or immediately after creating the
     * throwable.  If this throwable was created
     * with
     * {@link #IIOException(String,Throwable)}, this method cannot be called
     * even once.
     *
     * @param  cause the cause (which is saved for later retrieval by the
     *         {@link #getCause()} method).  (A <tt>null</tt> value is
     *         permitted, and indicates that the cause is nonexistent or
     *         unknown.)
     * @return  a reference to this <code>Throwable</code> instance.
     * @throws IllegalArgumentException if <code>cause</code> is this
     *         throwable.  (A throwable cannot be its own cause.)
     * @throws IllegalStateException if this throwable was created
     *         with {@link #IIOException(String,Throwable)}, or this
     *         method has already been called on this throwable.
     * @since  1.4
     */
    public synchronized Throwable initCause(Throwable cause) {
        if (this.cause != this)
            throw new IllegalStateException("Can't overwrite cause");
        if (cause == this)
            throw new IllegalArgumentException("Self-causation not permitted");
        this.cause = cause;
        return this;
    }
}
