/*
 * @(#)IIOMetadataController.java	1.4 00/11/14
 *
 * Copyright 2000 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.imageio.metadata;

/**
 * An interface to be implemented by objects that can determine
 * the settings of an <code>IIOMetadata</code> object, either 
 * by putting up a GUI to obtain values from a user, or 
 * by other means.  This interface merely specifies a generic
 * <code>activate</code> method that invokes the controller, 
 * without regard for how the controller obtains values (i.e. 
 * whether the controller puts up a modal dialog or merely 
 * computes a set of values is irrelevant to this interface).
 *
 * Within the <code>activate</code> method, a controller obtains
 * initial values by querying the <code>IIOMetadata</code> object's
 * settings, either using the XML DOM tree or a plug-in specific
 * interface, modifies values by whatever means,
 * then modifies the <code>IIOMetadata</code> object's settings, 
 * using either the <code>setFromTree</code> or
 * <code>mergeTree</code> methods, or a plug-in specific interface.
 * In general, applications may expect that when the <code>activate</code>
 * method returns, the <code>IIOMetadata</code> object is ready for use in a
 * write operation.
 *
 * Vendors may choose to provide GUIs for the <code>IIOMetadata</code>
 * subclasses they define for a particular plug-in.  These can be
 * set up as default controllers in the corresponding 
 * <code>IIOMetadata</code> subclasses.
 *
 * Applications may override any default GUIs and provide their
 * own controllers embedded in their own framework.  All that is
 * required is that the controller behave modally.  Similarly,
 * a command-line interface (CLI), or an algorithmic process
 * such as a database lookup could be used as a controller.
 * 
 * @see IIOMetadata#setController
 * @see IIOMetadata#getController
 * @see IIOMetadata#getDefaultController
 * @see IIOMetadata#hasController
 * @see IIOMetadata#activateController
 *
 * @version 0.5
 */
public interface IIOMetadataController {

    /**
     * Activates the controller.  Upon return from this method,
     * all settings in the <code>IIOMetadata</code> object should
     * be ready for use in an IO operation.
     *
     * @param param The <code>IIOMetadata</code> object to be modified.
     *
     * @exception IllegalArgumentException if the argument is not
     * an instance of the correct class.
     */
    void activate (IIOMetadata param);
}
