/*
 * @(#)IIOParamController.java	1.6 00/10/19
 *
 * Copyright 2000 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.imageio;

/**
 * An interface to be implemented by objects that can determine
 * the settings of an <code>IIOParam</code> object, either 
 * by putting up a GUI to obtain values from a user, or 
 * by other means.  This interface merely specifies a generic
 * <code>activate</code> method that invokes the controller, 
 * without regard for how the controller obtains values (i.e. 
 * whether the controller puts up a modal dialog or merely 
 * computes a set of values is irrelevant to this interface).
 *
 * Within the <code>activate</code> method, a controller obtains
 * initial values by querying the <code>IIOParam</code> object's
 * <code>get</code> methods, modifies values by whatever means,
 * then invokes the <code>IIOParam</code> object's 
 * <code>set</code> methods to modify the appropriate settings.  
 * Whether those <code>set</code> methods are invoked as values
 * are obtained or all at once at a final commit is left to the
 * controller implementation.  In general, applications may expect
 * that when the <code>activate</code> method returns, the 
 * <code>IIOParam</code> object is ready for use in a read or
 * write operation.
 *
 * Vendors may choose to provide GUIs for the <code>IIOParam</code>
 * subclasses they define for a particular plug-in.  These can be
 * set up as default controllers in the corresponding 
 * <code>IIOParam</code> subclasses.
 *
 * Applications may override any default GUIs and provide their
 * own controllers embedded in their own framework.  All that is
 * required is that the controller behave modally.  Similarly,
 * a command-line interface (CLI), or an algorithmic process
 * such as a database lookup could be used as a controller.
 * 
 * @see IIOParam#setController
 * @see IIOParam#getController
 * @see IIOParam#getDefaultController
 * @see IIOParam#hasController
 * @see IIOParam#activateController
 *
 * @version 0.5
 */
public interface IIOParamController {

    /**
     * Activates the controller.  Upon return from this method,
     * all settings in the <code>IIOParam</code> object should
     * be ready for use in an IO operation.
     *
     * @param param The <code>IIOParam</code> object to be modified.
     *
     * @exception IllegalArgumentException if the argument is not
     * an instance of the correct class.
     */
    void activate (IIOParam param);
}
