/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

class MemoryCache {
    private static final int BUFFER_LENGTH = 8192;
    private ArrayList cache = new ArrayList();
    private long length = 0L;

    MemoryCache() {
    }

    public long loadFromStream(InputStream inputStream, long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        int n = (int)this.length % 8192;
        byte[] byArray = null;
        long l2 = l - this.length;
        if (n != 0) {
            byArray = (byte[])this.cache.get((int)(this.length / 8192L));
        }
        while (l2 > 0L) {
            int n2;
            int n3;
            if (byArray == null) {
                byArray = new byte[8192];
                n = 0;
            }
            if ((n3 = inputStream.read(byArray, n, (int)Math.min(l2, (long)(n2 = 8192 - n)))) == -1) {
                return this.length;
            }
            if (n == 0) {
                this.cache.add(byArray);
            }
            byArray = null;
            l2 -= (long)n3;
            this.length += (long)n3;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public void writeToStream(OutputStream var1_1, long var2_2, long var4_3) throws IOException {
        if (var2_2 >= this.length || var2_2 + var4_3 >= this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (var2_2 < 0L || var4_3 < 0L) {
            throw new IndexOutOfBoundsException("negative pos or len");
        }
        var6_4 = (int)(var2_2 / 8192L);
        var7_5 = (int)(var2_2 % 8192L);
        if ((var8_6 = (byte[])this.cache.get(var6_4++)) != null) ** GOTO lbl16
        throw new IndexOutOfBoundsException("pos already disposed");
lbl-1000:
        // 1 sources

        {
            if (var8_6 == null) {
                var8_6 = (byte[])this.cache.get(var6_4++);
                var7_5 = 0;
            }
            var9_7 = (int)Math.min(var4_3, (long)(8192 - var7_5));
            var1_1.write(var8_6, var7_5, var9_7);
            var8_6 = null;
            var4_3 -= (long)var9_7;
lbl16:
            // 2 sources

            ** while (var4_3 > 0L)
        }
lbl17:
        // 1 sources

    }

    public long loadFromArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return this.length;
        }
        int n3 = (int)(this.length % 8192L);
        byte[] byArray2 = null;
        if (n3 != 0) {
            byArray2 = (byte[])this.cache.get((int)(this.length / 8192L));
        }
        while (n2 > 0) {
            if (byArray2 == null) {
                byArray2 = new byte[8192];
                n3 = 0;
            }
            int n4 = Math.min(n2, 8192 - n3);
            System.arraycopy(byArray, n, byArray2, n3, n4);
            if (n3 == 0) {
                this.cache.add(byArray2);
            }
            byArray2 = null;
            n += n4;
            n2 -= n4;
            this.length += (long)n4;
        }
        return this.length;
    }

    public void load(int n) {
        int n2 = (int)(this.length % 8192L);
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = new byte[8192];
            this.cache.add(byArray);
        } else {
            byArray = (byte[])this.cache.get((int)(this.length / 8192L));
        }
        byArray[n2] = (byte)(n & 0xFF);
        ++this.length;
    }

    public long getLength() {
        return this.length;
    }

    public int read(long l) {
        if (l >= this.length) {
            return -1;
        }
        byte[] byArray = (byte[])this.cache.get((int)(l / 8192L));
        if (byArray == null) {
            return -1;
        }
        return byArray[(int)(l % 8192L)] & 0xFF;
    }

    public void read(byte[] byArray, int n, int n2, long l) {
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (l + (long)n2 > this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = (int)(l / 8192L);
        int n4 = (int)l % 8192;
        while (n2 > 0) {
            int n5 = Math.min(n2, 8192 - n4);
            System.arraycopy((byte[])this.cache.get(n3++), n4, byArray, n, n5);
            n2 -= n5;
            n += n5;
            n4 = 0;
        }
    }

    public void disposeBefore(long l) {
        int n = (int)(l / 8192L);
        if (this.cache.get(n) == null) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        int n2 = 0;
        while (n2 < n) {
            this.cache.set(n2, null);
            ++n2;
        }
    }

    public void reset() {
        this.cache.clear();
        this.length = 0L;
    }
}

