/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCache;

public class MemoryCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private MemoryCache cache = new MemoryCache();

    public MemoryCacheImageOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = outputStream;
    }

    public int read() throws IOException {
        this.checkClosed();
        int n = this.cache.read(this.streamPos);
        if (n != -1) {
            ++this.streamPos;
            this.bitOffset = 0;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        n2 = (int)Math.min(this.cache.getLength() - this.streamPos, (long)n2);
        this.cache.read(byArray, n, n2, this.streamPos);
        this.streamPos += (long)n2;
        this.bitOffset = 0;
        return n2;
    }

    public void write(int n) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.cache.load(n);
        ++this.streamPos;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.cache.loadFromArray(byArray, n, n2);
        this.streamPos += (long)n2;
    }

    public long length() {
        return this.cache.getLength();
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public void close() throws IOException {
        long l = this.cache.getLength();
        this.flushBefore(l);
        super.close();
        this.cache.reset();
        this.stream = null;
    }

    public void flushBefore(long l) throws IOException {
        long l2 = this.cache.getLength();
        if (l > l2) {
            l = l2;
        }
        long l3 = l - this.flushedPos;
        this.cache.writeToStream(this.stream, this.flushedPos, l3);
        if (this.streamPos < l) {
            this.streamPos = l;
        }
        super.flushBefore(l);
    }
}

