/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;

public class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    private static IIOMetadataFormat standardFormat = null;
    private String rootName;
    private HashMap elementMap = new HashMap();

    public IIOMetadataFormatImpl(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        this.rootName = string;
        Element element = new Element();
        element.elementName = string;
        element.parentName = null;
        element.childPolicy = n;
        this.elementMap.put(string, element);
    }

    public IIOMetadataFormatImpl(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (n > n2) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element = new Element();
        element.elementName = string;
        element.parentName = null;
        element.childPolicy = 4;
        element.minChildren = n;
        element.maxChildren = n2;
        this.rootName = string;
        this.elementMap.put(string, element);
    }

    private static void addSingleAttributeElement(IIOMetadataFormatImpl iIOMetadataFormatImpl, String string, String string2, int n) {
        iIOMetadataFormatImpl.addElement(string, string2, 0);
        iIOMetadataFormatImpl.addAttribute(string, "value", n, true, null);
    }

    private static synchronized void createStandardFormat() {
        if (standardFormat == null) {
            IIOMetadataFormatImpl iIOMetadataFormatImpl = new IIOMetadataFormatImpl("com.sun.imageio_1.0", 2);
            iIOMetadataFormatImpl.addElement("Chroma", "com.sun.imageio_1.0", 2);
            iIOMetadataFormatImpl.addElement("ColorSpaceType", "Chroma", 0);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("XYZ");
            arrayList.add("Lab");
            arrayList.add("Luv");
            arrayList.add("YCbCr");
            arrayList.add("Yxy");
            arrayList.add("RGB");
            arrayList.add("GRAY");
            arrayList.add("HSV");
            arrayList.add("HLS");
            arrayList.add("CMYK");
            arrayList.add("CMY");
            arrayList.add("2CLR");
            arrayList.add("3CLR");
            arrayList.add("4CLR");
            arrayList.add("5CLR");
            arrayList.add("6CLR");
            arrayList.add("7CLR");
            arrayList.add("8CLR");
            arrayList.add("9CLR");
            arrayList.add("ACLR");
            arrayList.add("BCLR");
            arrayList.add("CCLR");
            arrayList.add("DCLR");
            arrayList.add("ECLR");
            arrayList.add("FCLR");
            iIOMetadataFormatImpl.addAttribute("ColorSpaceType", "name", 0, true, null, arrayList);
            iIOMetadataFormatImpl.addElement("BlackIsZero", "Chroma", 0);
            iIOMetadataFormatImpl.addBooleanAttribute("BlackIsZero", "value", true, true);
            iIOMetadataFormatImpl.addElement("Palette", "Chroma", 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("PaletteEntry", "Palette", 0);
            iIOMetadataFormatImpl.addAttribute("PaletteEntry", "index", 2, true, null);
            iIOMetadataFormatImpl.addAttribute("PaletteEntry", "red", 2, true, null);
            iIOMetadataFormatImpl.addAttribute("PaletteEntry", "green", 2, true, null);
            iIOMetadataFormatImpl.addAttribute("PaletteEntry", "blue", 2, true, null);
            iIOMetadataFormatImpl.addElement("BackgroundIndex", "Chroma", 0);
            iIOMetadataFormatImpl.addAttribute("BackgroundIndex", "value", 2, true, 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("BackgroundColor", "Chroma", 0);
            iIOMetadataFormatImpl.addAttribute("BackgroundColor", "value", 2, true, 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("Compression", "com.sun.imageio_1.0", 2);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "CompressionTypeName", "Compression", 0);
            iIOMetadataFormatImpl.addElement("Lossless", "Compression", 0);
            iIOMetadataFormatImpl.addBooleanAttribute("Lossless", "value", true, true);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "NumProgressiveScans", "Compression", 2);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "BitRate", "Compression", 3);
            iIOMetadataFormatImpl.addElement("Data", "com.sun.imageio_1.0", 2);
            iIOMetadataFormatImpl.addElement("PlanarConfiguration", "Data", 0);
            arrayList = new ArrayList();
            arrayList.add("PixelInterleaved");
            arrayList.add("PlaneInterleaved");
            arrayList.add("LineInterleaved");
            arrayList.add("TileInterleaved");
            iIOMetadataFormatImpl.addAttribute("PlanarConfiguration", "value", 0, true, null, arrayList);
            iIOMetadataFormatImpl.addElement("SampleFormat", "Data", 0);
            arrayList = new ArrayList();
            arrayList.add("SignedIntegral");
            arrayList.add("UnsignedIntegral");
            arrayList.add("Real");
            arrayList.add("Index");
            iIOMetadataFormatImpl.addAttribute("SampleFormat", "value", 0, true, null, arrayList);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "BitsPerSample", "Data", 2);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "SignificantBitsPerSample", "Data", 2);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "SampleMSB", "Data", 2);
            iIOMetadataFormatImpl.addElement("Dimension", "com.sun.imageio_1.0", 2);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "PixelAspectRatio", "Dimension", 3);
            iIOMetadataFormatImpl.addElement("ImageOrientation", "Dimension", 0);
            arrayList = new ArrayList();
            arrayList.add("normal");
            arrayList.add("flip_y");
            arrayList.add("flip_x_y");
            arrayList.add("flip_x");
            arrayList.add("flip_x_rot90");
            arrayList.add("rot_270");
            arrayList.add("rot90_flip_x");
            arrayList.add("rot90");
            iIOMetadataFormatImpl.addAttribute("ImageOrientation", "value", 0, true, null, arrayList);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "HorizontalPixelSize", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "VerticalPixelSize", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "HorizontalPhysicalPixelSpacing", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "VerticalPhysicalPixelSpacing", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "HorizontalPosition", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "VerticalPosition", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "HorizontalPixelOffset", "Dimension", 3);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "VerticalPixelOffset", "Dimension", 3);
            iIOMetadataFormatImpl.addElement("Document", "com.sun.imageio_1.0", 2);
            iIOMetadataFormatImpl.addElement("SubimageInterpretation", "Document", 0);
            arrayList = new ArrayList();
            arrayList.add("Standalone");
            arrayList.add("SignificantBitsPerSample");
            arrayList.add("FullResolution");
            arrayList.add("ReducedResolution");
            arrayList.add("PyramidLayer");
            arrayList.add("Preview");
            arrayList.add("VolumeSlice");
            arrayList.add("ObjectView");
            arrayList.add("Panorama");
            arrayList.add("AnimationFrame");
            arrayList.add("TransparencyMask");
            arrayList.add("CompositingLayer");
            arrayList.add("SpectralSlice");
            arrayList.add("Unknown");
            iIOMetadataFormatImpl.addAttribute("SubimageInterpretation", "value", 0, true, null, arrayList);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "ImageCreationTime", "Document", 6);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "ImageModificationTime", "Document", 6);
            iIOMetadataFormatImpl.addElement("Text", "com.sun.imageio_1.0", 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("TextEntry", "Text", 0);
            iIOMetadataFormatImpl.addAttribute("TextEntry", "keyword", 0, true, null);
            iIOMetadataFormatImpl.addAttribute("TextEntry", "value", 0, true, null);
            iIOMetadataFormatImpl.addAttribute("TextEntry", "language", 0, false, null);
            iIOMetadataFormatImpl.addAttribute("TextEntry", "encoding", 0, false, null);
            arrayList = new ArrayList();
            arrayList.add("none");
            arrayList.add("lzw");
            arrayList.add("zip");
            arrayList.add("bzip");
            arrayList.add("other");
            iIOMetadataFormatImpl.addAttribute("TextEntry", "compression", 0, false, null, arrayList);
            iIOMetadataFormatImpl.addElement("Transparency", "com.sun.imageio_1.0", 2);
            iIOMetadataFormatImpl.addElement("Alpha", "Transparency", 0);
            arrayList = new ArrayList();
            arrayList.add("none");
            arrayList.add("premultiplied");
            arrayList.add("nonpremultiplied");
            iIOMetadataFormatImpl.addAttribute("Alpha", "value", 0, false, "none", arrayList);
            IIOMetadataFormatImpl.addSingleAttributeElement(iIOMetadataFormatImpl, "TransparentIndex", "Transparency", 2);
            iIOMetadataFormatImpl.addElement("TransparentColor", "Transparency", 0);
            iIOMetadataFormatImpl.addAttribute("TransparentColor", "value", 2, true, 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("TileTransparencies", "Transparency", 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("TransparentTile", "TileTransparencies", 0);
            iIOMetadataFormatImpl.addAttribute("TransparentTile", "x", 2, true, null);
            iIOMetadataFormatImpl.addAttribute("TransparentTile", "y", 2, true, null);
            iIOMetadataFormatImpl.addElement("TileOpacities", "Transparency", 0, Integer.MAX_VALUE);
            iIOMetadataFormatImpl.addElement("OpaqueTile", "TileOpacities", 0);
            iIOMetadataFormatImpl.addAttribute("OpaqueTile", "x", 2, true, null);
            iIOMetadataFormatImpl.addAttribute("OpaqueTile", "y", 2, true, null);
            standardFormat = iIOMetadataFormatImpl;
        }
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        IIOMetadataFormatImpl.createStandardFormat();
        return standardFormat;
    }

    private Element getElement(String string) {
        Element element = (Element)this.elementMap.get(string);
        if (element == null) {
            throw new IllegalArgumentException("No such element \"" + string + "\"!");
        }
        return element;
    }

    protected void addElement(String string, String string2, int n) {
        Element element = (Element)this.elementMap.get(string2);
        if (element == null) {
            throw new IllegalArgumentException("Invalid parent name!");
        }
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        Element element2 = new Element();
        element2.elementName = string;
        element2.parentName = string2;
        element2.childPolicy = n;
        element.childList.add(string);
        this.elementMap.put(string, element2);
    }

    protected void addElement(String string, String string2, int n, int n2) {
        Element element = (Element)this.elementMap.get(string2);
        if (element == null) {
            throw new IllegalArgumentException("Invalid parent name!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (n > n2) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element2 = new Element();
        element2.elementName = string;
        element2.parentName = string2;
        element2.childPolicy = 4;
        element2.minChildren = n;
        element2.maxChildren = n2;
        element.childList.add(string);
        this.elementMap.put(string, element2);
    }

    protected void removeElement(String string) {
        this.elementMap.remove(string);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 1;
        attribute.dataType = n;
        attribute.required = bl;
        attribute.defaultValue = string3;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3, List list) {
        Object object;
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (list == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (object instanceof String) continue;
            throw new IllegalArgumentException("enumeratedValues contains a value that is not a String!");
        }
        object = new Attribute();
        ((Attribute)object).attrName = string2;
        ((Attribute)object).valueType = 16;
        ((Attribute)object).dataType = n;
        ((Attribute)object).required = bl;
        ((Attribute)object).defaultValue = string3;
        ((Attribute)object).enumeratedValues = list;
        element.attrList.add(string2);
        element.attrMap.put(string2, object);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3, String string4, String string5, boolean bl2, boolean bl3) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 2;
        if (bl2) {
            attribute.valueType |= 4;
        }
        if (bl3) {
            attribute.valueType |= 8;
        }
        attribute.dataType = n;
        attribute.required = bl;
        attribute.defaultValue = string3;
        attribute.minValue = string4;
        attribute.maxValue = string5;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, int n2, int n3) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("Invalid list bounds!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 32;
        attribute.dataType = n;
        attribute.required = bl;
        attribute.listMinLength = n2;
        attribute.listMaxLength = n3;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addBooleanAttribute(String string, String string2, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TRUE");
        arrayList.add("FALSE");
        String string3 = null;
        if (bl) {
            string3 = bl2 ? "TRUE" : "FALSE";
        }
        this.addAttribute(string, string2, 1, true, string3, arrayList);
    }

    protected void removeAttribute(String string, String string2) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        element.attrList.remove(string2);
        element.attrMap.remove(string2);
    }

    protected void addObjectValue(String string, Class clazz, boolean bl, Object object) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        ObjectValue objectValue = new ObjectValue();
        objectValue.valueType = 1;
        objectValue.classType = clazz;
        objectValue.defaultValue = object;
        element.objectValue = objectValue;
    }

    protected void addObjectValue(String string, Class clazz, boolean bl, Object object, List list) {
        Object object2;
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        if (list == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (clazz.isInstance(object2)) continue;
            throw new IllegalArgumentException("enumeratedValues contains a value not of class classType!");
        }
        object2 = new ObjectValue();
        ((ObjectValue)object2).valueType = 16;
        ((ObjectValue)object2).classType = clazz;
        ((ObjectValue)object2).defaultValue = object;
        ((ObjectValue)object2).enumeratedValues = list;
        element.objectValue = object2;
    }

    protected void addObjectValue(String string, Class clazz, Object object, Comparable comparable, Comparable comparable2, boolean bl, boolean bl2) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        ObjectValue objectValue = new ObjectValue();
        objectValue.valueType = 2;
        if (bl) {
            objectValue.valueType |= 4;
        }
        if (bl2) {
            objectValue.valueType |= 8;
        }
        objectValue.classType = clazz;
        objectValue.defaultValue = object;
        objectValue.minValue = comparable;
        objectValue.maxValue = comparable2;
        element.objectValue = objectValue;
    }

    protected void addObjectValue(String string, Class clazz, int n, int n2) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        ObjectValue objectValue = new ObjectValue();
        objectValue.valueType = 32;
        objectValue.classType = clazz;
        objectValue.arrayMinLength = n;
        objectValue.arrayMaxLength = n2;
        element.objectValue = objectValue;
    }

    protected void removeObjectValue(String string) {
        Element element = this.getElement(string);
        if (element == null) {
            throw new IllegalArgumentException("Invalid element name!");
        }
        element.objectValue = null;
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getParentName(String string) {
        Element element = this.getElement(string);
        return element.parentName;
    }

    public boolean canNodeAppear(String string, ImageTypeSpecifier imageTypeSpecifier) {
        return true;
    }

    public int getElementMinChildren(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy != 4) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.maxChildren;
    }

    public int getElementMaxChildren(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy != 4) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.maxChildren;
    }

    public int getChildPolicy(String string) {
        Element element = this.getElement(string);
        return element.childPolicy;
    }

    public String[] getChildNames(String string) {
        Element element = this.getElement(string);
        return element.childList.toArray(new String[0]);
    }

    public String[] getAttributeNames(String string) {
        Element element = this.getElement(string);
        List list = element.attrList;
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    private Attribute getAttribute(String string, String string2) {
        Element element = this.getElement(string);
        Attribute attribute = (Attribute)element.attrMap.get(string2);
        return attribute;
    }

    public int getAttributeValueType(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.valueType;
    }

    public int getAttributeDataType(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.dataType;
    }

    public boolean isAttributeRequired(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.required;
    }

    public String getAttributeDefaultValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.defaultValue;
    }

    public String[] getAttributeEnumerations(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 16) {
            throw new IllegalStateException("Attribute not an enumeration!");
        }
        List list = attribute.enumeratedValues;
        Iterator iterator = list.iterator();
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    public String getAttributeMinValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 2) {
            throw new IllegalStateException("Attribute not a range!");
        }
        return attribute.minValue;
    }

    public String getAttributeMaxValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 2) {
            throw new IllegalStateException("Attribute not a range!");
        }
        return attribute.maxValue;
    }

    public int getAttributeListMinLength(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 32) {
            throw new IllegalStateException("Attribute not a list!");
        }
        return attribute.listMinLength;
    }

    public int getAttributeListMaxLength(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 32) {
            throw new IllegalStateException("Attribute not a list!");
        }
        return attribute.listMaxLength;
    }

    private ObjectValue getObjectValue(String string) {
        Element element = this.getElement(string);
        ObjectValue objectValue = element.objectValue;
        if (objectValue == null) {
            throw new IllegalArgumentException("No object within element " + string + "!");
        }
        return objectValue;
    }

    public int getObjectValueType(String string) {
        Element element = this.getElement(string);
        ObjectValue objectValue = element.objectValue;
        if (objectValue == null) {
            return 0;
        }
        return objectValue.valueType;
    }

    public Class getObjectClass(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        return objectValue.classType;
    }

    public Object getObjectDefaultValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        return objectValue.defaultValue;
    }

    public Object[] getObjectEnumerations(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 16) {
            throw new IllegalArgumentException("Not an enumeration!");
        }
        List list = objectValue.enumeratedValues;
        Object[] objectArray = new Object[list.size()];
        return list.toArray(objectArray);
    }

    public Comparable getObjectMinValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objectValue.minValue;
    }

    public Comparable getObjectMaxValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objectValue.maxValue;
    }

    public int getObjectArrayMinLength(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objectValue.arrayMinLength;
    }

    public int getObjectArrayMaxLength(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objectValue.arrayMinLength;
    }

    class ObjectValue {
        int valueType = 0;
        Class classType = null;
        Object defaultValue = null;
        List enumeratedValues = null;
        Comparable minValue = null;
        Comparable maxValue = null;
        int arrayMinLength = 0;
        int arrayMaxLength = 0;

        ObjectValue() {
        }
    }

    class Attribute {
        String attrName;
        int valueType = 1;
        int dataType;
        boolean required;
        String defaultValue = null;
        List enumeratedValues;
        String minValue;
        String maxValue;
        int listMinLength;
        int listMaxLength;

        Attribute() {
        }
    }

    class Element {
        String elementName;
        String parentName;
        int childPolicy;
        int minChildren = 0;
        int maxChildren = 0;
        List childList = new ArrayList();
        List attrList = new ArrayList();
        Map attrMap = new HashMap();
        ObjectValue objectValue;

        Element() {
        }
    }
}

