/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private long maxStreamPos = 0L;

    public FileCacheImageOutputStream(OutputStream outputStream, File file) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        this.stream = outputStream;
        this.cacheFile = File.createTempFile("imageio", ".tmp", file);
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        int n = this.cache.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.bitOffset = 0;
        int n3 = this.cache.read(byArray, n, n2);
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    public void write(int n) throws IOException {
        this.flushBits();
        this.cache.write(n);
        ++this.streamPos;
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushBits();
        this.cache.write(byArray, n, n2);
        this.streamPos += (long)n2;
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
    }

    public long length() {
        try {
            return this.cache.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        this.cache.seek(l);
        this.streamPos = this.cache.getFilePointer();
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
        this.bitOffset = 0;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public void close() throws IOException {
        this.flushBefore(this.maxStreamPos);
        super.close();
        this.cache.close();
        this.stream = null;
    }

    public void flushBefore(long l) throws IOException {
        if (l > this.maxStreamPos) {
            l = this.maxStreamPos;
        }
        long l2 = l - this.flushedPos;
        int n = 512;
        if (l2 > 0L) {
            byte[] byArray = new byte[n];
            this.cache.seek(this.flushedPos);
            while (l2 > 0L) {
                int n2 = (int)Math.min(l2, (long)n);
                int n3 = this.cache.read(byArray, 0, n2);
                this.stream.write(byArray, 0, n2);
                l2 -= (long)n2;
            }
            this.flushedPos = l;
        }
    }
}

