/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.Activator;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.Repository;
import com.sun.corba.ee.ActivationIDL.RepositoryHelper;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ListServers;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListActiveServers
implements CommandHandler {
    ListActiveServers() {
    }

    public String getCommandName() {
        return "listactive";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl2) {
        if (!bl2) {
            printStream.println("\tlistactive\n");
        } else {
            printStream.println("list currently active servers");
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            int[] nArray = activator.getActiveServers();
            printStream.println("\tServer Id\tServer Class Name");
            printStream.println("\t---------\t-----------------");
            ListServers.sortServers(nArray);
            int n2 = 0;
            while (n2 < nArray.length) {
                try {
                    ServerDef serverDef = repository.getServer(nArray[n2]);
                    printStream.println("\t   " + nArray[n2] + "\t\t" + serverDef.serverName);
                }
                catch (ServerNotRegistered serverNotRegistered) {}
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

