/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.Activator;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.ServerNotActive;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ServerTool;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ShutdownServer
implements CommandHandler {
    static final int illegalServerId = -1;

    ShutdownServer() {
    }

    public String getCommandName() {
        return "shutdown";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl2) {
        if (!bl2) {
            printStream.println("\tshutdown [ -serverid <server id> | -applicationName <name> ]\n");
        } else {
            printStream.println("shutdown a registered server");
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n2 = -1;
        if (stringArray.length == 2) {
            if (stringArray[0].equals("-serverid")) {
                n2 = Integer.valueOf(stringArray[1]);
            } else if (stringArray[0].equals("-applicationName")) {
                n2 = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
            }
        }
        if (n2 == -1) {
            return true;
        }
        try {
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            activator.shutdown(n2);
            printStream.println("\tserver sucessfully shutdown.");
        }
        catch (ServerNotActive serverNotActive) {
            printStream.println("\tserver is not running.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

