/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.sqlgen.DBInfoImpl;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.activation.BadServerDefinition;
import com.sun.enterprise.activation.Locator;
import com.sun.enterprise.activation.RepositoryImpl;
import com.sun.enterprise.activation.ServerAlreadyRegisteredException;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerManagerImpl;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogReaderImpl;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.SerialContextProviderImpl;
import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.ConfigurationImpl;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.security.AuthenticationServer;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.server.EJBServer;
import com.sun.enterprise.tools.deployment.backend.JarInstallerImpl;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.util.DebugController;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.web.server.WebServer;
import com.sun.web.server.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public final class J2EEServer {
    private static final boolean debug = false;
    private static final int J2EE_SERVERID = 100;
    private static final int MAX_INITIAL_CONTEXT_RETRIES = 15;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$server$J2EEServer != null ? class$com$sun$enterprise$server$J2EEServer : (class$com$sun$enterprise$server$J2EEServer = J2EEServer.class$("com.sun.enterprise.server.J2EEServer")));
    private static final String VERBOSE = "-verbose";
    private static final String HELP = "-help";
    private static final String VERSION = "-version";
    private static final String FULL_VERSION = "-fullversion";
    private static final String SINGLEVM = "-singleVM";
    private static final String MULTIVM = "-multiVM";
    private static final String DEBUG = "-debug";
    private static final String STOP = "-stop";
    private static int ACTIVATION_PORT;
    private static final String APPLICATIONS_DIRECTORY = "ejb.applications.directory";
    private static final String REPOSITORY_DIRECTORY = "ejb.repository.directory";
    public static final String ADMIN_PORT = "ejb.http.port";
    public static final String DEFAULT_ADMIN_PORT = "9191";
    private static final String USER_TX = "user.transaction.jndiname";
    private static final String CODEBASE_PROP = "java.rmi.server.codebase";
    public static final String CODEBASE_PREFIX;
    private static final String DefaultDbDir = "orb.db";
    private int orbInitialPort;
    private Configuration conf = null;
    private ORB orb;
    private ProtocolManager protocolMgr;
    static String[][] orbServers;
    static String[][] ejbServers;
    public static PrintStream ostream;
    public static PrintStream estream;
    private File dbDir;
    private String dbDirName;
    private ServerManagerImpl serverMgr;
    private Locator locator;
    private Activator activator;
    private RepositoryImpl repository;
    private Properties defaultProperties;
    private String codebasePort;
    private static final String CONFIG_DIR = "config";
    private static final String J2EE_J2EEDSERVER_CONFIG_FILE_NAME = "orb.properties";
    private static final String DEFAULT_J2EEDSERVER_PORT = "1049";
    private static final String J2EE_J2EEDSERVER_CONFIG_PORT_NAME = "serverport";
    private static final String J2EE_J2EEDSERVER_PORT_PROPERTY = "com.sun.enterprise.server.J2EEServerPort";
    static /* synthetic */ Class class$com$sun$enterprise$server$J2EEServer;
    static /* synthetic */ Class class$com$sun$enterprise$activation$Activator;

    static {
        CODEBASE_PREFIX = "http://" + Utility.getLocalHost() + ":";
        orbServers = new String[][]{{"1", "NameServer", "com.sun.PCosNaming.NameServer", "", "", ""}, {"0", "J2EE Server", "com.sun.enterprise.server.J2EEServer", "", "", ""}};
        ejbServers = new String[][]{{"2", "AuthenticationServer", "com.sun.enterprise.security.AuthenticationServer", "", "", ""}, {"3", "WebServer", "com.sun.web.server.WebServer", "", "", ""}};
        ostream = System.out;
        estream = System.err;
    }

    public J2EEServer() {
        String j2eedserverPort = System.getProperty(J2EE_J2EEDSERVER_PORT_PROPERTY);
        if (j2eedserverPort == null) {
            try {
                File j2eedConfigFile = new File(FileUtil.getAbsolutePath(CONFIG_DIR + File.separator + J2EE_J2EEDSERVER_CONFIG_FILE_NAME));
                FileInputStream fis = new FileInputStream(j2eedConfigFile);
                Properties j2eedserverConfig = new Properties();
                j2eedserverConfig.load(fis);
                j2eedserverPort = j2eedserverConfig.getProperty(J2EE_J2EEDSERVER_CONFIG_PORT_NAME);
                fis.close();
            }
            catch (Exception j2eedConfigFile) {
                // empty catch block
            }
            if (j2eedserverPort == null) {
                j2eedserverPort = DEFAULT_J2EEDSERVER_PORT;
            }
            System.setProperty(J2EE_J2EEDSERVER_PORT_PROPERTY, j2eedserverPort);
        }
        ACTIVATION_PORT = Integer.parseInt(j2eedserverPort);
        System.out.println("J2EE server Listen Port: = " + ACTIVATION_PORT);
    }

    private void bindObject(ORB orb, String publishedName, Remote remote) throws RemoteException, NamingException {
        Tie servantsTie = Util.getTie(remote);
        servantsTie.orb(orb);
        NamingManager namingMgr = Switch.getSwitch().getNamingManager();
        namingMgr.publishObject(publishedName, (Object)servantsTie, true);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void createActivationObjects() throws Exception {
        this.repository = new RepositoryImpl(this.dbDir, this);
        this.serverMgr = new ServerManagerImpl(ACTIVATION_PORT, this.repository, this.dbDirName, this);
        this.protocolMgr.setLocator(this.serverMgr);
        this.activator = (Activator)PortableRemoteObject.narrow(this.serverMgr, class$com$sun$enterprise$activation$Activator != null ? class$com$sun$enterprise$activation$Activator : (class$com$sun$enterprise$activation$Activator = J2EEServer.class$("com.sun.enterprise.activation.Activator")));
        this.repository.setActivator(this.activator);
    }

    private void createConfiguration() throws RemoteException, NamingException {
        this.conf = new ConfigurationImpl();
        PortableRemoteObject.exportObject(this.conf);
        this.bindObject(this.orb, "ServerConfiguration", this.conf);
        System.out.println(localStrings.getLocalString("j2ee.publish_config", "Published configuration object."));
    }

    private JarInstallerImpl createInstaller(EJBServer svr, WebServer httpd) {
        JarInstallerImpl impl = null;
        try {
            impl = new JarInstallerImpl(svr, httpd, this.getApplicationDirectory(), this.repository, this.activator);
            PortableRemoteObject.exportObject(impl);
            this.bindObject(this.orb, "JarInstaller", impl);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new RuntimeException("Unable to create JarInstaller remote object");
        }
        return impl;
    }

    private ORB createORB(String[] args, boolean singleVM) throws Exception {
        Properties props = new Properties();
        String recoverableStr = this.defaultProperties.getProperty("distributed.transaction.recovery");
        boolean recoverable = "true".equals(recoverableStr);
        if (singleVM) {
            EJBServer.initJTSProperties(recoverable, true, props);
        } else {
            EJBServer.initJTSProperties(false, true, props);
        }
        ORBManager.init(args, props);
        this.orbInitialPort = ORBManager.getORBInitialPort();
        return ORBManager.getORB();
    }

    private void createRepositoryDir() {
        Properties props = System.getProperties();
        this.dbDir = new File(props.getProperty("com.sun.enterprise.activation.DbDir", String.valueOf(props.getProperty("user.dir")) + File.separator + "repository"));
        this.dbDirName = this.dbDir.getAbsolutePath();
        ((Hashtable)props).put("com.sun.enterprise.activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
        }
    }

    private File getApplicationDirectory() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String repname = config.getProperty(REPOSITORY_DIRECTORY, "repository");
        String dirname = config.getProperty(APPLICATIONS_DIRECTORY, "applications");
        String docRoot = String.valueOf(repname) + File.separator + Utility.getLocalHost() + File.separator + dirname;
        File applicationDirectory = new File(FileUtil.getAbsolutePath(docRoot));
        applicationDirectory.mkdirs();
        return applicationDirectory;
    }

    public int getEjbdPort() {
        return ACTIVATION_PORT;
    }

    public int getORBInitialPort() {
        return this.orbInitialPort;
    }

    private static void initClasses() throws ClassNotFoundException {
        String[] classes = new String[]{"javax.servlet.ServletOutputStream"};
        int i2 = 0;
        while (i2 < classes.length) {
            Class.forName(classes[i2]);
            ++i2;
        }
    }

    private void installEJBServers() {
        int serverId = 0;
        int i2 = 0;
        while (i2 < ejbServers.length) {
            try {
                String[] server = ejbServers[i2];
                ServerDef serverDef = new ServerDef(server[1], server[2], server[3], server[4], String.valueOf(server[5]) + " -Djava.compiler=NONE " + "-Djava.security.policy=" + System.getProperty("java.security.policy"));
                serverId = Integer.valueOf(ejbServers[i2][0]);
                this.repository.registerServerDef(serverDef, serverId);
                this.activator.activate(serverId, false);
            }
            catch (ServerAlreadyRegisteredException serverAlreadyRegisteredException) {
                try {
                    this.activator.activate(serverId, false);
                }
                catch (Exception e10) {}
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    private void installOrbServers() {
        int serverId = 0;
        int i2 = 1;
        while (i2 < orbServers.length) {
            try {
                String[] server = orbServers[i2];
                ServerDef serverDef = new ServerDef(server[1], server[2], server[3], server[4], server[5]);
                serverId = Integer.valueOf(orbServers[i2][0]);
                this.repository.registerServerDef(serverDef, serverId);
            }
            catch (ServerAlreadyRegisteredException serverAlreadyRegisteredException) {
                try {
                    this.activator.activate(serverId, false);
                }
                catch (Exception e10) {}
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    private void loadDeployedApplications(EJBServer svr) throws MalformedURLException {
        try {
            JarManagerImpl jarimpl = svr.getEJBJarManager();
            Vector appList = JarRepository.getApplicationList();
            int i2 = 0;
            while (i2 < appList.size()) {
                String name = (String)appList.elementAt(i2);
                String url = JarRepository.getJarName(name);
                String jarfile = new URL(url).getFile();
                System.out.println(localStrings.getLocalString("j2ee.load", "Loading jar:{0}", new Object[]{jarfile}));
                jarimpl.loadJar(jarfile);
                ++i2;
            }
        }
        catch (RemoteException re) {
            Log.err.println(re);
        }
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        boolean verbose = false;
        boolean singleVM = true;
        boolean dbg = false;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].trim().equals(HELP)) {
                J2EEServer.printHelp(System.out);
                return;
            }
            if (args[i2].trim().equals(STOP)) {
                J2EEServer.shutdown();
                return;
            }
            if (args[i2].trim().equals(VERSION)) {
                System.out.println(String.valueOf(localStrings.getLocalString("j2ee.server_version", "Java 2 Enterprise Edition version ")) + "1.2.1");
                return;
            }
            if (args[i2].trim().equals(FULL_VERSION)) {
                System.out.println(String.valueOf(localStrings.getLocalString("j2ee.server_version", "Java 2 Enterprise Edition version ")) + "1.2.1-q");
                return;
            }
            if (args[i2].trim().equals(VERBOSE)) {
                verbose = true;
            } else if (args[i2].trim().equals(DEBUG)) {
                dbg = true;
            } else if (args[i2].trim().equals(SINGLEVM)) {
                singleVM = true;
            } else if (args[i2].trim().equals(MULTIVM)) {
                singleVM = false;
            } else {
                J2EEServer.printHelp(System.out);
                return;
            }
            ++i2;
        }
        try {
            if (dbg && singleVM) {
                DebugController.init();
            }
            J2EEServer.initClasses();
            J2EEServer j2ee = new J2EEServer();
            j2ee.run(args, verbose, singleVM);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            if (e10.getMessage() != null) {
                System.err.println("J2EE server reported the following error: " + e10.getMessage());
            }
            System.err.println("Error executing J2EE server ...");
            System.err.flush();
            System.exit(1);
        }
    }

    private static void printHelp(PrintStream out) {
        out.println(localStrings.getLocalString("j2ee.server", "Java 2 Enterprise Edition"));
        out.println(localStrings.getLocalString("j2ee.options", "Options:"));
        out.println("-verbose\t\t" + localStrings.getLocalString("j2ee.verbose", "Redirect logging output to the current shell."));
        out.println("-help\t\t\t" + localStrings.getLocalString("j2ee.help", "Print this help message."));
        out.println("-version\t\t" + localStrings.getLocalString("j2ee.version", "Print the version."));
        out.println("-singleVM\t\t" + localStrings.getLocalString("j2ee.singlevm", "Deploys all beans in this process."));
        out.println("-multiVM\t\t" + localStrings.getLocalString("j2ee.multivm", "Deploys all beans in a jar file in a new process."));
        out.println("-stop\t\t\t" + localStrings.getLocalString("j2ee.stop", "Stop the J2EE server."));
    }

    void redirectStreams() throws Exception {
        String appname = System.getProperty("com.sun.enterprise.appname", "j2ee");
        File logDir = LogUtil.getLogDirectory(appname, "ejb");
        File ofile = new File(logDir, "system.out");
        FileOutputStream foutStream = new FileOutputStream(ofile.getAbsolutePath(), true);
        File efile = new File(logDir, "system.err");
        FileOutputStream ferrStream = new FileOutputStream(efile.getAbsolutePath(), true);
        PrintStream pSout = new PrintStream(foutStream, true);
        PrintStream pSerr = new PrintStream(ferrStream, true);
        LogUtil.printInfo(pSout);
        LogUtil.printInfo(pSerr);
        System.setOut(pSout);
        System.setErr(pSerr);
        ostream.println(localStrings.getLocalString("j2ee.redirect", "Redirecting the output and error streams to the following files:"));
        ostream.println(ofile.getAbsolutePath());
        ostream.println(efile.getAbsolutePath());
    }

    private void registerDeployedApplications() throws MalformedURLException {
        try {
            Vector appList = JarRepository.getApplicationList();
            int i2 = 0;
            while (i2 < appList.size()) {
                String name = (String)appList.elementAt(i2);
                String url = JarRepository.getJarName(name);
                String jarfile = new URL(url).getFile();
                System.out.println(localStrings.getLocalString("j2ee.load", "Loading jar:{0}", new Object[]{jarfile}));
                JarInstallerImpl.registerServer(name, new File(jarfile), this.repository);
                ++i2;
            }
        }
        catch (BadServerDefinition badServerDefinition) {
        }
        catch (Exception re) {
            Log.err.println(re);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreWebComponents(JarInstallerImpl jarinstaller) {
        int i2 = 0;
        while (true) {
            block11: {
                Object var4_3;
                if (i2 >= 15) {
                    return;
                }
                try {
                    try {
                        jarinstaller.restoreWebComponents();
                        var4_3 = null;
                    }
                    catch (Exception exception) {
                        var4_3 = null;
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Exception exception2) {}
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    try {}
                    catch (Exception exception) {}
                    Thread.sleep(3000L);
                    throw throwable;
                    throw throwable;
                }
                try {}
                catch (Exception exception) {
                    return;
                }
                Thread.sleep(3000L);
                return;
            }
            ++i2;
        }
    }

    private void run(String[] args, boolean verbose, boolean singleVM) {
        EJBServer svr = null;
        try {
            this.defaultProperties = new Properties();
            String propsFile = String.valueOf(System.getProperty("com.sun.enterprise.home")) + File.separator + CONFIG_DIR + File.separator + "default.properties";
            FileInputStream fis = new FileInputStream(propsFile);
            this.defaultProperties.load(fis);
            Properties props = System.getProperties();
            String repname = "repository";
            try {
                ConfigurationImpl config = new ConfigurationImpl();
                repname = config.getProperty(REPOSITORY_DIRECTORY);
            }
            catch (Exception exception) {}
            String activationDir = String.valueOf(repname) + File.separator + Utility.getLocalHost();
            ((Hashtable)props).put("com.sun.enterprise.activation.DbDir", FileUtil.getAbsolutePath(activationDir));
            if (singleVM) {
                String serverId = new Integer(100).toString();
                props.setProperty("com.sun.enterprise.activation.EJBServerId", serverId);
                String serverPort = new Integer(ACTIVATION_PORT).toString();
                props.setProperty("com.sun.enterprise.activation.EJBServerPort", serverPort);
                props.setProperty("com.sun.enterprise.appname", "j2ee");
            }
            try {
                this.orb = this.createORB(args, singleVM);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                throw new RuntimeException("Unable to create ORB. Possible causes include TCP/IP ports in use by another process");
            }
            this.createRepositoryDir();
            if (!verbose) {
                this.redirectStreams();
            }
            Switch theSwitch = Switch.getSwitch();
            this.protocolMgr = new POAProtocolMgr(this.orb);
            theSwitch.setProtocolManager(this.protocolMgr);
            if (!singleVM) {
                this.protocolMgr.setPersistentServerPort(ACTIVATION_PORT);
            }
            this.protocolMgr.initializeNaming(this.dbDir, this.orbInitialPort);
            System.out.println(String.valueOf(localStrings.getLocalString("j2ee.naming", "Naming service started: :")) + this.orbInitialPort);
            this.createActivationObjects();
            SerialContextProviderImpl.initSerialContextProvider();
            InvocationManagerImpl invMgr = new InvocationManagerImpl();
            theSwitch.setInvocationManager(invMgr);
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            this.protocolMgr.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
            this.createConfiguration();
            File dir = LogUtil.getLogDirectory("j2ee", "ejb");
            LogUtil.initDefaultLogFiles(dir);
            this.installOrbServers();
            if (singleVM) {
                this.startAuthenticationService();
            } else {
                this.installEJBServers();
            }
            PoolManagerImpl.installJdbcDataSources();
            this.startActivationObjects();
            J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
            theSwitch.setTransactionManager(tm);
            if (singleVM) {
                svr = new EJBServer(this.orb);
                svr.setDefaultProperties(this.defaultProperties);
                svr.init(args);
            }
            ServerConfiguration sc = ServerConfiguration.getConfiguration();
            this.codebasePort = sc.getProperty(ADMIN_PORT, DEFAULT_ADMIN_PORT);
            this.startAdminService(sc);
            WebServer webServer = null;
            if (singleVM) {
                webServer = this.startWebService(sc);
            }
            if (!singleVM) {
                Realm.initialize();
            }
            JarInstallerImpl jarinstaller = this.createInstaller(svr, webServer);
            String userTransactionName = sc.getProperty(USER_TX, "UserTransaction");
            nm.publishObject(userTransactionName, (Object)new UserTransactionImpl(), true);
            DBInfoImpl dbInfo = new DBInfoImpl();
            this.bindObject(this.orb, "DatabaseInformation", dbInfo);
            if (!singleVM) {
                this.registerDeployedApplications();
                this.startRegisteredServers();
            } else {
                this.loadDeployedApplications(svr);
            }
            this.restoreWebComponents(jarinstaller);
            LogReaderImpl.exportRemoteInterface();
            System.out.println(localStrings.getLocalString("j2ee.started", "J2EE server startup complete."));
            if (!verbose) {
                ostream.println(localStrings.getLocalString("j2ee.started", "J2EE server startup complete."));
            }
            this.orb.run();
        }
        catch (Exception ex3) {
            Log.err.println(ex3);
            Log.err.flush();
            throw new RuntimeException(ex3.getMessage());
        }
    }

    private static void shutdown() {
        try {
            Activator activator = (Activator)Utility.lookupObject("ServerActivator", class$com$sun$enterprise$activation$Activator != null ? class$com$sun$enterprise$activation$Activator : (class$com$sun$enterprise$activation$Activator = J2EEServer.class$("com.sun.enterprise.activation.Activator")));
            int[] servers = activator.getActiveServers();
            int i2 = 0;
            while (i2 < servers.length) {
                if (servers[i2] != 0) {
                    activator.shutdown(servers[i2]);
                    System.out.println("server " + servers[i2] + " sucessfully shutdown.");
                }
                ++i2;
            }
            try {
                System.out.println(localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
                activator.shutdown(0);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
        }
    }

    private void startActivationObjects() throws Exception {
        String localHost = Utility.getLocalHost();
        PortableRemoteObject.exportObject(this.repository);
        this.bindObject(this.orb, "AppRepository", this.repository);
        PortableRemoteObject.exportObject(this.serverMgr);
        this.bindObject(this.orb, "ServerLocator", this.serverMgr);
        this.bindObject(this.orb, "ServerActivator", this.serverMgr);
    }

    private WebService startAdminService(ServerConfiguration sc) throws Exception {
        String httpPort = null;
        URL root = null;
        httpPort = sc.getProperty(ADMIN_PORT, DEFAULT_ADMIN_PORT);
        root = new File(this.getApplicationDirectory().getAbsolutePath()).toURL();
        WebService admin = new WebService(Integer.valueOf(httpPort), null, Utility.getLocalHost(), root);
        admin.start();
        return admin;
    }

    private void startAuthenticationService() {
        try {
            AuthenticationServer authSvr = new AuthenticationServer();
            authSvr.init();
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
    }

    private void startRegisteredServers() {
        int[] ids = null;
        try {
            ids = this.repository.listRegisteredServers();
        }
        catch (Exception e10) {
            Log.err.println(e10);
            return;
        }
        int i2 = 0;
        while (i2 < ids.length) {
            try {
                if (ids[i2] != 0) {
                    this.activator.activate(ids[i2], false);
                }
            }
            catch (Exception exception) {}
            ++i2;
        }
    }

    private WebServer startWebService(ServerConfiguration sc) throws Exception {
        WebServer server = WebServer.getInstance();
        server.start();
        return server;
    }
}

