/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.activation.BadServerDefinition;
import com.sun.enterprise.activation.Repository;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerNotActiveException;
import com.sun.enterprise.activation.ServerNotRegisteredException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.server.EJBServer;
import com.sun.enterprise.tools.deployment.backend.ApplicationRegistry;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArray;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArrayImpl;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.tools.deployment.backend.RemoteNotificationListener;
import com.sun.enterprise.tools.generators.Generator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Utility;
import com.sun.web.server.ServletDeployer;
import com.sun.web.server.WebServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class JarInstallerImpl
implements JarInstaller {
    private Vector listeners = new Vector();
    private InitialContext ic = null;
    private Repository serverRepository = null;
    private Activator activator = null;
    private EJBServer server = null;
    private WebServer httpd = null;
    private ApplicationRegistry applicationRegistry = null;
    private static final boolean debug = false;
    public static String port = null;
    public static String jit = System.getProperty("java.compiler");
    public static final String CODEBASE_PREFIX = "http://" + Utility.getLocalAddress() + ":";
    public static final String SERVER_CHANGED = "ServerChanged";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl != null ? class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl : (class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl = JarInstallerImpl.class$("com.sun.enterprise.tools.deployment.backend.JarInstallerImpl")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl;
    static /* synthetic */ Class class$com$sun$web$server$ServletDeployer;

    public JarInstallerImpl(EJBServer server, WebServer httpd, File workingDirectory, Repository rep, Activator act) throws Exception {
        this.applicationRegistry = new ApplicationRegistry(workingDirectory);
        this.ic = new InitialContext();
        this.serverRepository = rep;
        this.activator = act;
        this.server = server;
        this.httpd = httpd;
        ServerConfiguration sconfig = ServerConfiguration.getConfiguration();
        port = sconfig.getProperty("ejb.http.port", "9191");
    }

    public void addRemoteNotificationListener(RemoteNotificationListener listener) throws RemoteException {
        this.listeners.addElement(listener);
    }

    public void changed() throws RemoteException {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            final RemoteNotificationListener nl = (RemoteNotificationListener)e10.nextElement();
            final NotificationEvent ne = new NotificationEvent("", SERVER_CHANGED, SERVER_CHANGED, "");
            Thread notificationThread = new Thread(){

                public void run() {
                    try {
                        nl.notification(ne);
                    }
                    catch (Throwable throwable) {
                        listeners.removeElement(nl);
                    }
                }
            };
            notificationThread.start();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void cleanupNameSpace(String appName) {
        try {
            NamingManager nm = Switch.getSwitch().getNamingManager();
            Application application = JarRepository.getApplicationForName(appName);
            if (application == null) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptioncouldnotopenapplication", "Couldn't open :  {0} ", new Object[]{appName}));
            }
            Vector ejbDescriptors = application.getEjbDescriptors();
            int i2 = 0;
            while (i2 < ejbDescriptors.size()) {
                EjbDescriptor e10 = (EjbDescriptor)ejbDescriptors.elementAt(i2);
                String jndiName = e10.getJndiName();
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.unbindingJNDIname", "Unbinding JNDI name: {0} ", new Object[]{jndiName}));
                nm.unpublishObject(jndiName);
                nm.unbindObjects(e10);
                ++i2;
            }
            Set webDescriptors = application.getWebBundleDescriptors();
            Iterator itr = webDescriptors.iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                nm.unbindObjects(wbd);
            }
        }
        catch (Exception e11) {
            Log.err.println(e11);
        }
    }

    public String deployApplication(BufferedRemoteByteArray applicationBuffer, String applicationName, DeploymentSession session) throws RemoteException {
        byte[] applicationBytes = BufferedRemoteByteArrayImpl.getBytesUtility(applicationBuffer);
        String clientCodeUrl = this.deployApplication(applicationBytes, applicationName, session);
        return clientCodeUrl;
    }

    public String deployApplication(byte[] applicationJar, String applicationName, DeploymentSession session) throws RemoteException {
        File jarFile;
        Object ejbClientJarFile = null;
        String codebase = null;
        int webAppCount = 0;
        Application application = null;
        boolean redeploy = false;
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.contacted.server", "Contacted server..."), session);
        File oldAppJar = null;
        try {
            if (this.isInstalled(applicationName)) {
                redeploy = true;
                String serverJarFileName = JarRepository.getServerJarFilename(applicationName);
                this.undeployApplication(applicationName, redeploy);
                oldAppJar = new File(serverJarFileName);
            }
            jarFile = this.applicationRegistry.newApplicationJarFile(applicationName);
            this.saveAsBytes(applicationJar, jarFile);
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.transferred", "Application {0} transferred", new Object[]{applicationName}), session);
            this.progressEvent("Application Transferred", session);
            application = ApplicationArchivist.open(jarFile);
            ApplicationArchivist.setMakeClassLoadable(true);
            application.getApplicationArchivist().save(application.getApplicationArchivist().getApplicationFile(), true);
        }
        catch (Throwable ioe) {
            Log.err.println(ioe);
            session.setException(new Exception(ioe.getMessage()));
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.error.saving/opening.jar", "Error saving/opening JAR ", new Object[]{ioe.getMessage()}));
        }
        int ejbCount = application.getEjbDescriptors().size();
        webAppCount = application.getWebBundleDescriptors().size();
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.ejb/webcount", "{0} has {1}  ejbs, {2} web components to deploy", new Object[]{application.getName(), new Integer(ejbCount), new Integer(webAppCount)}), session);
        File serverJarFile = jarFile;
        File clientJarFile = jarFile;
        if (ejbCount > 0) {
            boolean deleted;
            serverJarFile = this.applicationRegistry.newEjbServerJarFile(application.getName());
            clientJarFile = this.applicationRegistry.newEjbClientJarFile(application.getName());
            codebase = this.deployEjbs(application, serverJarFile, clientJarFile, session, oldAppJar);
            if (oldAppJar != null && !(deleted = oldAppJar.delete())) {
                Log.err.println("Couldn't delete old app jar : " + oldAppJar);
            }
        }
        if (webAppCount > 0) {
            this.deployWebComponents(serverJarFile, session);
        }
        if (!session.isCancelled()) {
            JarRepository.writeToPropsFile(application.getName(), application.getApplicationArchivist().getApplicationFile(), serverJarFile, clientJarFile);
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.application.deployed", "Application {0} deployed.\n", new Object[]{applicationName}));
            this.changed();
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployment.complete", " Deployment of {0} is complete.", new Object[]{application.getName()}), session);
            this.progressEvent("Done Deploying", session);
            return codebase;
        }
        return null;
    }

    protected String deployEjbs(Application application, File serverJarFile, File clientJarFile, DeploymentSession session, File oldServerJar) throws RemoteException {
        String serverJarName = "";
        int serverId = -1;
        String codebase = String.valueOf(CODEBASE_PREFIX) + port + "/" + application.getName() + "Client.jar";
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployingEjbs", "Deploying Ejbs..."), session);
        try {
            serverJarName = Generator.preDeploy(application.getName(), application.getApplicationArchivist().getApplicationFile(), serverJarFile, clientJarFile, session, oldServerJar);
            if (session.isCancelled()) {
                return null;
            }
        }
        catch (Exception e10) {
            Log.err.println(e10);
            session.setException(e10);
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionprocessingejbjar", " Error processing ejb jar: {0} ", new Object[]{e10.getMessage()}));
        }
        if (this.server == null) {
            try {
                serverId = JarInstallerImpl.registerServer(application.getName(), serverJarFile, this.serverRepository);
            }
            catch (BadServerDefinition e11) {
                session.setException(e11);
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationalreadydeployed", " Application {0} is already deployed", new Object[]{application.getName()}));
            }
            catch (Throwable t2) {
                Log.err.println(t2);
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.servercouldnotberegistered", "server could not be registered"));
            }
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.activatingEJBserverwithid", "Activating EJB Server with id: {0} ", new Object[]{new Integer(serverId)}), session);
            try {
                this.activator.activate(serverId, true);
            }
            catch (Exception e12) {
                Log.err.println(e12);
                session.setException(e12);
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionactivationerror", " Activation error {0} ", new Object[]{e12.getMessage()}));
            }
        }
        JarManagerImpl jarMgr = this.server.getEJBJarManager();
        jarMgr.loadJar(serverJarFile.toString());
        return codebase;
    }

    protected void deployWebComponents(File applicationServerFile, DeploymentSession session) throws RemoteException {
        ServletDeployer webServer = this.getDeploymentModule();
        if (webServer == null) {
            String message = localStrings.getLocalString("enterprise.tools.deployment.backend.webservercouldnotbecontacted", "Error: The Web Server could not be contacted");
            this.progress(message, session);
            throw new RemoteException(message);
        }
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.contactwebservertorun", "Contact the web server and ask it to run: {0} ", new Object[]{applicationServerFile}), session);
        webServer.loadWebComponents(applicationServerFile.toString(), session);
        if (session != null && !session.isCancelled()) {
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.webcomponentdeployed", "Web Components Deployed."), session);
        }
    }

    public Application getApplicationForName(String applicationName) throws RemoteException {
        Application a = null;
        try {
            a = JarRepository.getApplicationForName(applicationName);
            FileOutputStream fos = new FileOutputStream("temp.out");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(a);
        }
        catch (Throwable t2) {
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorreturning.application", " Error returning {0}", new Object[]{applicationName}));
            System.out.println(t2);
        }
        return a;
    }

    public Vector getApplicationNames() throws RemoteException {
        return JarRepository.getApplicationList();
    }

    private ServletDeployer getDeploymentModule() {
        try {
            if (this.httpd == null) {
                Object objref = this.ic.lookup("WebInstaller");
                Object o2 = PortableRemoteObject.narrow(objref, class$com$sun$web$server$ServletDeployer != null ? class$com$sun$web$server$ServletDeployer : (class$com$sun$web$server$ServletDeployer = JarInstallerImpl.class$("com.sun.web.server.ServletDeployer")));
                ServletDeployer deploymentModule = (ServletDeployer)o2;
                return deploymentModule;
            }
            return this.httpd.getDeployer();
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            return null;
        }
    }

    private byte[] getFileAsBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] fileAsBytes = new byte[fileInputStream.available()];
        fileInputStream.read(fileAsBytes);
        fileInputStream.close();
        return fileAsBytes;
    }

    public Vector getGroupNames() throws RemoteException {
        String[] realms = Realm.getSupported();
        Vector groupNames = new Vector();
        if (realms != null) {
            try {
                int i2 = 0;
                while (i2 < realms.length) {
                    Enumeration e10 = Realm.getInstance(realms[i2]).getGroupNames();
                    while (e10.hasMoreElements()) {
                        groupNames.addElement(e10.nextElement());
                    }
                    ++i2;
                }
            }
            catch (Exception e11) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorjarinstallergettinggroupnames", "Jar Installer Error getting group names"));
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptiongettinggroupnames", " Error getting group names: {0} ", new Object[]{e11.getMessage()}));
            }
        }
        return groupNames;
    }

    public Vector getUserNames() throws RemoteException {
        String[] realms = Realm.getSupported();
        Vector userNames = new Vector();
        if (realms != null) {
            try {
                int i2 = 0;
                while (i2 < realms.length) {
                    Enumeration e10 = Realm.getInstance(realms[i2]).getUserNames();
                    while (e10.hasMoreElements()) {
                        userNames.addElement(e10.nextElement());
                    }
                    ++i2;
                }
            }
            catch (Exception e11) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.jarinstallerimplerrorgettingusernames", "Jar Installer Impl Error getting user names"));
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptiongettingusernames", " Error getting user names: {0} ", new Object[]{e11.getMessage()}));
            }
        }
        return userNames;
    }

    public boolean isInstalled(String applicationName) {
        boolean installed = false;
        try {
            installed = this.getApplicationNames().contains(applicationName);
        }
        catch (RemoteException remoteException) {}
        return installed;
    }

    private void progress(String message, DeploymentSession session) {
        block2: {
            if (session == null) break block2;
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable t2) {
                Log.err.println(t2);
            }
        }
    }

    private void progressEvent(String eventType, DeploymentSession session) {
        block2: {
            if (session == null) break block2;
            try {
                session.notification(new NotificationEvent("", eventType, ""));
            }
            catch (Throwable t2) {
                Log.err.println(t2);
            }
        }
    }

    public static int registerServer(String appname, File serverJarFile, Repository repository) throws BadServerDefinition, RemoteException {
        String classpath = "";
        String codebase = String.valueOf(CODEBASE_PREFIX) + port + "/" + appname + "Client.jar";
        String vmArgs = "-Djava.security.policy=" + System.getProperty("com.sun.enterprise.home") + "/lib/security/server.policy";
        vmArgs = String.valueOf(vmArgs) + " -Djava.rmi.server.codebase=" + codebase;
        if (jit != null) {
            vmArgs = String.valueOf(vmArgs) + " -Djava.compiler=" + jit;
        }
        ServerDef serverDef = new ServerDef(appname, "com.sun.enterprise.server.EJBServer", classpath, serverJarFile.getAbsolutePath(), vmArgs);
        int serverId = repository.registerServer(serverDef);
        return serverId;
    }

    private void removeDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i2 = 0;
            while (i2 < files.length) {
                File child = files[i2];
                if (child.isDirectory()) {
                    this.removeDirectory(child);
                }
                child.delete();
                ++i2;
            }
        }
        dir.delete();
    }

    public void removeRemoteNotificationListener(RemoteNotificationListener listener) throws RemoteException {
        this.listeners.removeElement(listener);
    }

    public void restoreWebComponents() throws Exception {
        Vector applicationNames = JarRepository.getApplicationList();
        ServletDeployer webServer = this.getDeploymentModule();
        if (webServer == null) {
            throw new Exception(localStrings.getLocalString("enterprise.tools.deployment.backend.webservernotfound", "Couldn't find of web server to restore the last known applications"));
        }
        Enumeration e10 = applicationNames.elements();
        while (e10.hasMoreElements()) {
            String applicationName = (String)e10.nextElement();
            String applicationFile = JarRepository.getServerJarFilename(applicationName);
            try {
                webServer.loadWebComponents(applicationFile, null);
            }
            catch (Throwable t2) {
                throw new Exception(localStrings.getLocalString("enterprise.tools.deployment.backend.errorrestoring.application", " Error restoring {0}   {1}", new Object[]{applicationName, t2.getMessage()}));
            }
        }
    }

    private void saveAsBytes(byte[] data, File file) throws IOException {
        if (data == null) {
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.backend.nulldata", "null data"));
        }
        FileOutputStream fileStream = new FileOutputStream(file);
        fileStream.write(data, 0, data.length);
        fileStream.close();
    }

    public void undeployApplication(String applicationName) throws RemoteException {
        this.undeployApplication(applicationName, false);
    }

    private void undeployApplication(String applicationName, boolean redeploy) throws RemoteException {
        int serverId = -1;
        try {
            this.cleanupNameSpace(applicationName);
            if (this.server == null) {
                serverId = this.serverRepository.getServerID(applicationName);
                if (serverId != -1) {
                    this.serverRepository.unregisterServer(serverId);
                    this.activator.shutdown(serverId);
                }
            } else {
                serverId = this.serverRepository.getServerID(applicationName);
                if (serverId != -1) {
                    this.serverRepository.unregisterServer(serverId);
                }
            }
            String applicationJarFilename = JarRepository.getJarFilename(applicationName);
            this.getDeploymentModule().unloadWebComponents(applicationJarFilename);
            if (this.server != null) {
                JarManagerImpl jarMgr = this.server.getEJBJarManager();
                jarMgr.undeploy(applicationName);
            }
            JarRepository.getApplicationJarFilenamesFor(applicationName);
            String serverJarFileName = JarRepository.getServerJarFilename(applicationName);
            Enumeration e10 = JarRepository.getApplicationJarFilenamesFor(applicationName).elements();
            while (e10.hasMoreElements()) {
                String nextServerJar = (String)e10.nextElement();
                if (redeploy && nextServerJar.equals(serverJarFileName)) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.delete.nextserverjar", " delete {0}", new Object[]{nextServerJar}));
                boolean deleted = new File(nextServerJar).delete();
                if (deleted) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorjarnotdeleted", " Warning: {0} could not be deleted", new Object[]{nextServerJar}));
            }
            JarRepository.removeFromPropsFile(applicationName);
            this.removeDirectory(Generator.getTempDirectory(applicationName));
        }
        catch (ServerNotRegisteredException serverNotRegisteredException) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotdeployed", " Application {0} is not deployed", new Object[]{applicationName}));
        }
        catch (ServerNotActiveException serverNotActiveException) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotactive", " Applicaiton {0} is not active ", new Object[]{applicationName}));
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotundeployed.reasonnotknown", " Application {0} could not be undeployed - reason unknown", new Object[]{applicationName}));
        }
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.applicationundeployed", " Application {0} has been undeployed", new Object[]{applicationName}));
        this.changed();
    }
}

