/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.tools.deployment.backend.JarInfo;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JarManagerImpl {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl != null ? class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl : (class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl = JarManagerImpl.class$("com.sun.enterprise.tools.deployment.backend.JarManagerImpl")));
    private boolean useOneLoader;
    private JarClassLoader singleLoader;
    private Hashtable jars = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl;

    public JarManagerImpl(boolean useOneLoader) {
        this.useOneLoader = useOneLoader;
        if (useOneLoader) {
            this.singleLoader = JarClassLoader.getInstance();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deploy(EjbDescriptor ejbDescriptor, ClassLoader loader, JarInfo jar, SecurityManager sm) throws Exception {
        ContainerFactory cf2 = Switch.getSwitch().getContainerFactory();
        Container container = cf2.createContainer(ejbDescriptor, loader, sm);
        jar.addContainer(container.getContainerId(), container);
    }

    public void loadJar(String jarName) throws RemoteException {
        System.out.println(jarName);
        Vector beanDescriptors = new Vector();
        try {
            File applicationJarFile = new File(jarName);
            Application application = ApplicationArchivist.open(applicationJarFile);
            beanDescriptors = application.getEjbDescriptors();
            final JarClassLoader loader = this.useOneLoader ? this.singleLoader : new JarClassLoader();
            loader.addJar(jarName);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(loader);
                    return null;
                }
            });
            JarInfo jar = new JarInfo(application.getName());
            this.jars.put(application.getName(), jar);
            Enumeration e10 = beanDescriptors.elements();
            while (e10.hasMoreElements()) {
                EjbDescriptor nextDescriptor = (EjbDescriptor)e10.nextElement();
                EJBSecurityManager ejbSM = new EJBSecurityManager(loader, nextDescriptor);
                this.deploy(nextDescriptor, loader, jar, ejbSM);
            }
        }
        catch (Exception ex2) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.errorloadingjar", "Error while loading JAR {0} ", new Object[]{jarName}), ex2);
        }
    }

    public synchronized void undeploy(String appName) {
        Switch theSwitch = Switch.getSwitch();
        JarInfo jarInfo = (JarInfo)this.jars.get(appName);
        if (jarInfo == null) {
            return;
        }
        Enumeration containers = jarInfo.listContainers();
        while (containers.hasMoreElements()) {
            Container c10 = (Container)containers.nextElement();
            c10.undeploy();
            theSwitch.removeContainer(c10.getContainerId());
        }
        this.jars.remove(appName);
    }
}

