/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.ui.ContentChooser;
import com.sun.enterprise.tools.deployment.ui.IconChanger;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorModes;
import com.sun.enterprise.tools.deployment.ui.OKCancelDialog;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class EjbJarGeneralInspector
extends JPanel
implements Inspector,
InspectorModes,
IconChanger {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector = EjbJarGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbJarGeneralInspector")));
    private static String DESCRIPTION = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:");
    private static String LOCATION = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.location", "Location:");
    private static String JAR_FILE_NAME = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.jarfilename", "JAR File Name:");
    private static String TARGET = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.beantarget", "Enterprise Bean will Go In:");
    private static String MFCLASSPATH = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.manifestclasspath", "Manifest Classpath:");
    private static String CONTENTS = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contents", "Contents:");
    private static String BASEDIR = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.basedirectory", "Base directory:");
    private static String DISPLAYNAME = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.jardisplayname", "JAR Display Name:");
    private static String DELETE = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete");
    private static String ADD = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addellipse", "Add...");
    private static final String CHOOSE_JAR_TITLE = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choosejar", "Choose JAR");
    private String mode = "DeployerMode";
    private String baseDirectory = new String();
    private JTextField locationField = new JTextField(50);
    private JTextField displayNameField = new JTextField(15);
    private IconInspector iconInspector;
    private JTextArea descriptionArea = new JTextArea("", 4, 1);
    private JList classpathList = new JList<String>(new String[]{"", "", "", ""});
    private JList contentsList;
    private DefaultListModel contentsListModel;
    private JButton addButton = new JButton(ADD);
    private JButton deleteButton = new JButton(DELETE);
    private JButton addLibButton;
    private JButton removeLibButton;
    private FileContentsDescriptor contentsMap = new FileContentsDescriptor();
    private ContentChooser contentChooser;
    private JComponent targetChooser = null;
    private boolean bundleInfoEnabled = true;
    private EjbBundleDescriptor descriptor;
    private static String helpSetMapID = "JIGeneral";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$java$awt$Frame;

    public EjbJarGeneralInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initialize();
    }

    public EjbJarGeneralInspector(String mode) {
        this();
        this.mode = mode;
    }

    public EjbJarGeneralInspector(String mode, JComponent targetChooser) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.targetChooser = targetChooser;
        this.initialize();
        this.mode = mode;
    }

    private void addContents(FileContentsDescriptor fcd) {
        if (this.mode.equals("DeveloperMode")) {
            Enumeration e10 = fcd.getFiles();
            while (e10.hasMoreElements()) {
                File nextKey = (File)e10.nextElement();
                this.contentsMap.add(nextKey, fcd.getDirectoryFor(nextKey));
            }
        } else {
            try {
                Archivist archivist = this.descriptor.getArchivist();
                archivist.addFiles(archivist.createEntryNameMap(fcd));
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
        this.refresh();
    }

    private void addContentsAction() {
        if (this.contentChooser == null) {
            this.contentChooser = new ContentChooser(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.chooseclassesfortnterprisebean", "Please click Browse and select the folder that represents the root directory of the classes to be added.\nSelect a file or directory from the root directory tree and click Add."), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.enterprisebeanjarclasses", "Files to be Added:"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choosedirectory", "Root directory"), new File(""), null);
        }
        this.contentChooser.setContentsMap(new FileContentsDescriptor());
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = EjbJarGeneralInspector.class$("java.awt.Frame")), this);
        OKCancelDialog d10 = ContentChooser.createDialog(this.contentChooser, frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addcontentstojarselectenterprisebeanclass", "Add Contents to .JAR - Select Enterprise Bean class files"), "EWAddFile");
        d10.show();
        if (d10.isOK()) {
            this.addContents(this.contentChooser.getContentsMap());
        }
    }

    public void addLargeIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add32Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getLargeIconUri())) {
                this.contentsMap.removeFile(new File(this.descriptor.getLargeIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setLargeIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    private void addLibJarAction() {
        Object[] manifestClasspaths = null;
        try {
            manifestClasspaths = this.mode.equals("DeveloperMode") ? ((Application)((TreeCombo)this.targetChooser).getSelectedDescriptor()).getApplicationArchivist().getLibraryJarUris().toArray() : this.descriptor.getApplication().getApplicationArchivist().getLibraryJarUris().toArray();
        }
        catch (Throwable throwable) {}
        if (Array.getLength(manifestClasspaths) > 0) {
            Object selectedValue = JOptionPane.showInputDialog(null, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choose_library_jar", "Choose a library .jar file"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add_library_jar_title", "Add Library Jar"), 1, null, manifestClasspaths, manifestClasspaths[0]);
            if (selectedValue != null) {
                this.descriptor.getArchivist().addManfiestClasspath((String)selectedValue);
                this.refresh();
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.no_library_jars", "There are no library jar files currently in this application"));
        }
    }

    public void addSmallIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add16Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getSmallIconUri())) {
                this.contentsMap.removeFile(new File(this.descriptor.getSmallIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setSmallIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void clearArchiveContents() {
        DefaultListModel dlm = new DefaultListModel();
        Enumeration e10 = this.contentsMap.getFiles();
        while (e10.hasMoreElements()) {
            dlm.addElement(e10.nextElement());
        }
        this.contentsList.setModel(dlm);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public JList getContentList() {
        return this.contentsList;
    }

    public DefaultListModel getContentListModel() {
        return this.contentsListModel;
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.contentsMap;
    }

    public String getJarFile() {
        return this.locationField.getText();
    }

    private void initialize() {
        this.initializeWidgets();
        this.wireWidgets();
    }

    private void initializeWidgets() {
        JPanel p1 = new JPanel();
        JPanel p2 = null;
        JPanel p3 = null;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(UIUtils.getDefaultBorderSpacing()));
        p1.setLayout(new BorderLayout());
        p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        this.locationField.setText(new File("ejb.jar").getAbsolutePath());
        if (this.targetChooser != null) {
            p3 = UIUtils.createBorderedPanel(TARGET, new BorderLayout());
            p3.add("Center", this.targetChooser);
        } else {
            p3 = this.mode.equals("DeployerMode") ? UIUtils.createBorderedPanel(JAR_FILE_NAME, new BorderLayout()) : UIUtils.createBorderedPanel(LOCATION, new BorderLayout());
            p3.add("Center", this.locationField);
        }
        p2.add("Center", p3);
        p3 = UIUtils.createBorderedPanel(DISPLAYNAME, new BorderLayout());
        p3.add("West", this.displayNameField);
        p2.add("East", p3);
        p1.add("North", p2);
        p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        p3 = UIUtils.createBorderedPanel(DESCRIPTION, new BorderLayout());
        p3.add(new JScrollPane(this.descriptionArea));
        p2.add(p3);
        p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        JPanel p4 = UIUtils.createBorderedPanel(MFCLASSPATH, new BorderLayout());
        JPanel classPathPanel = new JPanel();
        classPathPanel.setLayout(new BorderLayout());
        classPathPanel.add("Center", new JScrollPane(this.classpathList));
        JPanel btnPanel = new JPanel();
        this.addLibButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addellipse", "Add..."));
        this.removeLibButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.remove", "Remove..."));
        btnPanel.add(this.addLibButton);
        btnPanel.add(this.removeLibButton);
        this.addLibButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbJarGeneralInspector.this.addLibJarAction();
            }
        });
        this.removeLibButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbJarGeneralInspector.this.removeLibJarAction();
            }
        });
        p4.add("Center", classPathPanel);
        p4.add("South", btnPanel);
        this.iconInspector = new IconInspector(this);
        p3.add(p4);
        p3.add(this.iconInspector);
        p2.add(p3);
        p1.add("Center", p2);
        p2 = new JPanel();
        GridLayout gl = new GridLayout(4, 1);
        gl.setVgap(10);
        gl.setHgap(10);
        p2.setLayout(gl);
        p2.add(new JLabel(""));
        p2.add(this.addButton);
        p2.add(this.deleteButton);
        p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Contents"));
        p3.setLayout(new BorderLayout());
        this.contentsListModel = new DefaultListModel();
        this.contentsList = new JList(this.contentsListModel);
        p3.add("Center", new JScrollPane(this.contentsList));
        p3.add("East", p2);
        this.add(p1);
        this.add(p3);
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = EjbJarGeneralInspector.class$("javax.swing.JFrame")), this);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        ((Component)frame).setBounds(0, 0, 300, 300);
        frame.setContentPane(new EjbJarGeneralInspector());
        ((Component)frame).setVisible(true);
    }

    private void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.iconInspector.setObject(this.descriptor);
        if (!this.mode.equals("DeveloperMode")) {
            this.locationField.setEnabled(false);
            this.locationField.setText(this.descriptor.getArchivist().getArchiveUri());
            try {
                Vector entryNames = this.descriptor.getArchivist().getEntryNames();
                DefaultListModel<File> contentsListModel = new DefaultListModel<File>();
                int entryIndex = 0;
                while (entryIndex < entryNames.size()) {
                    contentsListModel.addElement(new File((String)entryNames.elementAt(entryIndex)));
                    ++entryIndex;
                }
                this.contentsList.setModel(contentsListModel);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
            DefaultListModel<String> dlm = new DefaultListModel<String>();
            Iterator itr = this.descriptor.getArchivist().getManifestClasspaths().iterator();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                dlm.addElement(next);
            }
            this.classpathList.setModel(dlm);
        } else {
            this.displayNameField.setEnabled(this.bundleInfoEnabled);
            this.descriptionArea.setEnabled(this.bundleInfoEnabled);
            this.classpathList.setEnabled(this.bundleInfoEnabled);
            this.addLibButton.setEnabled(this.bundleInfoEnabled);
            this.removeLibButton.setEnabled(this.bundleInfoEnabled);
            this.iconInspector.setEnabled(this.bundleInfoEnabled);
            DefaultListModel<File> dlm = new DefaultListModel<File>();
            DefaultListModel<String> classPathListModel = new DefaultListModel<String>();
            if (((TreeCombo)this.targetChooser).getSelectedDescriptor() instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor targetBundleDescriptor = (EjbBundleDescriptor)((TreeCombo)this.targetChooser).getSelectedDescriptor();
                try {
                    Vector entryNames = targetBundleDescriptor.getArchivist().getEntryNames();
                    int entryIndex = 0;
                    while (entryIndex < entryNames.size()) {
                        dlm.addElement(new File((String)entryNames.elementAt(entryIndex)));
                        ++entryIndex;
                    }
                }
                catch (Throwable exception) {
                    exception.printStackTrace();
                }
                Iterator itr = targetBundleDescriptor.getArchivist().getManifestClasspaths().iterator();
                while (itr.hasNext()) {
                    String next = (String)itr.next();
                    classPathListModel.addElement(next);
                }
            } else {
                Iterator itr = this.descriptor.getArchivist().getManifestClasspaths().iterator();
                while (itr.hasNext()) {
                    String next = (String)itr.next();
                    classPathListModel.addElement(next);
                }
            }
            Enumeration e10 = this.contentsMap.getFiles();
            while (e10.hasMoreElements()) {
                dlm.addElement((File)e10.nextElement());
            }
            this.classpathList.setModel(classPathListModel);
            this.contentsList.setModel(dlm);
            this.deleteButton.setEnabled(true);
        }
        this.displayNameField.setText(this.descriptor.getName());
        this.descriptionArea.setText(this.descriptor.getDescription());
        this.invalidate();
        this.validate();
    }

    private void removeContentsAction() {
        Object[] selection = this.contentsList.getSelectedValues();
        if (selection == null) {
            return;
        }
        if (this.mode.equals("DeveloperMode")) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.contentsMap.removeFile((File)selection[i2]);
                ++i2;
            }
        } else {
            try {
                int i3 = 0;
                while (i3 < selection.length) {
                    if (((File)selection[i3]).toString().startsWith("META-INF")) {
                        JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cannotdeletecontent", "This content cannot be deleted"));
                    } else {
                        this.descriptor.getArchivist().removeEntry(((File)selection[i3]).toString());
                    }
                    ++i3;
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
        this.refresh();
    }

    private void removeLibJarAction() {
        if (this.classpathList.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.no_library_jars", "There are no library jar files currently in this application"));
            return;
        }
        Object[] selection = this.classpathList.getSelectedValues();
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.descriptor.getArchivist().removeManifestClasspath((String)selection[i2]);
                ++i2;
            }
            this.refresh();
        }
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setBundleInfoEnabled(boolean state) {
        this.bundleInfoEnabled = state;
    }

    public void setJarFile(String jarFilename) {
        this.locationField.setText(jarFilename);
    }

    public void setObject(Object o2) {
        if (o2 instanceof EjbBundleDescriptor) {
            this.descriptor = (EjbBundleDescriptor)o2;
            this.refresh();
        } else {
            this.descriptor = null;
        }
    }

    public String toString() {
        return "Ejb Jar Inspector";
    }

    private void wireWidgets() {
        if (this.targetChooser != null) {
            ItemListener targetArchiveListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e10) {
                    if (EjbJarGeneralInspector.this.descriptor == null) {
                        return;
                    }
                    if (((TreeCombo)EjbJarGeneralInspector.this.targetChooser).getSelectedDescriptor() instanceof EjbBundleDescriptor) {
                        EjbBundleDescriptor targetEjbBundleDescriptor = (EjbBundleDescriptor)((TreeCombo)EjbJarGeneralInspector.this.targetChooser).getSelectedDescriptor();
                        EjbJarGeneralInspector.this.descriptor.setName(targetEjbBundleDescriptor.getName());
                        EjbJarGeneralInspector.this.descriptor.setDescription(targetEjbBundleDescriptor.getDescription());
                        EjbJarGeneralInspector.this.setBundleInfoEnabled(false);
                        EjbJarGeneralInspector.this.refresh();
                    } else {
                        EjbJarGeneralInspector.this.setBundleInfoEnabled(true);
                        EjbJarGeneralInspector.this.clearArchiveContents();
                        EjbJarGeneralInspector.this.refresh();
                    }
                }
            };
            ((TreeCombo)this.targetChooser).addItemListener(targetArchiveListener);
        }
        ActionListener textListener = new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (e10.getSource() == EjbJarGeneralInspector.this.displayNameField) {
                    EjbJarGeneralInspector.this.descriptor.setName(EjbJarGeneralInspector.this.displayNameField.getText());
                }
            }
        };
        this.displayNameField.addActionListener(textListener);
        this.displayNameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                if (EjbJarGeneralInspector.this.descriptor != null) {
                    EjbJarGeneralInspector.this.descriptor.setName(EjbJarGeneralInspector.this.displayNameField.getText().trim());
                }
            }
        });
        this.descriptionArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                if (EjbJarGeneralInspector.this.descriptor != null) {
                    EjbJarGeneralInspector.this.descriptor.setDescription(EjbJarGeneralInspector.this.descriptionArea.getText().trim());
                }
            }
        });
        this.descriptionArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (UIUtils.isEnterKey(ke) && EjbJarGeneralInspector.this.descriptor != null) {
                    EjbJarGeneralInspector.this.descriptor.setDescription(EjbJarGeneralInspector.this.descriptionArea.getText().trim());
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbJarGeneralInspector.this.addContentsAction();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbJarGeneralInspector.this.removeContentsAction();
            }
        });
    }
}

