/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class EjbRefsInspector
extends JPanel
implements Inspector,
TableInspector {
    EjbRefsTable ejbRefsTable;
    JButton addPB;
    JButton delPB;
    JTextArea descriptionText;
    JTextField linkValueText;
    JComboBox linkTypeCombo;
    JPanel deploymentSettingsPanel;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector = EjbRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbRefsInspector")));
    WritableJndiNameEnvironment descriptor;
    String inspectorMode = "DeveloperMode";
    String[] ejbTypes = new String[]{"Session", "Entity"};
    public static final String EXTERNAL_JNDI_NAME = "External (JNDI name)";
    public static final String INTERNAL_EJB_NAME = "Internal (Enterprise Bean name)";
    final String[] linkTypes = new String[]{"External (JNDI name)", "Internal (Enterprise Bean name)"};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbRefsInspector;

    public EjbRefsInspector(String inspectorMode) {
        this.initializeLayout();
        this.setInspectorMode(inspectorMode);
    }

    private void addEjbRefAction() {
        this.editingStopped();
        this.ejbRefsTable.getSelectionModel().clearSelection();
        EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor();
        ejbReference.setName("");
        ejbReference.setType(this.ejbTypes[0]);
        ejbReference.setHomeClassName("");
        ejbReference.setRemoteClassName("");
        ejbReference.setDescription("");
        this.descriptor.addEjbReferenceDescriptor(ejbReference);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deSelectAction() {
        this.descriptionText.setText("");
        this.linkValueText.setText("");
        this.descriptionText.setEnabled(false);
        this.linkValueText.setEnabled(false);
        this.linkTypeCombo.setEnabled(false);
        this.deploymentSettingsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment Settings")));
    }

    private void deleteEjbRefAction() {
        this.editingStopped();
        ListSelectionModel sm = this.ejbRefsTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedejbreference", "Are you sure you want to delete selected EJB reference?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deleteejbreference", "Delete EJB reference"), 0);
            if (n2 == 0) {
                EjbReferenceDescriptor ejbReference = this.getTableModel().getRow(index);
                this.descriptor.removeEjbReferenceDescriptor(ejbReference);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectejbreffromlist", "You must first select a EJB reference from list"));
        }
    }

    public void editingStopped() {
        this.ejbRefsTable.editingStopped(new ChangeEvent(this));
    }

    EjbReferenceDescriptor getSelectedEjbReference() {
        int minIndex;
        EjbReferenceDescriptor ejbRef = null;
        ListSelectionModel lsm = this.ejbRefsTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            ejbRef = this.getTableModel().getRow(minIndex);
        }
        return ejbRef;
    }

    EjbRefsTableModel getTableModel() {
        return (EjbRefsTableModel)this.ejbRefsTable.getModel();
    }

    private void initializeLayout() {
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        this.setLayout(gb1);
        JPanel ejbRefsPanel = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        ejbRefsPanel.setLayout(gb2);
        ejbRefsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.ejbrefrencedincode", "EJB's referenced in code")));
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(ejbRefsPanel, c10);
        this.add(ejbRefsPanel);
        this.ejbRefsTable = new EjbRefsTable(new EjbRefsTableModel(new HashSet()));
        this.ejbRefsTable.getSelectionModel().addListSelectionListener(new EjbRefsSelectionListener());
        this.ejbRefsTable.setAutoResizeMode(4);
        JScrollPane ejbRefsTablePane = new JScrollPane(this.ejbRefsTable);
        ejbRefsTablePane.setBorder(BorderFactory.createLoweredBevelBorder());
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.75;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb2.setConstraints(ejbRefsTablePane, c10);
        ejbRefsPanel.add(ejbRefsTablePane);
        JPanel ejbRefsButtonPanel = new JPanel();
        ejbRefsButtonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        gb2.setConstraints(ejbRefsButtonPanel, c10);
        ejbRefsPanel.add(ejbRefsButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        ejbRefsButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbRefsInspector.this.addEjbRefAction();
            }
        });
        this.delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletebutton", "Delete..."));
        ejbRefsButtonPanel.add(this.delPB);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbRefsInspector.this.deleteEjbRefAction();
            }
        });
        JLabel descriptionLabel = new JLabel("Description:");
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb2.setConstraints(descriptionLabel, c10);
        ejbRefsPanel.add(descriptionLabel);
        this.descriptionText = new JTextArea();
        JScrollPane descriptionTextPane = new JScrollPane(this.descriptionText);
        c10.weightx = 0.5;
        c10.weighty = 0.25;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gb2.setConstraints(descriptionTextPane, c10);
        ejbRefsPanel.add(descriptionTextPane);
        this.descriptionText.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent me) {
                EjbRefsInspector.this.storeDescription();
            }
        });
        this.descriptionText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    EjbRefsInspector.this.storeDescription();
                }
            }
        });
        this.deploymentSettingsPanel = new JPanel();
        GridBagLayout gb3 = new GridBagLayout();
        this.deploymentSettingsPanel.setLayout(gb3);
        this.deploymentSettingsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment Settings")));
        c10.weighty = 0.0;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(this.deploymentSettingsPanel, c10);
        this.add(this.deploymentSettingsPanel);
        JLabel linkTypeLabel = new JLabel("Link type:");
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb3.setConstraints(linkTypeLabel, c10);
        this.linkTypeCombo = new JComboBox<String>(this.linkTypes);
        this.linkTypeCombo.addItemListener(new LinkTypeItemListener());
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb3.setConstraints(this.linkTypeCombo, c10);
        JLabel linkValueLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.linkvalue", "JNDI Name:"));
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb3.setConstraints(linkValueLabel, c10);
        this.deploymentSettingsPanel.add(linkValueLabel);
        this.linkValueText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb3.setConstraints(this.linkValueText, c10);
        this.deploymentSettingsPanel.add(this.linkValueText);
        this.linkValueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                EjbRefsInspector.this.storeLinkValue();
            }
        });
        this.linkValueText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    EjbRefsInspector.this.storeLinkValue();
                }
            }
        });
        this.deSelectAction();
    }

    public static void main(String[] args) {
        final EjbRefsInspector ei2 = new EjbRefsInspector("DeveloperMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbSessionDescriptor descriptor = new EjbSessionDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setObject(descriptor);
            }
        });
        ei2.setObject(descriptor);
    }

    protected void refresh() {
        ((InspectorTableModel)this.ejbRefsTable.getModel()).updateTableData(this.descriptor.getEjbReferenceDescriptors());
        this.ejbRefsTable.sizeColumnsToFit(0);
        this.showEjbRef(this.getSelectedEjbReference());
    }

    private void selectAction() {
        this.descriptionText.setEnabled(true);
        this.showEjbRef(this.getSelectedEjbReference());
        this.linkValueText.setEnabled(true);
        this.linkTypeCombo.setEnabled(true);
    }

    public void setInspectorMode(String mode) {
        this.inspectorMode = mode;
        boolean isDevelopment = this.inspectorMode.equalsIgnoreCase("DeveloperMode");
        this.linkValueText.setEnabled(isDevelopment ^ true);
        this.linkTypeCombo.setEnabled(isDevelopment ^ true);
    }

    public void setObject(Object o2) {
        if (o2 instanceof WritableJndiNameEnvironment) {
            WritableJndiNameEnvironment previousDescriptor = this.descriptor;
            this.descriptor = (WritableJndiNameEnvironment)o2;
            if (!this.descriptor.equals(previousDescriptor)) {
                this.editingStopped();
                this.ejbRefsTable.getSelectionModel().clearSelection();
            }
            this.refresh();
        }
    }

    public void setVisible(boolean b10) {
        if (!b10) {
            this.editingStopped();
        }
        super.setVisible(b10);
    }

    private void showEjbRef(EjbReferenceDescriptor ejbRef) {
        if (ejbRef != null) {
            this.deploymentSettingsPanel.setBorder(new TitledBorder(String.valueOf(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment Settings")) + " for " + ejbRef.getName()));
            this.descriptionText.setText(ejbRef.getDescription());
            this.linkValueText.setText(ejbRef.getJndiName());
        } else {
            this.deSelectAction();
        }
    }

    private void storeDescription() {
        EjbReferenceDescriptor ejbRef = this.getSelectedEjbReference();
        if (ejbRef != null) {
            ejbRef.setDescription(this.descriptionText.getText().trim());
        }
    }

    private void storeLinkType(String linkType) {
        EjbReferenceDescriptor ejbRef = this.getSelectedEjbReference();
    }

    private void storeLinkValue() {
        EjbReferenceDescriptor ejbRef = this.getSelectedEjbReference();
        if (ejbRef != null) {
            ejbRef.setJndiName(this.linkValueText.getText().trim());
        }
        if (this.descriptor != null) {
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    class EjbRefsSelectionListener
    implements ListSelectionListener {
        EjbRefsSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (sm.isSelectionEmpty()) {
                EjbRefsInspector.this.deSelectAction();
            } else {
                EjbRefsInspector.this.selectAction();
            }
        }
    }

    class LinkTypeItemListener
    implements ItemListener {
        LinkTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            String item = (String)evt.getItem();
            EjbRefsInspector.this.storeLinkType(item);
        }
    }

    private class EjbRefsTable
    extends InspectorTable {
        int selectedRow = -1;

        public EjbRefsTable(EjbRefsTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.tableejbrefs", "Table of EJB references"));
            this.setSelectionMode(0);
            this.setupTypeColumn();
        }

        private void setSelectedRow(int index) {
            Integer oldIndex = new Integer(this.selectedRow);
            this.selectedRow = index;
        }

        void setupTypeColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            JComboBox<String> typeComboBox = new JComboBox<String>(EjbRefsInspector.this.ejbTypes);
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clicktoeditejbtype", "Click to edit EJB type"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class EjbRefsTableModel
    extends InspectorTableModel {
        EjbRefsInspector inspector;

        public EjbRefsTableModel(Set ejbReferenceDescriptors) {
            super(new ArrayList(ejbReferenceDescriptors), new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.codedname", "Coded Name"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.type", "Type"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.home", "Home"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.remote", "Remote")});
        }

        public EjbReferenceDescriptor getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (EjbReferenceDescriptor)this.data.get(index);
        }

        public Object getValueAt(int row, int col) {
            EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)this.data.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = ejbReference.getName();
                    break;
                }
                case 1: {
                    value = ejbReference.getType();
                    break;
                }
                case 2: {
                    value = ejbReference.getHomeClassName();
                    break;
                }
                case 3: {
                    value = ejbReference.getRemoteClassName();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            EjbReferenceDescriptor ejbReference = this.getRow(row);
            if (ejbReference == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ejbReference.setName(value.toString());
                    ((Descriptor)((Object)EjbRefsInspector.this.descriptor)).changed();
                    return;
                }
                case 1: {
                    ejbReference.setType(value.toString());
                    break;
                }
                case 2: {
                    ejbReference.setHomeClassName(value.toString());
                    break;
                }
                case 3: {
                    ejbReference.setRemoteClassName(value.toString());
                    break;
                }
            }
            ((Descriptor)((Object)EjbRefsInspector.this.descriptor)).changed();
        }
    }
}

