/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RolesInspector
extends JPanel
implements Inspector,
TableInspector {
    RolesTable rolesTable;
    JButton addPB;
    JButton delPB;
    String inspectorMode = "DeveloperMode";
    Roles descriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector = RolesInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.RolesInspector")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector;

    public RolesInspector(String inspectorMode) {
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        JPanel rolesPanel = new JPanel();
        rolesPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.definedroles", "Defined Roles")));
        GridBagLayout gb2 = new GridBagLayout();
        rolesPanel.setLayout(gb2);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(rolesPanel, c10);
        this.add(rolesPanel);
        this.rolesTable = new RolesTable(new RolesTableModel(new HashSet()));
        JScrollPane rolesTablePane = new JScrollPane(this.rolesTable);
        this.rolesTable.setAutoResizeMode(4);
        rolesTablePane.setPreferredSize(new Dimension(400, 150));
        this.rolesTable.setSelectionMode(0);
        ListSelectionModel rolesSelectionModel = this.rolesTable.getSelectionModel();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb2.setConstraints(rolesTablePane, c10);
        rolesPanel.add(rolesTablePane);
        JPanel rolesButtonPanel = new JPanel();
        rolesButtonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        gb2.setConstraints(rolesButtonPanel, c10);
        rolesPanel.add(rolesButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        rolesButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RolesInspector.this.addRoleAction();
            }
        });
        this.delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletebutton", "Delete..."));
        rolesButtonPanel.add(this.delPB);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RolesInspector.this.deleteRoleAction();
            }
        });
        if (inspectorMode != null) {
            this.inspectorMode = inspectorMode;
        }
        this.deSelectAction();
    }

    protected void addRoleAction() {
        this.editingStopped();
        this.rolesTable.getSelectionModel().clearSelection();
        Role role = new Role("");
        this.descriptor.addRole(role);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deSelectAction() {
    }

    protected void deleteRoleAction() {
        this.editingStopped();
        RolesTableModel model = (RolesTableModel)this.rolesTable.getModel();
        int index = this.rolesTable.getSelectedRow();
        if (index >= 0 && index <= model.getMaximumEditableRowIndex()) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedrole", "Are you sure you want to delete selected role?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deleterole", "Delete role"), 0);
            if (n2 == 0) {
                this.descriptor.removeRole(this.getTableModel().get(index));
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectrolefromlist", "You must first select a role from list"));
        }
    }

    public void editingStopped() {
        this.rolesTable.editingStopped(new ChangeEvent(this));
    }

    RolesTableModel getTableModel() {
        return (RolesTableModel)this.rolesTable.getModel();
    }

    public static void main(String[] args) {
        final RolesInspector ei2 = new RolesInspector("DeveloperMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbBundleDescriptor descriptor = new EjbBundleDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setObject(descriptor);
            }
        });
        ei2.setObject(descriptor);
    }

    public void refresh() {
        ((InspectorTableModel)this.rolesTable.getModel()).updateTableData(this.descriptor.getRoles());
        this.rolesTable.sizeColumnsToFit(0);
    }

    private void selectAction() {
    }

    public void setInspectorMode(String mode) {
        this.inspectorMode = mode;
    }

    public void setObject(Object o2) {
        if (o2 instanceof Roles) {
            Roles previousDescriptor = this.descriptor;
            this.descriptor = (Roles)o2;
            if (!this.descriptor.equals(previousDescriptor)) {
                this.editingStopped();
                this.rolesTable.getSelectionModel().clearSelection();
            }
            this.refresh();
        }
    }

    public void setVisible(boolean b10) {
        if (!b10) {
            this.editingStopped();
        }
        super.setVisible(b10);
    }

    private class RolesTable
    extends InspectorTable {
        public RolesTable(RolesTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }

    class RolesTableModel
    extends InspectorTableModel {
        boolean renamingRole = false;

        public RolesTableModel(Set roleSet) {
            super(new ArrayList(roleSet), new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.name", "Name"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.editrolesdescription", "Description")}, 0);
        }

        public Role get(int i2) {
            return (Role)this.data.get(i2);
        }

        List getRoles() {
            return this.data;
        }

        public Role getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (Role)this.data.get(index);
        }

        public Object getValueAt(int row, int col) {
            Role role = (Role)this.data.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = role.getName();
                    break;
                }
                case 1: {
                    value = role.getDescription();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            Role role = this.getRow(row);
            if (role == null) {
                return;
            }
            switch (col) {
                case 0: {
                    Role newRole = new Role(value.toString());
                    newRole.setDescription(role.getDescription());
                    if (role != null) {
                        this.renamingRole = true;
                        this.data.set(row, newRole);
                        RolesInspector.this.descriptor.removeRole(role);
                    }
                    this.renamingRole = false;
                    RolesInspector.this.descriptor.addRole(newRole);
                    break;
                }
                case 1: {
                    role.setDescription(value.toString());
                    break;
                }
            }
        }

        public void updateTableData(Collection c10) {
            try {
                Iterator i2;
                int i3 = 0;
                while (i3 < this.data.size()) {
                    Role r1 = (Role)this.data.get(i3);
                    int j2 = 0;
                    while (j2 < this.data.size()) {
                        Role r2 = (Role)this.data.get(j2);
                        if (r1.getName().equals(r2.getName()) && i3 != j2) {
                            this.data.remove(r2);
                        }
                        ++j2;
                    }
                    ++i3;
                }
                if (!c10.containsAll(this.data)) {
                    i2 = this.data.iterator();
                    while (i2.hasNext()) {
                        Object o2 = i2.next();
                        if (c10.contains(o2) || this.renamingRole) continue;
                        this.data.remove(o2);
                    }
                }
                if (!this.data.containsAll(c10)) {
                    i2 = c10.iterator();
                    while (i2.hasNext()) {
                        Object o3 = i2.next();
                        if (this.data.contains(o3)) continue;
                        this.data.add(o3);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
            this.setMaximumEditableRowIndex(this.data.size() - 1);
            this.fireTableDataChanged();
        }
    }

    class RolesSelectionListener
    implements ListSelectionListener {
        RolesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            int firstIndex = e10.getFirstIndex();
            int lastIndex = e10.getLastIndex();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (!sm.isSelectionEmpty()) {
                int minIndex = sm.getMinSelectionIndex();
                int maxIndex = sm.getMaxSelectionIndex();
                int i2 = minIndex;
                while (i2 <= maxIndex) {
                    sm.isSelectedIndex(i2);
                    ++i2;
                }
            }
        }
    }
}

