/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class ContainerTransactionStyle3
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        try {
            boolean oneFailed = false;
            int na = 0;
            boolean foundItInWildCard = false;
            boolean style2 = false;
            boolean foundItInHomeInterface = false;
            boolean foundItInRemoteInterface = false;
            if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> hc = jcl.loadClass(descriptor.getHomeClassName());
                    Method[] hMethods = hc.getMethods();
                    Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                    Method[] rMethods = rc.getMethods();
                    Enumeration ee2 = descriptor.getMethodContainerTransactions().keys();
                    while (ee2.hasMoreElements()) {
                        foundItInWildCard = false;
                        style2 = false;
                        foundItInHomeInterface = false;
                        foundItInRemoteInterface = false;
                        MethodDescriptor methodDescriptor = (MethodDescriptor)ee2.nextElement();
                        if (methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS)) {
                            foundItInWildCard = true;
                        } else if (methodDescriptor.getParameterClassNames() == null) {
                            style2 = true;
                        }
                        if (!foundItInWildCard && !style2) {
                            int i2 = 0;
                            while (i2 < hMethods.length) {
                                if ((methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME)) && hMethods[i2].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(hMethods[i2], descriptor, jcl).getParameterClassNames())) {
                                    foundItInHomeInterface = true;
                                    break;
                                }
                                ++i2;
                            }
                            if (!foundItInHomeInterface) {
                                int j2 = 0;
                                while (j2 < rMethods.length) {
                                    if ((methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE)) && rMethods[j2].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(rMethods[j2], descriptor, jcl).getParameterClassNames())) {
                                        foundItInRemoteInterface = true;
                                        break;
                                    }
                                    ++j2;
                                }
                            }
                        }
                        if (foundItInWildCard) {
                            ++na;
                            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Container Transaction method name [ {0} ], test not applicable.", new Object[]{methodDescriptor.getName()}));
                            continue;
                        }
                        if (style2) {
                            ++na;
                            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable3", "Container Transaction method name [ {0} ] uses style2 container transaction, test not applicable.", new Object[]{methodDescriptor.getName()}));
                            continue;
                        }
                        if (foundItInHomeInterface) {
                            result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Container Transaction method name [ {0} ] defined in [ {1} ] interface.", new Object[]{methodDescriptor.getName(), "Home"}));
                            continue;
                        }
                        if (foundItInRemoteInterface) {
                            result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Container Transaction method name [ {0} ] defined in [ {1} ] interface.", new Object[]{methodDescriptor.getName(), "Remote"}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Container Transaction method name [ {0} ] not defined in [ {1} ] or [ {2} ] interface.", new Object[]{methodDescriptor.getName(), "Home", "Remote"}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    oneFailed = true;
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Home interface [ {0} ] or Remote interface [ {1} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getRemoteClassName(), descriptor.getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (na == descriptor.getMethodContainerTransactions().size()) {
                    result.setStatus(3);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no method permissions within this bean [ {0} ]", new Object[]{descriptor.getName()}));
            }
            return result;
        }
        catch (Throwable t2) {
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException2", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), t2.getMessage(), descriptor.getName()}));
            return result;
        }
    }
}

