/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class EjbEnvEntryValueType
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        boolean oneFailed = false;
        if (!descriptor.getEnvironmentProperties().isEmpty()) {
            Iterator itr2 = descriptor.getEnvironmentProperties().iterator();
            while (itr2.hasNext()) {
                EnvironmentProperty nextEnvironmentProperty = (EnvironmentProperty)itr2.next();
                String envType = nextEnvironmentProperty.getType();
                if (envType.equals("java.lang.String") || envType.equals("java.lang.Integer") || envType.equals("java.lang.Boolean") || envType.equals("java.lang.Double") || envType.equals("java.lang.Byte") || envType.equals("java.lang.Short") || envType.equals("java.lang.Long") || envType.equals("java.lang.Float")) {
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Environment entry value [ {0} ] has valid value type [ {1} ] within bean [ {2} ]", new Object[]{nextEnvironmentProperty.getName(), envType, descriptor.getName()}));
                    continue;
                }
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Environment entry value [ {0} ] does not have valid value type [ {1} ] within bean [ {2} ]", new Object[]{nextEnvironmentProperty.getName(), envType, descriptor.getName()}));
            }
            if (!oneFailed) {
                result.setStatus(0);
            } else {
                result.setStatus(1);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no environment entry elements defined within this bean [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

