/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class EjbNameUnique
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        String ejbName = descriptor.getName();
        boolean oneFailed = false;
        int found = 0;
        Iterator itr = descriptor.getEjbBundleDescriptor().getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            if (!ejbDescriptor.getName().equals(ejbName) || ++found <= 1) continue;
            if (!oneFailed) {
                oneFailed = true;
            }
            result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] has found [ {1} ] duplicate ejb name(s) within the same jar.", new Object[]{ejbName, new Integer(found - 1)}));
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: [ {0} ] was found once within jar, ejb-name is unique.", new Object[]{ejbName}));
        }
        return result;
    }
}

