/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class PersistenceFieldsElement
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            block15: {
                String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
                if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                    if (this.debug) {
                        System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "[ {0} ] is valid persistentType.", new Object[]{persistentType}));
                    }
                    Set persistentFields = ((EjbEntityDescriptor)descriptor).getPersistentFields();
                    Iterator iterator = persistentFields.iterator();
                    try {
                        JarClassLoader jcl = JarClassLoader.getInstance();
                        Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                        boolean oneFailed = false;
                        while (iterator.hasNext()) {
                            Descriptor persistentField = (Descriptor)iterator.next();
                            try {
                                Field field = c10.getField(persistentField.getName());
                                result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] field found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: NoSuchFieldException: [ {0} ] not found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                if (oneFailed) continue;
                                oneFailed = true;
                            }
                            catch (SecurityException securityException) {
                                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException2", "Error: SecurityException: [ {0} ] not found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                if (oneFailed) continue;
                                oneFailed = true;
                            }
                        }
                        if (oneFailed) {
                            result.setStatus(1);
                            break block15;
                        }
                        result.setStatus(0);
                    }
                    catch (ClassNotFoundException e10) {
                        Verifier.debug(e10);
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException3", "Error: Fields don't exist or are not loadable within bean [ {0} ]", new Object[]{descriptor.getName()}));
                    }
                } else if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType)) {
                    result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Expected persistence type [ {0} ], but [ {1} ] bean has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistentType}));
                } else {
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] is not valid persistentType within bean [ {1} ]", new Object[]{persistentType, descriptor.getName()}));
                }
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

