/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class URLPattern
implements WebCheck {
    boolean debug = Verifier.getDebug();

    public Result check(WebBundleDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            int na = 0;
            int noSc = 0;
            int naWRC = 0;
            int noWRC = 0;
            Enumeration e10 = descriptor.getSecurityConstraints();
            while (e10.hasMoreElements()) {
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e10.nextElement();
                if (securityConstraintImpl.getWebResourceCollections().hasMoreElements()) {
                    Enumeration ee2 = securityConstraintImpl.getWebResourceCollections();
                    while (ee2.hasMoreElements()) {
                        ++noWRC;
                        WebResourceCollectionImpl webResourceCollection = (WebResourceCollectionImpl)ee2.nextElement();
                        if (webResourceCollection.getUrlPatterns().hasMoreElements()) {
                            Enumeration eee = webResourceCollection.getUrlPatterns();
                            while (eee.hasMoreElements()) {
                                String nextUrlPattern = (String)eee.nextElement();
                                if (nextUrlPattern != null) {
                                    if (nextUrlPattern.startsWith("/") || nextUrlPattern.startsWith("/") && nextUrlPattern.endsWith("/*") || nextUrlPattern.startsWith("*.")) {
                                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Content of the url-pattern element [ {0} ] follows the rules specified in section 10 of the servlet specification within [ {1} ]", new Object[]{nextUrlPattern, descriptor.getName()}));
                                        continue;
                                    }
                                    if (!oneFailed) {
                                        oneFailed = true;
                                    }
                                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Content of the url-pattern element [ {0} ] does not follow the rules specified in section 10 of the servlet specification within [ {1} ]", new Object[]{nextUrlPattern, descriptor.getName()}));
                                    continue;
                                }
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed1", "Error: Content of the url-pattern element is null and does not follow the rules specified in section 10 of the servlet specification within [ {0} ]", new Object[]{descriptor.getName()}));
                            }
                            continue;
                        }
                        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "There are no web url-patterns in the web resource collection [ {0} ] within [ {1} ]", new Object[]{webResourceCollection.getName(), descriptor.getName()}));
                        ++naWRC;
                    }
                    continue;
                }
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "There are no web web resource collections in the web security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc || naWRC == noWRC) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no web components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

