/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class WebSecurityRoleName
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int naSr = 0;
            int naAci = 0;
            int noAci = 0;
            int noSc = 0;
            Enumeration e10 = descriptor.getSecurityConstraints();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e10.nextElement();
                AuthorizationConstraintImpl aci = (AuthorizationConstraintImpl)securityConstraintImpl.getAuthorizationConstraint();
                if (aci != null) {
                    ++noAci;
                    if (aci.getSecurityRoles().hasMoreElements()) {
                        Enumeration ee2 = aci.getSecurityRoles();
                        while (ee2.hasMoreElements()) {
                            SecurityRoleDescriptor srd = (SecurityRoleDescriptor)ee2.nextElement();
                            String roleName = srd.getName();
                            foundIt = roleName.length() > 0;
                            if (foundIt) {
                                result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The security role name [ {0} ] found within web application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
                                continue;
                            }
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: The security role name [ {0} ] not found within web application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
                        }
                        continue;
                    }
                    result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Not Applicable: There are no security roles in this security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                    ++naSr;
                    continue;
                }
                result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Not Applicable: There is no authorization constraint in this security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++naAci;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (noSc == naAci || noAci == naSr) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no role-name elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

