/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.otsidl.ResourceStatus;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.Vote;

class RegisteredResources {
    private Vector resourceObjects = null;
    private Vector resourceStates = null;
    private CoordinatorLog logRecord = null;
    private java.lang.Object logSection = null;
    private java.lang.Object heuristicLogSection = null;
    private int commitRetries = -1;
    private static String commitRetryVar = Configuration.getPropertyValue("com.sun.jts.commitRetry");
    private static final long COMMIT_RETRY_WAIT = 60000L;
    private static final String LOG_SECTION_NAME = "RR";
    private static final String HEURISTIC_LOG_SECTION_NAME = "RRH";

    RegisteredResources() {
    }

    RegisteredResources(CoordinatorLog log) {
        this.resourceObjects = new Vector();
        this.resourceStates = new Vector();
        this.logRecord = log;
        if (log != null) {
            this.logSection = log.createSection(LOG_SECTION_NAME);
            this.heuristicLogSection = log.createSection(HEURISTIC_LOG_SECTION_NAME);
        }
    }

    int addRes(Resource obj) {
        this.resourceObjects.addElement(obj);
        this.resourceStates.addElement(ResourceStatus.Registered);
        int result = this.resourceObjects.size();
        return result;
    }

    void commitOnePhase() throws HeuristicMixed, HeuristicHazard {
        boolean infiniteRetry = true;
        boolean heuristicRaisedSetStatus = false;
        boolean heuristicExceptionFlowForget = false;
        boolean isProxy = false;
        boolean heuristicMixed = false;
        boolean heuristicHazard = false;
        boolean rollback_occurred = false;
        boolean outstanding_resources = true;
        if (this.commitRetries == -1 && commitRetryVar != null) {
            try {
                this.commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable exc) {
                ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "CommitOnePhase commitRetryVar"}, true);
            }
            infiniteRetry = false;
        }
        if (this.resourceObjects.size() > 1) {
            ErrorLog.error(14, new java.lang.Object[]{"commitOnePhase", ">1 Resource"}, true);
        }
        Resource currResource = (Resource)this.resourceObjects.elementAt(0);
        if ((ResourceStatus)this.resourceStates.elementAt(0) != ResourceStatus.Registered) {
            return;
        }
        if (!(currResource instanceof OTSResourceImpl)) {
            ProxyChecker checkProxy = Configuration.getProxyChecker();
            isProxy = checkProxy.isProxy(currResource);
        }
        this.resourceStates.setElementAt(ResourceStatus.Completing, 0);
        int commitRetriesLeft = this.commitRetries;
        boolean exceptionThrownTryAgain = true;
        while (exceptionThrownTryAgain) {
            try {
                currResource.commit_one_phase();
                this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                exceptionThrownTryAgain = false;
            }
            catch (Throwable exc) {
                if (exc instanceof TRANSACTION_ROLLEDBACK) {
                    rollback_occurred = true;
                    this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                    exceptionThrownTryAgain = false;
                    continue;
                }
                if (exc instanceof HeuristicHazard) {
                    heuristicExceptionFlowForget = true;
                    heuristicRaisedSetStatus = true;
                    exceptionThrownTryAgain = false;
                    heuristicMixed = false;
                    continue;
                }
                if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                    this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                    exceptionThrownTryAgain = false;
                    continue;
                }
                if (exc instanceof NotPrepared) {
                    ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "commit one phase"}, true);
                    continue;
                }
                if (!(exc instanceof TRANSIENT) && !(exc instanceof COMM_FAILURE)) {
                    ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "commit one phase"}, true);
                    continue;
                }
                if (commitRetriesLeft > 0 || infiniteRetry) {
                    if (!infiniteRetry) {
                        --commitRetriesLeft;
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                ErrorLog.error(15, new java.lang.Object[]{new Integer(this.commitRetries), "commitOnePhase"}, true);
            }
        }
        if (heuristicRaisedSetStatus) {
            this.resourceStates.setElementAt(ResourceStatus.Heuristic, 0);
            if (this.logRecord != null) {
                this.logRecord.addObject(this.heuristicLogSection, currResource);
            }
        } else {
            this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
            if (isProxy) {
                currResource._release();
            }
        }
        if (heuristicExceptionFlowForget) {
            this.distributeForget(this.commitRetries, infiniteRetry, heuristicMixed);
        }
        if (rollback_occurred) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
        }
    }

    void distributeCommit() throws HeuristicMixed, HeuristicHazard {
        boolean infiniteRetry = true;
        boolean isProxy = false;
        boolean heuristicException = false;
        boolean heuristicMixed = false;
        if (this.commitRetries == -1 && commitRetryVar != null) {
            try {
                this.commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable throwable) {}
            infiniteRetry = false;
        }
        int i2 = 0;
        while (i2 < this.resourceObjects.size()) {
            Resource currResource = (Resource)this.resourceObjects.elementAt(i2);
            if ((ResourceStatus)this.resourceStates.elementAt(i2) == ResourceStatus.Registered) {
                boolean heuristicRaised = false;
                if (!(currResource instanceof OTSResourceImpl)) {
                    ProxyChecker checkProxy = Configuration.getProxyChecker();
                    isProxy = checkProxy.isProxy(currResource);
                }
                this.resourceStates.setElementAt(ResourceStatus.Completing, i2);
                int commitRetriesLeft = this.commitRetries;
                boolean exceptionThrown = true;
                while (exceptionThrown) {
                    try {
                        currResource.commit();
                        exceptionThrown = false;
                    }
                    catch (Throwable exc) {
                        if (exc instanceof HeuristicCommit) {
                            heuristicException = true;
                            heuristicRaised = true;
                            exceptionThrown = false;
                            continue;
                        }
                        if (exc instanceof HeuristicRollback || exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                            heuristicException = true;
                            heuristicMixed = exc instanceof HeuristicHazard ^ true;
                            heuristicRaised = true;
                            exceptionThrown = false;
                            continue;
                        }
                        if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                            exceptionThrown = false;
                            continue;
                        }
                        if (exc instanceof NotPrepared) {
                            ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "commit"}, true);
                            continue;
                        }
                        if (!(exc instanceof TRANSIENT) && !(exc instanceof COMM_FAILURE)) {
                            ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "commit"}, true);
                            continue;
                        }
                        if (commitRetriesLeft > 0 || infiniteRetry) {
                            if (!infiniteRetry) {
                                --commitRetriesLeft;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        ErrorLog.error(15, new java.lang.Object[]{new Integer(this.commitRetries), "commit"}, true);
                    }
                }
                if (heuristicRaised) {
                    this.resourceStates.setElementAt(ResourceStatus.Heuristic, i2);
                    if (this.logRecord != null) {
                        this.logRecord.addObject(this.heuristicLogSection, currResource);
                    }
                } else {
                    this.resourceStates.setElementAt(ResourceStatus.Completed, i2);
                    if (isProxy) {
                        currResource._release();
                    }
                }
            }
            ++i2;
        }
        if (heuristicException) {
            this.distributeForget(this.commitRetries, infiniteRetry, heuristicMixed);
        }
    }

    private void distributeForget(int retries, boolean infinite, boolean heuristicMixed) throws HeuristicMixed, HeuristicHazard {
        UserException exc;
        boolean isProxy = false;
        if (this.logRecord != null) {
            this.logRecord.write(true);
        }
        int i2 = 0;
        while (i2 < this.resourceObjects.size()) {
            if ((ResourceStatus)this.resourceStates.elementAt(i2) == ResourceStatus.Heuristic) {
                Resource currResource = (Resource)this.resourceObjects.elementAt(i2);
                if (!(currResource instanceof OTSResourceImpl)) {
                    ProxyChecker checkProxy = Configuration.getProxyChecker();
                    isProxy = checkProxy.isProxy(currResource);
                }
                int retriesLeft = retries;
                boolean exceptionThrown = true;
                while (exceptionThrown) {
                    try {
                        currResource.forget();
                        exceptionThrown = false;
                    }
                    catch (Throwable exc2) {
                        if (exc2 instanceof INV_OBJREF || exc2 instanceof OBJECT_NOT_EXIST) {
                            exceptionThrown = false;
                            continue;
                        }
                        if (!(exc2 instanceof COMM_FAILURE) && !(exc2 instanceof TRANSIENT)) {
                            exceptionThrown = false;
                            continue;
                        }
                        if (retriesLeft > 0 || infinite) {
                            if (!infinite) {
                                --retriesLeft;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        ErrorLog.error(15, new java.lang.Object[]{new Integer(retries), "forget"}, true);
                    }
                }
                this.resourceStates.setElementAt(ResourceStatus.Completed, i2);
                if (isProxy) {
                    currResource._release();
                }
            }
            ++i2;
        }
        if (heuristicMixed) {
            exc = new HeuristicMixed();
            throw exc;
        }
        exc = new HeuristicHazard();
        throw exc;
    }

    Vote distributePrepare() throws HeuristicMixed, HeuristicHazard {
        boolean isProxy = false;
        Vote result = Vote.VoteReadOnly;
        int i2 = 0;
        while (i2 < this.resourceObjects.size() && result != Vote.VoteRollback) {
            Resource currResource = (Resource)this.resourceObjects.elementAt(i2);
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            Vote currResult = Vote.VoteRollback;
            try {
                currResult = currResource.prepare();
            }
            catch (Throwable exc) {
                boolean hazard = exc instanceof HeuristicHazard;
                if (exc instanceof HeuristicMixed || hazard) {
                    block14: {
                        this.resourceStates.setElementAt(ResourceStatus.Heuristic, i2);
                        try {
                            this.distributeRollback(true);
                        }
                        catch (Throwable ex2) {
                            if (!(ex2 instanceof HeuristicMixed) || !hazard) break block14;
                            hazard = false;
                        }
                    }
                    if (hazard) {
                        HeuristicHazard ex2 = new HeuristicHazard();
                        throw ex2;
                    }
                    HeuristicMixed ex2 = new HeuristicMixed();
                    throw ex2;
                }
                ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "prepare"}, false);
            }
            if (currResult == Vote.VoteCommit) {
                if (this.logRecord != null) {
                    this.logRecord.addObject(this.logSection, currResource);
                }
                if (result == Vote.VoteReadOnly) {
                    result = Vote.VoteCommit;
                }
            } else {
                this.resourceStates.setElementAt(ResourceStatus.Completed, i2);
                if (isProxy) {
                    currResource._release();
                }
                if (currResult == Vote.VoteRollback) {
                    result = currResult;
                }
            }
            ++i2;
        }
        return result;
    }

    void distributeRollback(boolean heuristicException) throws HeuristicMixed, HeuristicHazard {
        boolean infiniteRetry = true;
        boolean heuristicMixed = false;
        boolean isProxy = false;
        if (this.commitRetries == -1 && commitRetryVar != null) {
            try {
                this.commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable throwable) {}
            infiniteRetry = false;
        }
        int i2 = 0;
        while (i2 < this.resourceObjects.size()) {
            Resource currResource = (Resource)this.resourceObjects.elementAt(i2);
            if (this.resourceStates.elementAt(i2).equals(ResourceStatus.Registered)) {
                boolean heuristicRaised = false;
                if (!(currResource instanceof OTSResourceImpl)) {
                    ProxyChecker checkProxy = Configuration.getProxyChecker();
                    isProxy = checkProxy.isProxy(currResource);
                }
                this.resourceStates.setElementAt(ResourceStatus.Completing, i2);
                int rollbackRetriesLeft = this.commitRetries;
                boolean exceptionThrown = true;
                while (exceptionThrown) {
                    try {
                        currResource.rollback();
                        exceptionThrown = false;
                    }
                    catch (Throwable exc) {
                        if (exc instanceof TRANSACTION_ROLLEDBACK) {
                            exceptionThrown = false;
                        }
                        if (exc instanceof HeuristicRollback) {
                            heuristicException = true;
                            heuristicRaised = true;
                            exceptionThrown = false;
                            continue;
                        }
                        if (exc instanceof HeuristicCommit || exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                            heuristicException = true;
                            heuristicMixed = exc instanceof HeuristicHazard ^ true;
                            heuristicRaised = true;
                            exceptionThrown = false;
                            continue;
                        }
                        if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                            exceptionThrown = false;
                            continue;
                        }
                        if (!(exc instanceof TRANSIENT) && !(exc instanceof COMM_FAILURE)) {
                            ErrorLog.error(14, new java.lang.Object[]{exc.toString(), "rollback"}, true);
                            continue;
                        }
                        if (rollbackRetriesLeft > 0 || infiniteRetry) {
                            if (!infiniteRetry) {
                                --rollbackRetriesLeft;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        ErrorLog.error(15, new java.lang.Object[]{new Integer(this.commitRetries), "rollback"}, true);
                    }
                }
                if (heuristicRaised) {
                    this.resourceStates.setElementAt(ResourceStatus.Heuristic, i2);
                    if (this.logRecord != null) {
                        this.logRecord.addObject(this.heuristicLogSection, currResource);
                    }
                } else {
                    this.resourceStates.setElementAt(ResourceStatus.Completed, i2);
                    if (isProxy) {
                        currResource._release();
                    }
                }
            }
            ++i2;
        }
        if (heuristicException) {
            this.distributeForget(this.commitRetries, infiniteRetry, heuristicMixed);
        }
    }

    void distributeSubcommit(Coordinator parent) throws TRANSACTION_ROLLEDBACK {
        boolean exceptionRaised = false;
        boolean isProxy = false;
        int i2 = 0;
        while (i2 < this.resourceObjects.size()) {
            SubtransactionAwareResource currResource;
            block6: {
                currResource = (SubtransactionAwareResource)this.resourceObjects.elementAt(i2);
                if (!(currResource instanceof OTSResourceImpl)) {
                    ProxyChecker checkProxy = Configuration.getProxyChecker();
                    isProxy = checkProxy.isProxy(currResource);
                }
                try {
                    currResource.commit_subtransaction(parent);
                }
                catch (Throwable exc) {
                    if (!(exc instanceof TRANSACTION_ROLLEDBACK)) break block6;
                    exceptionRaised = true;
                }
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i2);
            if (isProxy) {
                currResource._release();
            }
            ++i2;
        }
        if (exceptionRaised) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
        }
    }

    void distributeSubrollback() {
        boolean isProxy = false;
        int i2 = 0;
        while (i2 < this.resourceObjects.size()) {
            SubtransactionAwareResource currResource = (SubtransactionAwareResource)this.resourceObjects.elementAt(i2);
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            try {
                currResource.rollback_subtransaction();
            }
            catch (Throwable throwable) {}
            this.resourceStates.setElementAt(ResourceStatus.Completed, i2);
            if (isProxy) {
                currResource._release();
            }
            ++i2;
        }
    }

    void empty() {
        this.resourceObjects.removeAllElements();
        this.resourceStates.removeAllElements();
    }

    public void finalize() {
        if (this.resourceObjects != null) {
            this.empty();
        }
        this.resourceObjects = null;
        this.resourceStates = null;
        this.logRecord = null;
        this.logSection = null;
        this.heuristicLogSection = null;
    }

    boolean involved() {
        boolean result = this.resourceObjects.size() != 0;
        return result;
    }

    int numRegistered() {
        int result = this.resourceObjects.size();
        return result;
    }

    void reconstruct(CoordinatorLog log) {
        this.resourceObjects = new Vector();
        this.resourceStates = new Vector();
        this.heuristicLogSection = log.createSection(HEURISTIC_LOG_SECTION_NAME);
        java.lang.Object[] resources = log.getObjects(this.heuristicLogSection);
        int i2 = 0;
        while (i2 < resources.length) {
            try {
                Resource res = ResourceHelper.narrow((Object)resources[i2]);
                if (res != null) {
                    this.resourceObjects.addElement(res);
                    this.resourceStates.addElement(ResourceStatus.Heuristic);
                }
            }
            catch (Throwable throwable) {}
            ++i2;
        }
        this.logSection = log.createSection(LOG_SECTION_NAME);
        resources = log.getObjects(this.logSection);
        int i3 = 0;
        while (i3 < resources.length) {
            try {
                Resource res = ResourceHelper.narrow((Object)resources[i3]);
                if (res != null) {
                    this.resourceObjects.addElement(res);
                    this.resourceStates.addElement(ResourceStatus.Registered);
                }
            }
            catch (Throwable throwable) {}
            ++i3;
        }
        this.logRecord = log;
    }
}

