/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jta.TransactionState;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Unavailable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransactionImpl
implements Transaction {
    private Control control;
    private GlobalTID gtid;
    private TransactionManagerImpl tm;

    public TransactionImpl(TransactionManagerImpl tm, Control control, GlobalTID gtid) throws SystemException {
        this.control = control;
        this.gtid = gtid;
        this.tm = tm;
    }

    private static void assert(boolean value) {
        if (!value) {
            Exception e10 = new Exception();
            e10.printStackTrace();
        }
    }

    public void commit() throws HeuristicMixedException, RollbackException, HeuristicRollbackException, IllegalStateException, SecurityException, SystemException {
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localTerminator().commit(true);
            } else {
                this.control.get_terminator().commit(true);
            }
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new RollbackException();
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new IllegalStateException();
        }
        catch (HeuristicMixed heuristicMixed) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard heuristicHazard) {
            throw new HeuristicMixedException();
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new SecurityException();
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    public boolean delistResource(XAResource res, int flags) throws IllegalStateException, SystemException {
        try {
            TransactionState tranState = this.tm.getTransactionState(this.gtid, this);
            if (tranState == null) {
                throw new IllegalStateException();
            }
            if (!tranState.containsXAResource(res)) {
                throw new IllegalStateException();
            }
            tranState.endAssociation(res, flags);
            if ((flags & 0x20000000) != 0) {
                this.setRollbackOnly();
            }
            return true;
        }
        catch (XAException xAException) {
            throw new SystemException();
        }
    }

    public boolean enlistResource(XAResource res) throws RollbackException, IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status != 0 && status != 1) {
            throw new IllegalStateException();
        }
        try {
            TransactionState tranState = this.tm.getOrCreateTransactionState(this.gtid, this);
            tranState.startAssociation(res, this.control, status);
            if (status == 1) {
                throw new RollbackException();
            }
            return true;
        }
        catch (XAException ex2) {
            ex2.printStackTrace();
            if (ex2.errorCode == -9) {
                throw new IllegalStateException();
            }
            throw new SystemException();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionImpl)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.gtid.equals(((TransactionImpl)object).gtid);
    }

    Control getControl() {
        return this.control;
    }

    public int getStatus() throws SystemException {
        try {
            Status status = Configuration.isLocalFactory() ? ((ControlImpl)this.control).get_localCoordinator().get_status() : this.control.get_coordinator().get_status();
            return TransactionManagerImpl.mapStatus(status);
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            return 6;
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            return 6;
        }
        catch (Unavailable unavailable) {
            return 6;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new SystemException();
        }
    }

    public int hashCode() {
        return this.gtid.hashCode();
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status == 1) {
            throw new RollbackException();
        }
        if (status != 0) {
            throw new IllegalStateException();
        }
        TransactionState transState = this.tm.getOrCreateTransactionState(this.gtid, this);
        transState.registerSynchronization(sync, this.control);
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localTerminator().rollback();
            } else {
                this.control.get_terminator().rollback();
            }
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new IllegalStateException();
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new IllegalStateException();
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status != 1 && status != 0) {
            throw new IllegalStateException();
        }
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localCoordinator().rollback_only();
            } else {
                this.control.get_coordinator().rollback_only();
            }
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Inactive inactive) {
            throw new IllegalStateException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }
}

