/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.NativeXAResource;
import com.sun.jts.jta.SynchronizationImpl;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.jtsxa.Utility;
import com.sun.jts.jtsxa.XID;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Unavailable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransactionState {
    private static final int NOT_EXIST = -1;
    private static final int ASSOCIATED = 0;
    private static final int NOT_ASSOCIATED = 1;
    private static final int ASSOCIATION_SUSPENDED = 2;
    private static final int FAILED = 3;
    private static final int ROLLING_BACK = 4;
    private Hashtable resourceStates = new Hashtable();
    private Hashtable resourceList = new Hashtable();
    private Set seenXids = new HashSet();
    private Vector factories = new Vector();
    private SynchronizationImpl syncImpl;
    private int activeResources = 0;
    private GlobalTID gtid;
    public static boolean debug = false;

    public TransactionState(GlobalTID gtid) {
        this.gtid = gtid;
    }

    private static void assert(boolean value) {
        if (!value) {
            Exception e10 = new Exception();
            e10.printStackTrace();
        }
    }

    public synchronized void beforeCompletion() throws XAException {
        Enumeration e10 = this.resourceStates.keys();
        while (e10.hasMoreElements()) {
            XAResource res = (XAResource)e10.nextElement();
            int XAState = this.getXAState(res);
            switch (XAState) {
                case 2: {
                    Xid xid = (Xid)this.resourceList.get(res);
                    res.end(xid, 0x4000000);
                    this.setXAState(res, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong XA State: " + XAState);
                }
                case 1: 
                case 3: 
            }
        }
    }

    synchronized void cleanupTransactionStateMapping() {
        if (this.activeResources == 0) {
            TransactionManagerImpl tm = TransactionManagerImpl.getTransactionManagerImpl();
            tm.cleanupTransactionState(this.gtid);
        }
    }

    private Xid computeXid(XAResource res, Control control) throws Inactive, Unavailable, XAException {
        int size = this.factories.size();
        int i2 = 0;
        while (i2 < size) {
            XAResource fac = (XAResource)this.factories.elementAt(i2);
            if (res.isSameRM(fac)) {
                Xid xid = (Xid)this.resourceList.get(fac);
                return xid;
            }
            ++i2;
        }
        XID xid = Configuration.isLocalFactory() ? Utility.getXID(((ControlImpl)control).get_localCoordinator()) : Utility.getXID(control.get_coordinator());
        this.factories.addElement(res);
        byte[] branchid = TransactionState.parseSize(size);
        byte[] sname = Configuration.getServerNameByteArray();
        byte[] branch = new byte[sname.length + 1 + branchid.length];
        System.arraycopy(sname, 0, branch, 0, sname.length);
        branch[sname.length] = 44;
        System.arraycopy(branchid, 0, branch, sname.length + 1, branchid.length);
        xid.setBranchQualifier(branch);
        return xid;
    }

    public boolean containsXAResource(XAResource res) {
        return this.resourceList.containsKey(res);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void endAssociation(XAResource xares, int flags) throws XAException, IllegalStateException {
        try {
            Xid xid = (Xid)this.resourceList.get(xares);
            TransactionState.assert(xid != null);
            int XAState = this.getXAState(xares);
            switch (XAState) {
                case 0: {
                    if ((flags & 0x4000000) != 0) {
                        xares.end(xid, 0x4000000);
                        this.setXAState(xares, 1);
                    } else if ((flags & 0x2000000) != 0) {
                        xares.end(xid, 0x2000000);
                        this.setXAState(xares, 2);
                    } else {
                        xares.end(xid, 0x20000000);
                        this.setXAState(xares, 3);
                    }
                    break;
                }
                case 4: {
                    --this.activeResources;
                    this.cleanupTransactionStateMapping();
                    xares.end(xid, 0x4000000);
                    this.setXAState(xares, 1);
                    xares.rollback(xid);
                    break;
                }
                case 2: {
                    if ((flags & 0x4000000) != 0) {
                        xares.end(xid, 0x4000000);
                        this.setXAState(xares, 1);
                    } else {
                        if ((flags & 0x2000000) != 0) {
                            throw new IllegalStateException("Wrong XAState: " + XAState);
                        }
                        xares.end(xid, 0x20000000);
                        this.setXAState(xares, 3);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong XAState: " + XAState);
                }
            }
        }
        catch (XAException ex2) {
            void xid;
            this.setXAState(xares, 3);
            throw xid;
        }
    }

    private int getXAState(XAResource res) {
        Integer result = (Integer)this.resourceStates.get(res);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public Enumeration listXAResources() {
        return this.resourceList.keys();
    }

    private static byte[] parseSize(int size) {
        int j2 = 9;
        byte[] res = new byte[10];
        if (size == 0) {
            res[j2--] = 0;
        }
        while (size > 0) {
            res[j2--] = (byte)(size % 10);
            size /= 10;
        }
        int len = 9 - j2;
        byte[] result = new byte[len];
        System.arraycopy(res, j2 + 1, result, 0, len);
        return result;
    }

    public synchronized void registerSynchronization(Synchronization sync, Control control) throws RollbackException, IllegalStateException, SystemException {
        try {
            if (this.syncImpl == null) {
                this.syncImpl = new SynchronizationImpl();
                if (Configuration.isLocalFactory()) {
                    ((ControlImpl)control).get_localCoordinator().register_synchronization(this.syncImpl);
                } else {
                    control.get_coordinator().register_synchronization(this.syncImpl);
                }
            }
            this.syncImpl.addSynchronization(sync);
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new RollbackException();
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Inactive inactive) {
            throw new IllegalStateException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    public synchronized void rollback(XAResource res) throws IllegalStateException, XAException {
        Xid xid = (Xid)this.resourceList.get(res);
        TransactionState.assert(xid != null);
        int XAState = this.getXAState(res);
        switch (XAState) {
            case 1: 
            case 3: {
                res.rollback(xid);
                break;
            }
            case 2: {
                res.end(xid, 0x4000000);
                this.setXAState(res, 1);
                res.rollback(xid);
                break;
            }
            case 0: {
                this.setXAState(res, 4);
                ++this.activeResources;
                break;
            }
            default: {
                throw new IllegalStateException("Wrong XAState: " + XAState);
            }
        }
    }

    private void setXAState(XAResource res, int state) {
        if (debug) {
            int oldValue = this.getXAState(res);
            System.err.println("*** tran: " + this.gtid);
            System.err.println("*** res: " + res + "," + oldValue + "," + state);
        }
        this.resourceStates.put(res, new Integer(state));
    }

    public synchronized void startAssociation(XAResource res, Control control, int status) throws XAException, SystemException, IllegalStateException, RollbackException {
        try {
            Xid xid = null;
            boolean newResource = false;
            if (this.resourceList.get(res) == null) {
                if (status != 0) {
                    throw new RollbackException();
                }
                newResource = true;
                xid = this.computeXid(res, control);
                if (!this.seenXids.contains(xid)) {
                    OTSResourceImpl ref = new OTSResourceImpl(xid, res, this);
                    if (Configuration.isLocalFactory()) {
                        ((ControlImpl)control).get_localCoordinator().register_resource(ref);
                    } else {
                        control.get_coordinator().register_resource(ref);
                    }
                }
                this.resourceList.put(res, xid);
            } else {
                xid = (Xid)this.resourceList.get(res);
            }
            int XAState = this.getXAState(res);
            if (!this.seenXids.contains(xid)) {
                this.seenXids.add(xid);
                res.start(xid, 0);
                this.setXAState(res, 0);
            } else {
                switch (XAState) {
                    case -1: 
                    case 1: {
                        res.start(xid, 0x200000);
                        this.setXAState(res, 0);
                        break;
                    }
                    case 2: {
                        res.start(xid, 0x8000000);
                        this.setXAState(res, 0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Wrong XAState: " + XAState);
                    }
                }
            }
            if (res instanceof NativeXAResource && newResource) {
                ((NativeXAResource)res).enlistConnectionInXA();
            }
        }
        catch (XAException ex2) {
            this.setXAState(res, 3);
            throw ex2;
        }
        catch (Inactive ex3) {
            ex3.printStackTrace();
            throw new SystemException();
        }
        catch (Unavailable ex4) {
            ex4.printStackTrace();
            throw new SystemException();
        }
    }
}

