/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.ak;
import com.sun.net.ssl.internal.ssl.g;
import com.sun.net.ssl.internal.ssl.h;
import com.sun.net.ssl.internal.ssl.i;
import com.sun.net.ssl.internal.ssl.k;
import com.sun.net.ssl.internal.ssl.m;
import com.sun.net.ssl.internal.ssl.n;
import com.sun.net.ssl.internal.ssl.o;
import com.sun.net.ssl.internal.ssl.s;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

final class ClientHandshaker
extends Handshaker {
    private PublicKey a;
    private byte[] b;
    private BigInteger c;
    private s d;
    private m e;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl) throws NoSuchAlgorithmException {
        this(sSLSocketImpl, null);
    }

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, true);
    }

    boolean a(int n2, boolean bl2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected boolean canUseCipherSuite(String string) {
        return this.isEnabled(string);
    }

    private int a(h h2, int n2, int n3, int n4, String string) {
        if (this.isEnabled(string)) {
            h2.e[n4++] = (byte)n2;
            h2.e[n4++] = (byte)n3;
        }
        return n4;
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.d = new s(bigInteger, bigInteger2);
        this.d.a(this.g.b(), 512);
    }

    protected HandshakeMessage getKickstartMessage() throws SSLException {
        h h2 = new h(this.g.b());
        int n2 = 0;
        this.h = h2.c;
        this.j = this.g.a().a(((Handshaker)this).a.e());
        if (Handshaker.m != null && Debug.isOn("session")) {
            if (this.j != null) {
                System.out.println("%% Client cached " + this.j + (this.j.e() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.j != null) {
            CipherSpec cipherSpec;
            if (!this.isEnabled(this.j.getCipherSuite())) {
                if (Handshaker.m != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.j = null;
            }
            if (this.j != null) {
                if (Handshaker.m != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.j + " from port " + ((Handshaker)this).a.getLocalPort());
                }
                h2.d = this.j.d();
                cipherSpec = this.j.a();
                ((CipherSpec)this).a = h2.a = cipherSpec.a;
                ((CipherSpec)this).b = h2.b = cipherSpec.b;
                ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
                ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
            }
            if (!this.l) {
                if (this.j == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                cipherSpec = this.j.a();
                h2.e = cipherSpec.getCipherSuite();
                return h2;
            }
        }
        if (this.j == null) {
            if (this.l) {
                h2.d = SSLSessionImpl.a.d();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        h2.e = new byte[2 * this.ak.length];
        n2 = this.a(h2, 0, 3, n2, "SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        n2 = this.a(h2, 0, 17, n2, "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        n2 = this.a(h2, 0, 2, n2, "SSL_RSA_WITH_NULL_SHA");
        n2 = this.a(h2, 0, 1, n2, "SSL_RSA_WITH_NULL_MD5");
        n2 = this.a(h2, 0, 23, n2, "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
        n2 = this.a(h2, 0, 25, n2, "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        return h2;
    }

    void a(byte by2) throws SSLProtocolException {
        String string = SSLSocketImpl.b(by2);
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    protected void processMessage(byte by2, int n2) throws IOException, NoSuchAlgorithmException {
        if (this.f > by2 && by2 != 0 && this.f != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by2);
        }
        block2 : switch (by2) {
            case 0: {
                this.a(new g(((Handshaker)this).d));
                break;
            }
            case 2: {
                this.a(new i(((Handshaker)this).d));
                break;
            }
            case 11: {
                if (this.o == 7) {
                    ((Handshaker)this).a.a((byte)10, "unexpected server cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((Handshaker)this).d));
                this.a = this.j.getPeerCertificateChain()[0].getPublicKey();
                break;
            }
            case 12: {
                switch (this.o) {
                    case 1: 
                    case 2: {
                        try {
                            this.a(new k(((Handshaker)this).d, n2));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                    case 7: {
                        this.a(new HandshakeMessage.DH_ServerKeyExchange(((Handshaker)this).d));
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        try {
                            this.a(new HandshakeMessage.DH_ServerKeyExchange(((Handshaker)this).d, this.a, this.h.a, this.i.a, n2));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
            }
            case 13: {
                this.e = new m(((Handshaker)this).d);
                break;
            }
            case 14: {
                this.a(new n(((Handshaker)this).d));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).d));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by2);
            }
        }
        if (this.f < by2) {
            this.f = by2;
        }
    }

    private void e() throws IOException {
        HandshakeMessage.Finished finished;
        try {
            if (((Handshaker)this).b[0] == null) {
                throw new CloneNotSupportedException("minor hack");
            }
            finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.c, this.j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "client finished", this.j.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[1], ((Handshaker)this).c[1], HandshakeMessage.Finished.c, this.j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[1], ((Handshaker)this).c[1], "client finished", this.j.c());
            ((Handshaker)this).b[1] = null;
            ((Handshaker)this).c[1] = null;
        }
        this.sendChangeCipherSpec(finished);
        this.f = 19;
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509TrustManager x509TrustManager;
        X509Certificate[] x509CertificateArray;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            ((Handshaker)this).a.a((byte)42, "null cert chain");
        }
        if ((x509TrustManager = this.g.e()).isServerTrusted(x509CertificateArray)) {
            this.j.a(x509CertificateArray);
        } else {
            ((Handshaker)this).a.a((byte)46, "untrusted server cert chain");
        }
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        boolean bl2 = false;
        try {
            bl2 = ((CipherSpec)this).b == 0 ? finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.d, this.j.c()) : finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "server finished", this.j.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl2 = ((CipherSpec)this).b == 0 ? finished.verify(((Handshaker)this).b[0], ((Handshaker)this).c[0], HandshakeMessage.Finished.d, this.j.c()) : finished.verify(((Handshaker)this).b[0], ((Handshaker)this).c[0], "server finished", this.j.c());
            ((Handshaker)this).b[0] = null;
            ((Handshaker)this).c[0] = null;
        }
        if (!bl2) {
            ((Handshaker)this).a.a((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.k) {
            ((Handshaker)this).d.digestNow();
            this.e();
        }
        if (((Handshaker)this).a.c() && this.j.e()) {
            this.g.a().a(this.j);
            if (Handshaker.m != null && Debug.isOn("session")) {
                System.out.println("%% Cached client session: " + this.j);
            }
        } else if (Handshaker.m != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable client session: " + this.j);
        }
    }

    private void a(i i2) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            i2.a(System.out);
        }
        if (i2.a != 3 || i2.b > 1) {
            throw new SSLProtocolException("version mismatch, server is v" + i2.a + "." + i2.b);
        }
        ((CipherSpec)this).a = i2.a;
        ((CipherSpec)this).b = i2.b;
        ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        this.i = i2.c;
        if (this.j != null) {
            if (this.j.d().equals(i2.d)) {
                CipherSpec cipherSpec = this.j.a();
                byte[] byArray = cipherSpec.getCipherSuite();
                if (i2.e[0] != byArray[0] || i2.e[1] != byArray[1] || i2.a != cipherSpec.a || i2.b != cipherSpec.b) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                this.k = true;
                this.f = 19;
                if (Handshaker.m != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.j);
                }
            } else {
                this.j = null;
                if (!this.l) {
                    throw new SSLException("New session creation was disabled");
                }
            }
        }
        if (!this.a(i2.e[0], i2.e[1])) {
            ((Handshaker)this).a.a((byte)47, "Can't support cipher suite [" + i2.e[0] + ", " + i2.e[1] + "]");
        } else if (i2.f != 0) {
            ((Handshaker)this).a.a((byte)47, "compression type not supported, " + i2.f);
        }
        if (this.j == null) {
            this.j = new SSLSessionImpl((CipherSpec)this, i2.d, ((Handshaker)this).a.e(), ((Handshaker)this).a.getPort());
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                System.out.println("** " + this.j.a());
            }
        } else {
            try {
                this.a(this.j.c());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
    }

    private void a(n n2) throws IOException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            n2.a(System.out);
        }
        ((Handshaker)this).d.digestNow();
        PrivateKey privateKey = null;
        if (this.e != null) {
            object3 = this.g.d();
            object2 = null;
            HandshakeMessage.CertificateMsg certificateMsg = null;
            int n3 = 0;
            while (n3 < this.e.g.length) {
                object = null;
                if (this.e.g[n3] == 1) {
                    object = "RSA";
                } else if (this.e.g[n3] == 2) {
                    object = "DSA";
                }
                object2 = object3.chooseClientAlias((String)object, this.e.a());
                if (object2 != null) break;
                ++n3;
            }
            if (object2 != null) {
                certificateMsg = new HandshakeMessage.CertificateMsg(object3.getCertificateChain((String)object2));
                privateKey = object3.getPrivateKey((String)object2);
                this.j.a(true);
            } else if (((CipherSpec)this).b > 0) {
                certificateMsg = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
            } else {
                ((Handshaker)this).a.a((byte)41);
            }
            if (certificateMsg != null) {
                if (Handshaker.m != null && Debug.isOn("handshake")) {
                    certificateMsg.a(System.out);
                }
                certificateMsg.write(((Handshaker)this).e);
            }
        }
        switch (this.o) {
            case 1: 
            case 2: {
                object2 = new ak(((CipherSpec)this).a, ((CipherSpec)this).b, this.g.b(), this.a);
                this.b = ((ak)object2).c;
                object3 = object2;
                break;
            }
            case 3: 
            case 4: {
                object3 = new ClientDiffieHellmanPublic();
                break;
            }
            case 6: 
            case 7: {
                object3 = new ClientDiffieHellmanPublic(this.d.d());
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
            }
        }
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            ((HandshakeMessage)object3).a(System.out);
        }
        ((HandshakeMessage)object3).write(((Handshaker)this).e);
        ((Handshaker)this).e.a();
        ((Handshaker)this).e.flush();
        switch (this.o) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.b = this.d.a(this.c);
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
            }
            case 1: 
            case 2: 
        }
        this.b(this.b);
        int n4 = 0;
        while (n4 < this.b.length) {
            this.b[n4] = 0;
            ++n4;
        }
        if (privateKey != null) {
            MessageDigest messageDigest;
            HandshakeMessage handshakeMessage = null;
            try {
                object = (MessageDigest)((Handshaker)this).b[0].clone();
                messageDigest = (MessageDigest)((Handshaker)this).c[0].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                object = ((Handshaker)this).b[2];
                messageDigest = ((Handshaker)this).c[2];
                ((Handshaker)this).b[2] = null;
                ((Handshaker)this).c[2] = null;
            }
            try {
                handshakeMessage = privateKey instanceof RSAPrivateKey ? new o(((CipherSpec)this).b, (RSAPrivateKey)privateKey, (MessageDigest)object, messageDigest, this.j.c()) : new o(((CipherSpec)this).b, privateKey, messageDigest, this.j.c());
            }
            catch (InvalidKeyException invalidKeyException) {
                ((Handshaker)this).a.a((byte)40, "Invalid private key");
            }
            catch (SignatureException signatureException) {
                ((Handshaker)this).a.a((byte)40, "DSS/DSA signature failure");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ((Handshaker)this).a.a((byte)40, "No DSS/DSA implementation");
            }
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((o)handshakeMessage).a(System.out);
            }
            handshakeMessage.write(((Handshaker)this).e);
            ((Handshaker)this).e.a();
        }
        this.e();
    }

    private void a(g g2) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            g2.a(System.out);
        }
        if (this.f < 1) {
            this.kickstart();
        }
    }

    private void a(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.a(System.out);
        }
        if (this.o == 4 || this.o == 3) {
            ((Handshaker)this).a.a((byte)10, "not supporting DH certs for key exchange now");
        }
        this.a(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase());
        this.c = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void a(k k2) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            k2.a(System.out);
        }
        if (!(this.a instanceof RSAPublicKey)) {
            throw new InvalidKeyException("server key not an RSA key");
        }
        if (!k2.a((RSAPublicKey)this.a, this.h, this.i)) {
            ((Handshaker)this).a.a((byte)40, "server key exchange invalid");
        }
        this.a = k2.a();
    }
}

