/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;

public final class Options {
    public boolean keepGenerated = true;
    public boolean largeFile = false;
    public boolean sendErrorToClient = false;
    public int jspVerbosityLevel = 2;
    public File scratchDir;
    public String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    public String classpath = null;

    public Options(ServletConfig config, ServletContext context) {
        String dir;
        String verbosityLevel;
        String classpath;
        String ieClassId;
        String senderr;
        String largeFile;
        String keepgen = config.getInitParameter("keepgenerated");
        if (keepgen != null) {
            if (keepgen.equalsIgnoreCase("true")) {
                this.keepGenerated = true;
            } else if (keepgen.equalsIgnoreCase("false")) {
                this.keepGenerated = false;
            } else {
                Constants.message("jsp.warning.keepgen", Integer.MIN_VALUE);
            }
        }
        if ((largeFile = config.getInitParameter("largefile")) != null) {
            if (largeFile.equalsIgnoreCase("true")) {
                this.largeFile = true;
            } else if (largeFile.equalsIgnoreCase("false")) {
                this.largeFile = false;
            } else {
                Constants.message("jsp.warning.largeFile", Integer.MIN_VALUE);
            }
        }
        if ((senderr = config.getInitParameter("sendErrToClient")) != null) {
            if (senderr.equalsIgnoreCase("true")) {
                this.sendErrorToClient = true;
            } else if (senderr.equalsIgnoreCase("false")) {
                this.sendErrorToClient = false;
            } else {
                Constants.message("jsp.warning.sendErrToClient", Integer.MIN_VALUE);
            }
        }
        if ((ieClassId = config.getInitParameter("ieClassId")) != null) {
            this.ieClassId = ieClassId;
        }
        if ((classpath = config.getInitParameter("classpath")) != null) {
            this.classpath = classpath;
        }
        if ((verbosityLevel = config.getInitParameter("jspVerbosityLevel")) != null) {
            try {
                int vl;
                Constants.jspVerbosityLevel = this.jspVerbosityLevel = (vl = Integer.parseInt(verbosityLevel));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((dir = config.getInitParameter("scratchdir")) != null) {
            this.scratchDir = new File(dir);
        } else {
            this.scratchDir = (File)context.getAttribute("javax.servlet.context.tempdir");
            if (this.scratchDir == null) {
                dir = System.getProperty("java.io.tmpdir");
                this.scratchDir = new File(dir);
            }
        }
        if (this.scratchDir == null) {
            Constants.message("jsp.error.no.scratch.dir", Integer.MIN_VALUE);
            return;
        }
        if (!(this.scratchDir.exists() && this.scratchDir.canRead() && this.scratchDir.canWrite() && this.scratchDir.isDirectory())) {
            Constants.message("jsp.error.bad.scratch.dir", new Object[]{this.scratchDir.getAbsolutePath()}, Integer.MIN_VALUE);
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    public String ieClassId() {
        return this.ieClassId;
    }

    public int jspVerbosityLevel() {
        return this.jspVerbosityLevel;
    }

    public boolean keepGenerated() {
        return this.keepGenerated;
    }

    public boolean largeFile() {
        return this.largeFile;
    }

    public File scratchDir() {
        return this.scratchDir;
    }

    public boolean sendErrorToClient() {
        return this.sendErrorToClient;
    }
}

