/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.BufferedServletOutputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.LocaleToCharsetMap;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestUtil;
import org.apache.tomcat.core.ResponseAdapter;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.util.CookieTools;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.StringManager;

public class Response {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected Request request;
    protected HttpServletResponseFacade responseFacade;
    protected Vector userCookies = new Vector();
    protected Vector systemCookies = new Vector();
    protected String contentType = "text/plain";
    protected String contentLanguage = null;
    protected String characterEncoding = System.getProperty("file.encoding", "8859_1");
    protected int contentLength = -1;
    protected int status = 200;
    private Locale locale = new Locale("en", "");
    protected MimeHeaders headers = new MimeHeaders();
    protected BufferedServletOutputStream out;
    protected PrintWriter writer;
    protected boolean usingStream = false;
    protected boolean usingWriter = false;
    protected boolean started = false;
    protected boolean committed = false;
    protected boolean omitHeaders = false;
    protected String serverHeader = null;
    protected ResponseAdapter resA;

    public Response() {
        this.responseFacade = new HttpServletResponseFacade(this);
        this.out = new BufferedServletOutputStream();
        this.out.setResponse(this);
    }

    public void addCookie(Cookie cookie) {
        this.userCookies.addElement(cookie);
    }

    public void addDateHeader(String name, long date) {
        this.headers.addDateHeader(name, date);
    }

    public void addHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.addIntHeader(name, value);
    }

    public void addSystemCookie(Cookie cookie) {
        this.systemCookies.addElement(cookie);
    }

    private void close() throws IOException {
        try {
            PrintWriter out = this.getWriter();
            out.close();
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream out = this.getOutputStream();
            out.close();
        }
    }

    String constructLocalizedContentType(String type, Locale loc) {
        String charset;
        int semi = type.indexOf(";");
        if (semi != -1) {
            type = type.substring(0, semi);
        }
        if ((charset = LocaleToCharsetMap.getCharset(loc)) != null) {
            type = String.valueOf(type) + "; charset=" + charset;
        }
        return type;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public void endResponse() throws IOException {
        this.resA.endResponse();
    }

    public void finish() throws IOException {
        try {
            if (this.usingWriter && this.writer != null) {
                this.writer.flush();
            }
            this.out.reallyFlush();
        }
        catch (SocketException socketException) {
            return;
        }
    }

    protected void fixHeaders() throws IOException {
        Cookie c02;
        Cookie c10;
        HttpDate date = new HttpDate(System.currentTimeMillis());
        this.headers.putHeader("Date", date.toString());
        this.headers.putIntHeader("Status", this.status);
        this.headers.putHeader("Content-Type", this.contentType);
        if (this.getServerHeader() != null) {
            this.headers.putHeader("Server", this.getServerHeader());
        }
        if (this.contentLanguage != null) {
            this.headers.putHeader("Content-Language", this.contentLanguage);
        }
        if (this.request.getContext() != null) {
            this.headers.putHeader("Servlet-Engine", this.request.getContext().getEngineHeader());
        }
        if (this.contentLength != -1) {
            this.headers.putIntHeader("Content-Length", this.contentLength);
        }
        Enumeration cookieEnum = null;
        cookieEnum = this.systemCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            this.headers.addHeader(CookieTools.getCookieHeaderName(c10), CookieTools.getCookieHeaderValue(c10));
            if (c10.getVersion() != 1) continue;
            c02 = (Cookie)c10.clone();
            c02.setVersion(0);
            this.headers.addHeader(CookieTools.getCookieHeaderName(c02), CookieTools.getCookieHeaderValue(c02));
        }
        cookieEnum = this.userCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            this.headers.addHeader(CookieTools.getCookieHeaderName(c10), CookieTools.getCookieHeaderValue(c10));
            if (c10.getVersion() != 1) continue;
            c02 = (Cookie)c10.clone();
            c02.setVersion(0);
            this.headers.addHeader(CookieTools.getCookieHeaderName(c02), CookieTools.getCookieHeaderValue(c02));
        }
    }

    public void flushBuffer() throws IOException {
        if (this.usingWriter) {
            this.writer.flush();
        }
        this.out.reallyFlush();
    }

    public int getBufferSize() {
        return this.out.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public HttpServletResponseFacade getFacade() {
        return this.responseFacade;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() {
        this.started = true;
        if (this.usingWriter) {
            String msg = this.sm.getString("serverResponse.outputStream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        return this.out;
    }

    public ResponseAdapter getResponseAdapter() {
        return this.resA;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public int getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() throws IOException {
        this.started = true;
        if (this.usingStream) {
            String msg = this.sm.getString("serverResponse.writer.ise");
            throw new IllegalStateException(msg);
        }
        this.usingWriter = true;
        if (this.writer == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null || "Default".equals(encoding)) {
                this.writer = new PrintWriter(new OutputStreamWriter(this.out));
            } else {
                try {
                    this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.out, encoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.writer = new PrintWriter(new OutputStreamWriter(this.out));
                    System.out.println("Unsuported encoding: " + encoding);
                }
            }
        }
        this.out.setUsingWriter(this.usingWriter);
        return this.writer;
    }

    public boolean isBufferCommitted() {
        return this.out.isCommitted();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isStarted() {
        return this.started;
    }

    private String makeAbsolute(String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            String requrl = HttpUtils.getRequestURL(this.request.getFacade()).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException malformedURLException2) {
                return location;
            }
        }
        return url.toString();
    }

    public void recycle() {
        this.userCookies.removeAllElements();
        this.systemCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = new Locale("en", "");
        this.characterEncoding = System.getProperty("file.encoding", "8859_1");
        this.contentLength = -1;
        this.status = 200;
        this.headers.clear();
        this.usingWriter = false;
        this.usingStream = false;
        this.writer = null;
        this.out.recycle();
        this.started = false;
        this.committed = false;
        this.omitHeaders = false;
    }

    public void reset() throws IllegalStateException {
        this.userCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = new Locale("en", "");
        this.characterEncoding = System.getProperty("file.encoding", "8859_1");
        this.contentLength = -1;
        this.status = 200;
        if (this.usingWriter) {
            this.writer.flush();
        }
        this.out.reset();
        this.headers.clear();
    }

    public void sendBodyText(String s2) throws IOException {
        try {
            PrintWriter out = this.getWriter();
            out.print(s2);
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream out = this.getOutputStream();
            out.print(s2);
        }
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "No detailed message");
    }

    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        Context context = this.request.getContext();
        if (context == null) {
            this.sendPrivateError(sc, msg);
            return;
        }
        ServletContextFacade contextFacade = context.getFacade();
        String path = context.getErrorPage(String.valueOf(sc));
        if (path != null) {
            RequestDispatcher rd = contextFacade.getRequestDispatcher(path);
            this.request.setAttribute("javax.servlet.error.status_code", String.valueOf(sc));
            this.request.setAttribute("javax.servlet.error.message", msg);
            try {
                this.reset();
                rd.forward(this.request.getFacade(), this.getFacade());
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    rd.include(this.request.getFacade(), this.getFacade());
                }
                catch (ServletException servletException) {
                    this.sendPrivateError(sc, msg);
                }
            }
            catch (ServletException servletException) {
                this.sendPrivateError(sc, msg);
            }
        } else {
            this.sendPrivateError(sc, msg);
        }
        this.close();
    }

    private void sendPrivateError(int sc, String msg) throws IOException {
        this.setContentType("text/html");
        StringBuffer buf = new StringBuffer();
        buf.append("<h1>Error: " + sc + "</h1>\r\n");
        buf.append(String.valueOf(msg) + "\r\n");
        this.sendBodyText(buf.toString());
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setContentType("text/html");
        location = this.makeAbsolute(location);
        this.setHeader("Location", location);
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>Document moved</title></head>\r\n");
        buf.append("<body><h1>Document moved</h1>\r\n");
        buf.append("This document has moved <a href=\"");
        buf.append(location);
        buf.append("\">here</a>.<p>\r\n");
        buf.append("</body>\r\n");
        String body = buf.toString();
        this.setContentLength(body.length());
        this.sendBodyText(body);
        this.close();
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (this.usingWriter) {
            this.writer.flush();
        }
        if (this.out.isContentWritten()) {
            String msg = this.sm.getString("servletOutputStreamImpl.setbuffer.ise");
            throw new IllegalStateException(msg);
        }
        this.out.setBufferSize(size);
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
        this.addHeader("Content-Length", new Integer(contentLength).toString());
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        String encoding = RequestUtil.getCharsetFromContentType(contentType);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
        this.addHeader("Content-Type", contentType);
    }

    public void setDateHeader(String name, long date) {
        this.headers.putDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.headers.putHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.putIntHeader(name, value);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        String newType = this.constructLocalizedContentType(this.contentType, locale);
        this.setContentType(newType);
        this.addHeader("Content-Language", this.contentLanguage);
    }

    public void setOmitHeaders(boolean omitHeaders) {
        this.omitHeaders = omitHeaders;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponseAdapter(ResponseAdapter resA) {
        this.resA = resA;
        this.out.setResponseAdapter(resA);
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void writeHeaders() throws IOException {
        if (this.omitHeaders) {
            return;
        }
        this.resA.setStatus(this.status, RequestUtil.getStatusString(this.status));
        this.fixHeaders();
        this.resA.addMimeHeaders(this.headers);
    }
}

