/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security.file;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.security.RealmConnector;
import org.apache.tomcat.security.file.FileRealmDatabase;
import org.apache.tomcat.security.file.FileRealmGroup;
import org.apache.tomcat.security.file.FileRealmUser;
import org.apache.tomcat.util.StringManager;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class FileRealmConnector
implements RealmConnector {
    private Context context = null;
    private FileRealmDatabase database = null;
    private StringManager sm = StringManager.getManager("org.apache.tomcat.security.file");

    public Principal authenticate(String username, String credentials) {
        if (this.context == null) {
            throw new IllegalStateException(this.sm.getString("file.authenticate.notstarted"));
        }
        FileRealmUser user = this.database.getUser(username);
        if (user == null) {
            return null;
        }
        if (user.authenticate(credentials)) {
            return user;
        }
        return null;
    }

    public Principal authenticate(String username, byte[] credentials) {
        StringBuffer password = new StringBuffer();
        int i2 = 0;
        while (i2 < credentials.length) {
            password.append((char)credentials[i2]);
            ++i2;
        }
        return this.authenticate(username, password.toString());
    }

    public boolean hasRole(Principal principal, String role) {
        if (this.context == null) {
            throw new IllegalStateException(this.sm.getString("file.hasRole.notstarted"));
        }
        FileRealmUser user = this.database.getUser(principal.getName());
        if (user == null) {
            return false;
        }
        if (user.hasRole(role)) {
            return true;
        }
        Enumeration groups = user.getGroups();
        while (groups.hasMoreElements()) {
            FileRealmGroup group = (FileRealmGroup)groups.nextElement();
            if (!group.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void start(Context context) {
        String filename = context.getInitParameter("org.apache.tomcat.security.file.database");
        if (filename == null) {
            throw new IllegalArgumentException(this.sm.getString("file.start.missing", "org.apache.tomcat.security.file.database"));
        }
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(this.sm.getString("file.start.open", filename));
        }
        try {
            try {
                this.database = new FileRealmDatabase(stream);
            }
            catch (IOException e10) {
                throw new IllegalArgumentException(String.valueOf(this.sm.getString("file.start.read", filename)) + ": " + e10);
            }
            catch (SAXParseException e11) {
                throw new IllegalArgumentException(String.valueOf(this.sm.getString("file.start.parse", filename)) + ": " + e11);
            }
            catch (SAXException e12) {
                throw new IllegalArgumentException(String.valueOf(this.sm.getString("file.start.process", filename)) + ": " + e12);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        this.context = context;
    }

    public void stop() {
        this.context = null;
        this.database = null;
    }
}

