/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import javax.rmi.CORBA.Util;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.iiop.AbstractType;
import sun.rmi.rmic.iiop.ArrayType;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.DirectoryLoader;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.NCClassType;
import sun.rmi.rmic.iiop.NCInterfaceType;
import sun.rmi.rmic.iiop.PrimitiveType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.SpecialClassType;
import sun.rmi.rmic.iiop.SpecialInterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Node;

public abstract class CompoundType
extends Type {
    protected Method[] methods;
    protected InterfaceType[] interfaces;
    protected Member[] members;
    protected ClassDefinition classDef;
    protected ClassDeclaration classDecl;
    protected boolean isCORBAObject = false;
    protected boolean isIDLEntity = false;
    protected boolean isAbstractBase = false;
    protected boolean isValueBase = false;
    protected boolean isCORBAUserException = false;
    protected boolean isException = false;
    protected boolean isCheckedException = false;
    protected boolean isRemoteExceptionOrSubclass = false;
    protected String idlExceptionName;
    protected String qualifiedIDLExceptionName;

    protected CompoundType(ContextStack contextStack, int n2, ClassDefinition classDefinition) {
        super(contextStack, n2);
        this.classDef = classDefinition;
        this.classDecl = classDefinition.getClassDeclaration();
        this.interfaces = new InterfaceType[0];
        this.methods = new Method[0];
        this.members = new Member[0];
        if (classDefinition.isInnerClass()) {
            this.setTypeCode(n2 | Integer.MIN_VALUE);
        }
        this.setFlags();
    }

    protected CompoundType(ContextStack contextStack, ClassDefinition classDefinition, int n2) {
        super(contextStack, n2);
        this.classDef = classDefinition;
        this.classDecl = classDefinition.getClassDeclaration();
        if (classDefinition.isInnerClass()) {
            this.setTypeCode(n2 | Integer.MIN_VALUE);
        }
        this.setFlags();
        Identifier identifier = classDefinition.getName();
        try {
            String string = IDLNames.getClassOrInterfaceName(identifier, this.env);
            String[] stringArray = IDLNames.getModuleNames(identifier, this.isBoxed(), this.env);
            this.setNames(identifier, stringArray, string);
            if (this.isException()) {
                this.isException = true;
                this.idlExceptionName = IDLNames.getExceptionName(this.getIDLName());
                this.qualifiedIDLExceptionName = IDLNames.getQualifiedName(this.getIDLModuleNames(), this.idlExceptionName);
            }
            this.interfaces = null;
            this.methods = null;
            this.members = null;
        }
        catch (Exception exception) {
            Type.failedConstraint(7, false, contextStack, identifier.toString(), exception.getMessage());
            throw new CompilerError("");
        }
    }

    protected boolean addAllMembers(Vector vector, boolean bl2, boolean bl3, ContextStack contextStack) {
        boolean bl4 = true;
        MemberDefinition memberDefinition = this.getClassDefinition().getFirstMember();
        while (memberDefinition != null && bl4) {
            if (!memberDefinition.isMethod()) {
                try {
                    String string = null;
                    memberDefinition.getValue((Environment)this.env);
                    Node node = memberDefinition.getValue();
                    if (node != null) {
                        string = node.toString();
                    }
                    if (bl2 && memberDefinition.getInnerClass() == null && (string == null || !this.isConformingConstantType(memberDefinition))) {
                        Type.failedConstraint(3, bl3, contextStack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                        bl4 = false;
                        break;
                    }
                    try {
                        Member member = new Member(memberDefinition, string, contextStack, this);
                        vector.addElement(member);
                    }
                    catch (CompilerError compilerError) {
                        bl4 = false;
                    }
                }
                catch (ClassNotFound classNotFound) {
                    Type.classNotFound(contextStack, classNotFound);
                    bl4 = false;
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        return bl4;
    }

    protected Vector addAllMethods(ClassDefinition classDefinition, Vector vector, boolean bl2, boolean bl3, ContextStack contextStack) throws ClassNotFound {
        Object object;
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            object = this.addAllMethods(classDeclarationArray[n2].getClassDefinition((Environment)this.env), vector, bl2, bl3, contextStack);
            if (object == null) {
                return null;
            }
            ++n2;
        }
        object = classDefinition.getFirstMember();
        while (object != null) {
            if (object.isMethod() && !object.isInitializer() && !object.isPrivate()) {
                Method method;
                try {
                    method = new Method(this, (MemberDefinition)object, bl3, contextStack);
                }
                catch (Exception exception) {
                    return null;
                }
                if (!vector.contains(method)) {
                    vector.addElement(method);
                } else if (bl2 && classDefinition != this.classDef && !contextStack.isParentAValue() && !contextStack.getContext().isValue()) {
                    Method method2 = (Method)vector.elementAt(vector.indexOf(method));
                    Identifier identifier = method2.getEnclosing().getIdentifier();
                    Identifier identifier2 = classDefinition.getName();
                    String string = String.valueOf(identifier.toString()) + " and " + identifier2.toString();
                    Type.failedConstraint(6, bl3, contextStack, this.classDef, string, method);
                    return null;
                }
            }
            object = object.getNextMember();
        }
        return vector;
    }

    protected boolean addConformingConstants(Vector vector, boolean bl2, ContextStack contextStack) {
        boolean bl3 = true;
        MemberDefinition memberDefinition = this.getClassDefinition().getFirstMember();
        while (memberDefinition != null && bl3) {
            if (!memberDefinition.isMethod()) {
                try {
                    String string = null;
                    memberDefinition.getValue((Environment)this.env);
                    Node node = memberDefinition.getValue();
                    if (node != null) {
                        string = node.toString();
                    }
                    if (string != null) {
                        if (!this.isConformingConstantType(memberDefinition)) {
                            Type.failedConstraint(3, bl2, contextStack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                            bl3 = false;
                            break;
                        }
                        try {
                            Member member = new Member(memberDefinition, string, contextStack, this);
                            vector.addElement(member);
                        }
                        catch (CompilerError compilerError) {
                            bl3 = false;
                        }
                    }
                }
                catch (ClassNotFound classNotFound) {
                    Type.classNotFound(contextStack, classNotFound);
                    bl3 = false;
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        return bl3;
    }

    protected Vector addNonRemoteInterfaces(Vector vector, ContextStack contextStack) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        contextStack.setNewContextCode(10);
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            ClassDefinition classDefinition2 = classDeclarationArray[n2].getClassDefinition((Environment)this.env);
            InterfaceType interfaceType = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
            if (interfaceType == null && (interfaceType = AbstractType.forAbstract(classDefinition2, contextStack, true)) == null) {
                interfaceType = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
            }
            if (interfaceType == null) {
                return null;
            }
            vector.addElement(interfaceType);
            ++n2;
        }
        return vector;
    }

    protected Vector addRemoteInterfaces(Vector vector, boolean bl2, ContextStack contextStack) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        contextStack.setNewContextCode(10);
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            ClassDefinition classDefinition2 = classDeclarationArray[n2].getClassDefinition((Environment)this.env);
            InterfaceType interfaceType = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
            if (interfaceType == null) {
                if (this.env.defRemote.implementedBy((Environment)this.env, classDeclarationArray[n2])) {
                    interfaceType = RemoteType.forRemote(classDefinition2, contextStack, false);
                } else {
                    interfaceType = AbstractType.forAbstract(classDefinition2, contextStack, true);
                    if (interfaceType == null && bl2) {
                        interfaceType = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                    }
                }
            }
            if (interfaceType == null) {
                return null;
            }
            vector.addElement(interfaceType);
            ++n2;
        }
        return vector;
    }

    protected boolean addTypes(int n2, HashSet hashSet, Vector vector) {
        boolean bl2 = super.addTypes(n2, hashSet, vector);
        if (bl2) {
            ClassType classType = this.getSuperclass();
            if (classType != null) {
                classType.addTypes(n2, hashSet, vector);
            }
            int n3 = 0;
            while (n3 < this.interfaces.length) {
                this.interfaces[n3].addTypes(n2, hashSet, vector);
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.methods.length) {
                ValueType[] valueTypeArray;
                this.methods[n4].getReturnType().addTypes(n2, hashSet, vector);
                Type[] typeArray = this.methods[n4].getArguments();
                int n5 = 0;
                while (n5 < typeArray.length) {
                    valueTypeArray = typeArray[n5];
                    valueTypeArray.addTypes(n2, hashSet, vector);
                    ++n5;
                }
                valueTypeArray = this.methods[n4].getExceptions();
                int n6 = 0;
                while (n6 < valueTypeArray.length) {
                    ValueType valueType = valueTypeArray[n6];
                    valueType.addTypes(n2, hashSet, vector);
                    ++n6;
                }
                ++n4;
            }
            int n7 = 0;
            while (n7 < this.members.length) {
                Type type = this.members[n7].getType();
                type.addTypes(n2, hashSet, vector);
                ++n7;
            }
        }
        return bl2;
    }

    protected boolean assertNotImpl(Type type, boolean bl2, ContextStack contextStack, CompoundType compoundType, boolean bl3) {
        if (type.isType(65536)) {
            int n2 = bl3 ? 28 : 21;
            Type.failedConstraint(n2, bl2, contextStack, type, compoundType.getName());
            return false;
        }
        return true;
    }

    protected void destroy() {
        if (!this.destroyed) {
            int n2;
            super.destroy();
            if (this.methods != null) {
                n2 = 0;
                while (n2 < this.methods.length) {
                    if (this.methods[n2] != null) {
                        this.methods[n2].destroy();
                    }
                    ++n2;
                }
                this.methods = null;
            }
            if (this.interfaces != null) {
                n2 = 0;
                while (n2 < this.interfaces.length) {
                    if (this.interfaces[n2] != null) {
                        this.interfaces[n2].destroy();
                    }
                    ++n2;
                }
                this.interfaces = null;
            }
            if (this.members != null) {
                n2 = 0;
                while (n2 < this.members.length) {
                    if (this.members[n2] != null) {
                        this.members[n2].destroy();
                    }
                    ++n2;
                }
                this.members = null;
            }
            this.classDef = null;
            this.classDecl = null;
        }
    }

    public static CompoundType forCompound(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        try {
            compoundType = (CompoundType)CompoundType.makeType(classDefinition.getType(), classDefinition, contextStack);
        }
        catch (ClassCastException classCastException) {}
        return compoundType;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDecl;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDef;
    }

    public String getIDLExceptionName() {
        return this.idlExceptionName;
    }

    public InterfaceType[] getInterfaces() {
        return (InterfaceType[])this.interfaces.clone();
    }

    public Member[] getMembers() {
        return (Member[])this.members.clone();
    }

    protected ValueType[] getMethodExceptions(MemberDefinition memberDefinition, boolean bl2, ContextStack contextStack) throws Exception {
        boolean bl3 = true;
        contextStack.setNewContextCode(5);
        ClassDeclaration[] classDeclarationArray = memberDefinition.getExceptions((Environment)this.env);
        ValueType[] valueTypeArray = new ValueType[classDeclarationArray.length];
        try {
            int n2 = 0;
            while (n2 < classDeclarationArray.length) {
                ClassDefinition classDefinition = classDeclarationArray[n2].getClassDefinition((Environment)this.env);
                try {
                    ValueType valueType = ValueType.forValue(classDefinition, contextStack, false);
                    if (valueType != null) {
                        valueTypeArray[n2] = valueType;
                    } else {
                        bl3 = false;
                    }
                }
                catch (ClassCastException classCastException) {
                    Type.failedConstraint(22, bl2, contextStack, this.getQualifiedName());
                    throw new CompilerError("Method: exception " + classDefinition.getName() + " not a class type!");
                }
                catch (NullPointerException nullPointerException) {
                    Type.failedConstraint(23, bl2, contextStack, this.getQualifiedName());
                    throw new CompilerError("Method: caught null pointer exception");
                }
                ++n2;
            }
        }
        catch (ClassNotFound classNotFound) {
            Type.classNotFound(bl2, contextStack, classNotFound);
            bl3 = false;
        }
        if (!bl3) {
            throw new Exception();
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < valueTypeArray.length) {
            int n5 = 0;
            while (n5 < valueTypeArray.length) {
                if (n4 != n5 && valueTypeArray[n4] != null && valueTypeArray[n4] == valueTypeArray[n5]) {
                    valueTypeArray[n5] = null;
                    ++n3;
                }
                ++n5;
            }
            ++n4;
        }
        if (n3 > 0) {
            int n6 = 0;
            ValueType[] valueTypeArray2 = new ValueType[valueTypeArray.length - n3];
            int n7 = 0;
            while (n7 < valueTypeArray.length) {
                if (valueTypeArray[n7] != null) {
                    valueTypeArray2[n6++] = valueTypeArray[n7];
                }
                ++n7;
            }
            valueTypeArray = valueTypeArray2;
        }
        return valueTypeArray;
    }

    public Method[] getMethods() {
        return (Method[])this.methods.clone();
    }

    public String getQualifiedIDLExceptionName(boolean bl2) {
        if (this.qualifiedIDLExceptionName != null && bl2 && this.getIDLModuleNames().length > 0) {
            return "::" + this.qualifiedIDLExceptionName;
        }
        return this.qualifiedIDLExceptionName;
    }

    public String getSignature() {
        String string = this.classDecl.getType().getTypeSignature();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ClassType getSuperclass() {
        return null;
    }

    protected static String getVisibilityString(MemberDefinition memberDefinition) {
        String string = "";
        String string2 = "";
        if (memberDefinition.isPublic()) {
            string = String.valueOf(string) + "public";
            string2 = " ";
        } else if (memberDefinition.isProtected()) {
            string = String.valueOf(string) + "protected";
            string2 = " ";
        } else if (memberDefinition.isPrivate()) {
            string = String.valueOf(string) + "private";
            string2 = " ";
        }
        if (memberDefinition.isStatic()) {
            string = String.valueOf(string) + string2;
            string = String.valueOf(string) + "static";
            string2 = " ";
        }
        if (memberDefinition.isFinal()) {
            string = String.valueOf(string) + string2;
            string = String.valueOf(string) + "final";
            string2 = " ";
        }
        return string;
    }

    protected boolean initialize(Vector vector, Vector vector2, Vector vector3, ContextStack contextStack, boolean bl2) {
        boolean bl3 = true;
        if (vector != null && vector.size() > 0) {
            this.interfaces = new InterfaceType[vector.size()];
            vector.copyInto(this.interfaces);
        } else {
            this.interfaces = new InterfaceType[0];
        }
        if (vector2 != null && vector2.size() > 0) {
            this.methods = new Method[vector2.size()];
            vector2.copyInto(this.methods);
            try {
                IDLNames.setMethodNames(this.methods, this.env);
            }
            catch (Exception exception) {
                Type.failedConstraint(13, bl2, contextStack, this.getQualifiedName(), exception.getMessage());
                bl3 = false;
            }
        } else {
            this.methods = new Method[0];
        }
        if (vector3 != null && vector3.size() > 0) {
            this.members = new Member[vector3.size()];
            vector3.copyInto(this.members);
            int n2 = 0;
            while (n2 < this.members.length) {
                if (this.members[n2].isInnerClassDeclaration()) {
                    try {
                        this.members[n2].init(contextStack, this);
                    }
                    catch (CompilerError compilerError) {
                        return false;
                    }
                }
                ++n2;
            }
            try {
                IDLNames.setMemberNames(this.members, this.methods, this.env);
            }
            catch (Exception exception) {
                int n3 = this.classDef.isInterface() ? 19 : 20;
                Type.failedConstraint(n3, bl2, contextStack, this.getQualifiedName(), exception.getMessage());
                bl3 = false;
            }
        } else {
            this.members = new Member[0];
        }
        if (bl3) {
            bl3 = this.setRepositoryID();
        }
        return bl3;
    }

    public boolean isAbstractBase() {
        return this.isAbstractBase;
    }

    public boolean isBoxed() {
        return this.isIDLEntity() && !this.isValueBase() && !this.isAbstractBase() && !this.isCORBAObject() && !this.isIDLEntityException();
    }

    public boolean isCORBAObject() {
        return this.isCORBAObject;
    }

    public boolean isCORBAUserException() {
        return this.isCORBAUserException;
    }

    public boolean isCheckedException() {
        return this.isCheckedException;
    }

    private boolean isConformingConstantType(MemberDefinition memberDefinition) {
        return this.isConformingConstantType(memberDefinition.getType(), memberDefinition);
    }

    private boolean isConformingConstantType(sun.tools.java.Type type, MemberDefinition memberDefinition) {
        boolean bl2 = true;
        int n2 = type.getTypeCode();
        switch (n2) {
            case 10: {
                if (type.getClassName() == sun.tools.java.Constants.idJavaLangString) break;
                Type.failedConstraint(3, false, this.stack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                bl2 = false;
                break;
            }
            case 9: {
                Type.failedConstraint(3, false, this.stack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                bl2 = false;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n2);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return bl2;
    }

    protected boolean isConformingRemoteMethod(Method method, boolean bl2) throws ClassNotFound {
        boolean bl3;
        boolean bl4 = false;
        ValueType[] valueTypeArray = method.getExceptions();
        int n2 = 0;
        while (n2 < valueTypeArray.length) {
            if (CompoundType.isRemoteException(valueTypeArray[n2], this.env)) {
                bl4 = true;
                break;
            }
            ++n2;
        }
        if (!bl4) {
            Type.failedConstraint(5, bl2, this.stack, method.getEnclosing(), method.toString());
        }
        if (bl3 = this.isIDLEntityException(method.getReturnType(), method, bl2) ^ true) {
            Type[] typeArray = method.getArguments();
            int n3 = 0;
            while (n3 < typeArray.length) {
                if (this.isIDLEntityException(typeArray[n3], method, bl2)) {
                    bl3 = false;
                    break;
                }
                ++n3;
            }
        }
        return bl4 && bl3;
    }

    public boolean isException() {
        return this.isException;
    }

    public boolean isIDLEntity() {
        return this.isIDLEntity;
    }

    public boolean isIDLEntityException() {
        return this.isIDLEntity() && this.isException();
    }

    protected boolean isIDLEntityException(Type type, Method method, boolean bl2) throws ClassNotFound {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isCompound() && ((CompoundType)type).isIDLEntityException()) {
            Type.failedConstraint(18, bl2, this.stack, method.getEnclosing(), method.toString());
            return true;
        }
        return false;
    }

    public static boolean isRemoteException(ClassType classType, BatchEnvironment batchEnvironment) {
        sun.tools.java.Type type = classType.getClassDeclaration().getType();
        return type.equals(batchEnvironment.typeRemoteException) || type.equals(batchEnvironment.typeIOException) || type.equals(batchEnvironment.typeException) || type.equals(batchEnvironment.typeThrowable);
    }

    public boolean isRemoteExceptionOrSubclass() {
        return this.isRemoteExceptionOrSubclass;
    }

    public boolean isValueBase() {
        return this.isValueBase;
    }

    /*
     * Unable to fully structure code
     */
    protected Class loadClass() {
        block12: {
            block10: {
                var1_1 = null;
                try {
                    this.env.getMain().compileAllClasses(this.env);
                    break block10;
                }
                catch (Exception v0) {
                    var2_2 = this.env.getClasses();
                    ** while (var2_2.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    var3_3 = (ClassDeclaration)var2_2.nextElement();
                    continue;
                }
lbl10:
                // 1 sources

                Type.failedConstraint(26, false, this.stack, "required classes");
                this.env.flushErrors();
            }
            try {
                var1_1 = Util.loadClass(this.getQualifiedName(), null, null);
            }
            catch (ClassNotFoundException v1) {
            }
            catch (LinkageError v2) {}
            if (var1_1 != null) break block12;
            if (this.env.loader == null) {
                var2_2 = this.env.getMain().getDestinationDir();
                if (var2_2 == null) {
                    var2_2 = new File(".");
                }
                this.env.loader = new DirectoryLoader((File)var2_2);
            }
            try {
                var1_1 = this.env.loader.loadClass(this.getQualifiedName());
            }
            catch (Exception v3) {}
        }
        return var1_1;
    }

    protected static Type makeType(sun.tools.java.Type type, ClassDefinition classDefinition, ContextStack contextStack) {
        if (contextStack.anyErrors()) {
            return null;
        }
        String string = type.toString();
        Type type2 = Type.getType(string, contextStack);
        if (type2 != null) {
            return type2;
        }
        type2 = Type.getType(String.valueOf(string) + contextStack.getContextCodeString(), contextStack);
        if (type2 != null) {
            return type2;
        }
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        int n2 = type.getTypeCode();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                type2 = PrimitiveType.forPrimitive(type, contextStack);
                break;
            }
            case 9: {
                type2 = ArrayType.forArray(type, contextStack);
                break;
            }
            case 10: {
                try {
                    ClassDefinition classDefinition2 = classDefinition;
                    if (classDefinition2 == null) {
                        classDefinition2 = batchEnvironment.getClassDeclaration(type).getClassDefinition((Environment)batchEnvironment);
                    }
                    if (classDefinition2.isInterface()) {
                        type2 = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
                        if (type2 != null) break;
                        if (batchEnvironment.defRemote.implementedBy((Environment)batchEnvironment, classDefinition2.getClassDeclaration())) {
                            boolean bl2 = contextStack.isParentAValue();
                            type2 = RemoteType.forRemote(classDefinition2, contextStack, bl2);
                            if (type2 != null || !bl2) break;
                            type2 = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                            break;
                        }
                        type2 = AbstractType.forAbstract(classDefinition2, contextStack, true);
                        if (type2 != null) break;
                        type2 = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                        break;
                    }
                    type2 = SpecialClassType.forSpecial(classDefinition2, contextStack);
                    if (type2 != null) break;
                    ClassDeclaration classDeclaration = classDefinition2.getClassDeclaration();
                    if (batchEnvironment.defRemote.implementedBy((Environment)batchEnvironment, classDeclaration)) {
                        boolean bl3 = contextStack.isParentAValue();
                        type2 = ImplementationType.forImplementation(classDefinition2, contextStack, bl3);
                        if (type2 != null || !bl3) break;
                        type2 = NCClassType.forNCClass(classDefinition2, contextStack);
                        break;
                    }
                    if (batchEnvironment.defSerializable.implementedBy((Environment)batchEnvironment, classDeclaration)) {
                        type2 = ValueType.forValue(classDefinition2, contextStack, true);
                    }
                    if (type2 != null) break;
                    type2 = NCClassType.forNCClass(classDefinition2, contextStack);
                }
                catch (ClassNotFound classNotFound) {
                    Type.classNotFound(contextStack, classNotFound);
                }
                break;
            }
            default: {
                throw new CompilerError("Unknown typecode (" + n2 + ") for " + type.getTypeSignature());
            }
        }
        return type2;
    }

    protected boolean printExtends(IndentingWriter indentingWriter, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        ClassType classType = this.getSuperclass();
        if (!(classType == null || bl3 && (classType.isType(1024) || classType.isType(2048)))) {
            indentingWriter.p(" extends ");
            classType.printTypeName(indentingWriter, bl2, bl3, bl4);
            return true;
        }
        return false;
    }

    protected void printImplements(IndentingWriter indentingWriter, String string, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        InterfaceType[] interfaceTypeArray = this.getInterfaces();
        String string2 = " implements";
        if (this.isInterface()) {
            string2 = " extends";
        }
        if (bl3) {
            string2 = ":";
        }
        int n2 = 0;
        while (n2 < interfaceTypeArray.length) {
            if (!bl3 || !interfaceTypeArray[n2].isType(1024) && !interfaceTypeArray[n2].isType(2048)) {
                if (n2 == 0) {
                    indentingWriter.p(String.valueOf(string) + string2 + " ");
                } else {
                    indentingWriter.p(", ");
                }
                interfaceTypeArray[n2].printTypeName(indentingWriter, bl2, bl3, bl4);
            }
            ++n2;
        }
    }

    protected void printMembers(IndentingWriter indentingWriter, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        Member[] memberArray = this.getMembers();
        int n2 = 0;
        while (n2 < memberArray.length) {
            if (!memberArray[n2].isInnerClassDeclaration()) {
                Type type = memberArray[n2].getType();
                String string = memberArray[n2].getVisibility();
                String string2 = bl3 ? memberArray[n2].getIDLName() : memberArray[n2].getName();
                String string3 = memberArray[n2].getValue();
                indentingWriter.p(string);
                if (string.length() > 0) {
                    indentingWriter.p(" ");
                }
                type.printTypeName(indentingWriter, bl2, bl3, bl4);
                indentingWriter.p(" " + string2);
                if (string3 != null) {
                    indentingWriter.pln(" = " + string3 + ";");
                } else {
                    indentingWriter.pln(";");
                }
            }
            ++n2;
        }
    }

    protected void printMethod(Method method, IndentingWriter indentingWriter, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        String string = method.getVisibility();
        indentingWriter.p(string);
        if (string.length() > 0) {
            indentingWriter.p(" ");
        }
        method.getReturnType().printTypeName(indentingWriter, bl2, bl3, bl4);
        if (bl3) {
            indentingWriter.p(" " + method.getIDLName());
        } else {
            indentingWriter.p(" " + method.getName());
        }
        indentingWriter.p(" (");
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        int n2 = 0;
        while (n2 < typeArray.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            if (bl3) {
                indentingWriter.p("in ");
            }
            typeArray[n2].printTypeName(indentingWriter, bl2, bl3, bl4);
            indentingWriter.p(" " + stringArray[n2]);
            ++n2;
        }
        indentingWriter.p(")");
        ValueType[] valueTypeArray = this.isType(65536) ? method.getImplExceptions() : method.getExceptions();
        int n3 = 0;
        while (n3 < valueTypeArray.length) {
            if (n3 == 0) {
                if (bl3) {
                    indentingWriter.p(" raises (");
                } else {
                    indentingWriter.p(" throws ");
                }
            } else {
                indentingWriter.p(", ");
            }
            if (bl3) {
                if (bl2) {
                    indentingWriter.p(valueTypeArray[n3].getQualifiedIDLExceptionName(bl4));
                } else {
                    indentingWriter.p(valueTypeArray[n3].getIDLExceptionName());
                }
                indentingWriter.p(" [a.k.a. ");
                valueTypeArray[n3].printTypeName(indentingWriter, bl2, bl3, bl4);
                indentingWriter.p("]");
            } else {
                valueTypeArray[n3].printTypeName(indentingWriter, bl2, bl3, bl4);
            }
            ++n3;
        }
        if (bl3 && valueTypeArray.length > 0) {
            indentingWriter.p(")");
        }
        if (method.isInherited()) {
            indentingWriter.p(" // Inherited from ");
            indentingWriter.p(method.getDeclaredBy());
        }
        indentingWriter.pln(";");
    }

    protected void printMethods(IndentingWriter indentingWriter, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        Method[] methodArray = this.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            this.printMethod(method, indentingWriter, bl2, bl3, bl4);
            ++n2;
        }
    }

    private void setFlags() {
        try {
            this.isCORBAObject = this.env.defCorbaObject.implementedBy((Environment)this.env, this.classDecl);
            this.isIDLEntity = this.env.defIDLEntity.implementedBy((Environment)this.env, this.classDecl);
            this.isValueBase = this.env.defValueBase.implementedBy((Environment)this.env, this.classDecl);
            this.isAbstractBase = this.isInterface() && this.isIDLEntity && !this.isValueBase && !this.isCORBAObject;
            boolean bl2 = this.isCORBAUserException = this.classDecl.getName() == Constants.idCorbaUserException;
            if (this.env.defThrowable.implementedBy((Environment)this.env, this.classDecl)) {
                this.isException = true;
                this.isCheckedException = !this.env.defRuntimeException.implementedBy((Environment)this.env, this.classDecl) && !this.env.defError.implementedBy((Environment)this.env, this.classDecl);
                this.isRemoteExceptionOrSubclass = this.env.defRemoteException.implementedBy((Environment)this.env, this.classDecl);
            } else {
                this.isException = false;
            }
        }
        catch (ClassNotFound classNotFound) {
            Type.classNotFound(this.stack, classNotFound);
        }
    }

    protected void swapInvalidTypes() {
        int n2 = 0;
        while (n2 < this.interfaces.length) {
            if (this.interfaces[n2].getStatus() != 1) {
                this.interfaces[n2] = (InterfaceType)this.getValidType(this.interfaces[n2]);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.methods.length) {
            this.methods[n3].swapInvalidTypes();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.members.length) {
            this.members[n4].swapInvalidTypes();
            ++n4;
        }
    }

    protected Vector updateParentClassMethods(ClassDefinition classDefinition, Vector vector, boolean bl2, ContextStack contextStack) throws ClassNotFound {
        ClassDeclaration classDeclaration = classDefinition.getSuperClass((Environment)this.env);
        while (classDeclaration != null) {
            ClassDefinition classDefinition2 = classDeclaration.getClassDefinition((Environment)this.env);
            Identifier identifier = classDeclaration.getName();
            if (identifier == sun.tools.java.Constants.idJavaLangObject) break;
            MemberDefinition memberDefinition = classDefinition2.getFirstMember();
            while (memberDefinition != null) {
                if (memberDefinition.isMethod() && !memberDefinition.isInitializer() && !memberDefinition.isConstructor() && !memberDefinition.isPrivate()) {
                    Method method;
                    try {
                        method = new Method(this, memberDefinition, bl2, contextStack);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    int n2 = vector.indexOf(method);
                    if (n2 >= 0) {
                        Method method2 = (Method)vector.elementAt(n2);
                        method2.setDeclaredBy(identifier);
                    } else {
                        vector.addElement(method);
                    }
                }
                memberDefinition = memberDefinition.getNextMember();
            }
            classDeclaration = classDefinition2.getSuperClass((Environment)this.env);
        }
        return vector;
    }

    public class Method
    implements ContextElement,
    Cloneable {
        private MemberDefinition memberDef;
        private CompoundType enclosing;
        private ValueType[] exceptions;
        private ValueType[] implExceptions;
        private Type returnType;
        private Type[] arguments;
        private String[] argumentNames;
        private String vis;
        private String name;
        private String idlName;
        private String stringRep = null;
        private int attributeKind = 0;
        private String attributeName = null;
        private int attributePairIndex = -1;
        private Identifier declaredBy = null;

        public Method(CompoundType compoundType2, MemberDefinition memberDefinition, boolean bl2, ContextStack contextStack) throws Exception {
            this.enclosing = compoundType2;
            this.memberDef = memberDefinition;
            this.vis = CompoundType.getVisibilityString(memberDefinition);
            this.idlName = null;
            boolean bl3 = true;
            this.declaredBy = memberDefinition.getClassDeclaration().getName();
            this.name = memberDefinition.getName().toString();
            contextStack.setNewContextCode(2);
            contextStack.push(this);
            contextStack.setNewContextCode(3);
            sun.tools.java.Type type = memberDefinition.getType();
            sun.tools.java.Type type2 = type.getReturnType();
            if (type2 == sun.tools.java.Type.tVoid) {
                this.returnType = PrimitiveType.forPrimitive(type2, contextStack);
            } else {
                this.returnType = CompoundType.makeType(type2, null, contextStack);
                if (this.returnType == null || !CompoundType.this.assertNotImpl(this.returnType, bl2, contextStack, compoundType2, false)) {
                    bl3 = false;
                    Type.failedConstraint(24, bl2, contextStack, compoundType2.getName());
                }
            }
            contextStack.setNewContextCode(4);
            sun.tools.java.Type[] typeArray = memberDefinition.getType().getArgumentTypes();
            this.arguments = new Type[typeArray.length];
            this.argumentNames = new String[typeArray.length];
            Vector vector = memberDefinition.getArguments();
            int n2 = 0;
            while (n2 < typeArray.length) {
                Type type3 = null;
                try {
                    type3 = CompoundType.makeType(typeArray[n2], null, contextStack);
                }
                catch (Exception exception) {}
                if (type3 != null) {
                    if (!CompoundType.this.assertNotImpl(type3, bl2, contextStack, compoundType2, false)) {
                        bl3 = false;
                    } else {
                        this.arguments[n2] = type3;
                        if (vector != null) {
                            LocalMember localMember = (LocalMember)vector.elementAt(n2 + 1);
                            this.argumentNames[n2] = localMember.getName().toString();
                        } else {
                            this.argumentNames[n2] = this.makeArgName(n2, type3);
                        }
                    }
                } else {
                    bl3 = false;
                    Type.failedConstraint(25, false, contextStack, compoundType2.getQualifiedName(), this.name);
                }
                ++n2;
            }
            if (!bl3) {
                contextStack.pop(false);
                throw new Exception();
            }
            try {
                this.exceptions = compoundType2.getMethodExceptions(memberDefinition, bl2, contextStack);
                this.implExceptions = this.exceptions;
                contextStack.pop(true);
            }
            catch (Exception exception) {
                contextStack.pop(false);
                throw new Exception();
            }
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }

        public void destroy() {
            if (this.memberDef != null) {
                int n2;
                this.memberDef = null;
                this.enclosing = null;
                if (this.exceptions != null) {
                    n2 = 0;
                    while (n2 < this.exceptions.length) {
                        if (this.exceptions[n2] != null) {
                            this.exceptions[n2].destroy();
                        }
                        this.exceptions[n2] = null;
                        ++n2;
                    }
                    this.exceptions = null;
                }
                if (this.implExceptions != null) {
                    n2 = 0;
                    while (n2 < this.implExceptions.length) {
                        if (this.implExceptions[n2] != null) {
                            this.implExceptions[n2].destroy();
                        }
                        this.implExceptions[n2] = null;
                        ++n2;
                    }
                    this.implExceptions = null;
                }
                if (this.returnType != null) {
                    this.returnType.destroy();
                }
                this.returnType = null;
                if (this.arguments != null) {
                    n2 = 0;
                    while (n2 < this.arguments.length) {
                        if (this.arguments[n2] != null) {
                            this.arguments[n2].destroy();
                        }
                        this.arguments[n2] = null;
                        ++n2;
                    }
                    this.arguments = null;
                }
                if (this.argumentNames != null) {
                    n2 = 0;
                    while (n2 < this.argumentNames.length) {
                        this.argumentNames[n2] = null;
                        ++n2;
                    }
                    this.argumentNames = null;
                }
                this.vis = null;
                this.name = null;
                this.idlName = null;
                this.stringRep = null;
                this.attributeName = null;
                this.declaredBy = null;
            }
        }

        public boolean equals(Object object) {
            Method method = (Method)object;
            if (this.getName().equals(method.getName()) && this.arguments.length == method.arguments.length) {
                int n2 = 0;
                while (n2 < this.arguments.length) {
                    if (!this.arguments[n2].equals(method.arguments[n2])) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }

        public Type[] getArguments() {
            return (Type[])this.arguments.clone();
        }

        public int getAttributeKind() {
            return this.attributeKind;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public int getAttributePairIndex() {
            return this.attributePairIndex;
        }

        public Identifier getDeclaredBy() {
            return this.declaredBy;
        }

        public String getElementName() {
            return this.memberDef.toString();
        }

        public CompoundType getEnclosing() {
            return this.enclosing;
        }

        public ValueType[] getExceptions() {
            return (ValueType[])this.exceptions.clone();
        }

        public ValueType[] getFilteredStubExceptions(ValueType[] valueTypeArray) {
            ValueType[] valueTypeArray2 = valueTypeArray;
            int n2 = valueTypeArray.length;
            try {
                int n3 = 0;
                while (n3 < valueTypeArray.length) {
                    ClassDeclaration classDeclaration = valueTypeArray[n3].getClassDeclaration();
                    if (CompoundType.this.env.defRemoteException.superClassOf((Environment)CompoundType.this.env, classDeclaration) && !CompoundType.this.env.defRemoteException.getClassDeclaration().equals((Object)classDeclaration) || CompoundType.this.env.defRuntimeException.superClassOf((Environment)CompoundType.this.env, classDeclaration) || CompoundType.this.env.defError.superClassOf((Environment)CompoundType.this.env, classDeclaration)) {
                        valueTypeArray[n3] = null;
                        --n2;
                    }
                    ++n3;
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(CompoundType.this.stack, classNotFound);
            }
            if (n2 < valueTypeArray.length) {
                ValueType[] valueTypeArray3 = new ValueType[n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < valueTypeArray.length) {
                    if (valueTypeArray[n5] != null) {
                        valueTypeArray3[n4++] = valueTypeArray[n5];
                    }
                    ++n5;
                }
                valueTypeArray = valueTypeArray3;
            }
            return valueTypeArray;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public ValueType[] getImplExceptions() {
            return (ValueType[])this.implExceptions.clone();
        }

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public String getName() {
            return this.name;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public sun.tools.java.Type getType() {
            return this.memberDef.getType();
        }

        public ValueType[] getUniqueCatchList(ValueType[] valueTypeArray) {
            int n2;
            ValueType[] valueTypeArray2 = valueTypeArray;
            int n3 = valueTypeArray.length;
            try {
                int n4 = 0;
                while (n4 < valueTypeArray.length) {
                    ClassDeclaration classDeclaration = valueTypeArray[n4].getClassDeclaration();
                    if (CompoundType.this.env.defRemoteException.superClassOf((Environment)CompoundType.this.env, classDeclaration) || CompoundType.this.env.defRuntimeException.superClassOf((Environment)CompoundType.this.env, classDeclaration) || CompoundType.this.env.defError.superClassOf((Environment)CompoundType.this.env, classDeclaration)) {
                        valueTypeArray[n4] = null;
                        --n3;
                    }
                    ++n4;
                }
                n2 = 0;
                while (n2 < valueTypeArray.length) {
                    if (valueTypeArray[n2] != null) {
                        ClassDefinition classDefinition = valueTypeArray[n2].getClassDefinition();
                        int n5 = 0;
                        while (n5 < valueTypeArray.length) {
                            if (n5 != n2 && valueTypeArray[n2] != null && valueTypeArray[n5] != null && classDefinition.superClassOf((Environment)CompoundType.this.env, valueTypeArray[n5].getClassDeclaration())) {
                                valueTypeArray[n5] = null;
                                --n3;
                            }
                            ++n5;
                        }
                    }
                    ++n2;
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(CompoundType.this.stack, classNotFound);
            }
            if (n3 < valueTypeArray.length) {
                ValueType[] valueTypeArray3 = new ValueType[n3];
                n2 = 0;
                int n6 = 0;
                while (n6 < valueTypeArray.length) {
                    if (valueTypeArray[n6] != null) {
                        valueTypeArray3[n2++] = valueTypeArray[n6];
                    }
                    ++n6;
                }
                valueTypeArray = valueTypeArray3;
            }
            if (valueTypeArray.length == 0) {
                return null;
            }
            return valueTypeArray;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isAttribute() {
            return this.attributeKind != 0;
        }

        public boolean isConstructor() {
            return this.memberDef.isConstructor();
        }

        public boolean isInherited() {
            return this.declaredBy != this.enclosing.getIdentifier();
        }

        public boolean isNormalMethod() {
            return !this.memberDef.isConstructor() && this.attributeKind == 0;
        }

        public boolean isPrivate() {
            return this.memberDef.isPrivate();
        }

        public boolean isProtected() {
            return this.memberDef.isPrivate();
        }

        public boolean isPublic() {
            return this.memberDef.isPublic();
        }

        public boolean isReadWriteAttribute() {
            return this.attributeKind == 3 || this.attributeKind == 4;
        }

        public boolean isStatic() {
            return this.memberDef.isStatic();
        }

        private String makeArgName(int n2, Type type) {
            return "arg" + n2;
        }

        public void setAttributeKind(int n2) {
            this.attributeKind = n2;
        }

        public void setAttributeName(String string) {
            this.attributeName = string;
        }

        public void setAttributePairIndex(int n2) {
            this.attributePairIndex = n2;
        }

        public void setDeclaredBy(Identifier identifier) {
            this.declaredBy = identifier;
        }

        public void setIDLName(String string) {
            this.idlName = string;
        }

        public void setImplExceptions(ValueType[] valueTypeArray) {
            this.implExceptions = valueTypeArray;
        }

        protected void swapInvalidTypes() {
            if (this.returnType.getStatus() != 1) {
                this.returnType = CompoundType.this.getValidType(this.returnType);
            }
            int n2 = 0;
            while (n2 < this.arguments.length) {
                if (this.arguments[n2].getStatus() != 1) {
                    this.arguments[n2] = CompoundType.this.getValidType(this.arguments[n2]);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.exceptions.length) {
                if (this.exceptions[n3].getStatus() != 1) {
                    this.exceptions[n3] = (ValueType)CompoundType.this.getValidType(this.exceptions[n3]);
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.implExceptions.length) {
                if (this.implExceptions[n4].getStatus() != 1) {
                    this.implExceptions[n4] = (ValueType)CompoundType.this.getValidType(this.implExceptions[n4]);
                }
                ++n4;
            }
        }

        public String toString() {
            if (this.stringRep == null) {
                StringBuffer stringBuffer = new StringBuffer(this.returnType.toString());
                stringBuffer.append(" ");
                stringBuffer.append(this.getName());
                stringBuffer.append(" (");
                int n2 = 0;
                while (n2 < this.arguments.length) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.arguments[n2]);
                    stringBuffer.append(" ");
                    stringBuffer.append(this.argumentNames[n2]);
                    ++n2;
                }
                stringBuffer.append(")");
                int n3 = 0;
                while (n3 < this.exceptions.length) {
                    if (n3 == 0) {
                        stringBuffer.append(" throws ");
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.exceptions[n3]);
                    ++n3;
                }
                stringBuffer.append(";");
                this.stringRep = stringBuffer.toString();
            }
            return this.stringRep;
        }
    }

    public class Member
    implements ContextElement,
    Cloneable {
        private Type type;
        private String vis;
        private String value;
        private String name;
        private String idlName;
        private boolean innerClassDecl;
        private boolean constant;
        private MemberDefinition member;
        private boolean forceTransient;

        public Member(MemberDefinition memberDefinition, String string, ContextStack contextStack, CompoundType compoundType2) {
            this.member = memberDefinition;
            this.value = string;
            this.forceTransient = false;
            boolean bl2 = this.innerClassDecl = memberDefinition.getInnerClass() != null;
            if (!this.innerClassDecl) {
                this.init(contextStack, compoundType2);
            }
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }

        public void destroy() {
            if (this.type != null) {
                this.type.destroy();
                this.type = null;
                this.vis = null;
                this.value = null;
                this.name = null;
                this.idlName = null;
                this.member = null;
            }
        }

        public String getElementName() {
            return "\"" + this.getName() + "\"";
        }

        public String getIDLName() {
            return this.idlName;
        }

        protected MemberDefinition getMemberDefinition() {
            return this.member;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getVisibility() {
            return this.vis;
        }

        public void init(ContextStack contextStack, CompoundType compoundType) {
            int n2;
            char c10;
            this.constant = false;
            this.name = this.member.getName().toString();
            this.vis = CompoundType.getVisibilityString(this.member);
            this.idlName = null;
            int n3 = 6;
            contextStack.setNewContextCode(n3);
            contextStack.push(this);
            if (this.member.isVariable()) {
                if (this.value != null && this.member.isConstant()) {
                    n3 = 7;
                    this.constant = true;
                } else if (this.member.isStatic()) {
                    n3 = 8;
                } else if (this.member.isTransient()) {
                    n3 = 9;
                }
            }
            contextStack.setNewContextCode(n3);
            this.type = CompoundType.makeType(this.member.getType(), null, contextStack);
            if (this.type == null || !this.innerClassDecl && !this.member.isStatic() && !this.member.isTransient() && !CompoundType.this.assertNotImpl(this.type, false, contextStack, compoundType, true)) {
                contextStack.pop(false);
                throw new CompilerError("");
            }
            if (this.constant && this.type.isPrimitive() && !Character.isDigit(c10 = this.value.charAt((n2 = this.value.length()) - 1))) {
                this.value = this.value.substring(0, n2 - 1);
            }
            contextStack.pop(true);
        }

        public boolean isConstant() {
            return this.constant;
        }

        public boolean isFinal() {
            return this.member.isFinal();
        }

        public boolean isInnerClassDeclaration() {
            return this.innerClassDecl;
        }

        public boolean isPrivate() {
            return this.member.isPrivate();
        }

        public boolean isPublic() {
            return this.member.isPublic();
        }

        public boolean isStatic() {
            return this.member.isStatic();
        }

        public boolean isTransient() {
            if (this.forceTransient) {
                return true;
            }
            return this.member.isTransient();
        }

        public void setIDLName(String string) {
            this.idlName = string;
        }

        protected void setTransient() {
            if (!this.isTransient()) {
                this.forceTransient = true;
                this.vis = this.vis.length() > 0 ? String.valueOf(this.vis) + " transient" : "transient";
            }
        }

        protected void swapInvalidTypes() {
            if (this.type.getStatus() != 1) {
                this.type = CompoundType.this.getValidType(this.type);
            }
        }

        public String toString() {
            String string = this.type.toString();
            if (this.value != null) {
                string = String.valueOf(string) + " = " + this.value;
            }
            return string;
        }
    }
}

