/*
 * Decompiled with CFR 0.152.
 */
package applets;

import applets.AnimationFrameApplet;
import iDSS.disp.DisplayFrame;
import iDSS.disp.ImageDisplay;
import iDSS.gridDisp.SurfaceColor;
import iDSS.grids.Grid;
import iDSS.grids.Grid2;
import iDSS.grids.GridCell;
import iDSS.tidalData.TimestampPanel;
import iDSS.utils.ObjectReadWrite;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GridViewControlApplet
extends DisplayFrame
implements ActionListener {
    private JButton okButton;
    private TimestampPanel fromTS;
    private TimestampPanel toTS;
    public static final String INSTANT = "instant";
    public static final String SUMMARY = "summary";
    public static final String HISTORY = "history";
    private static final String fdGrids = "fdGrids";
    private static final String summaryGrids = "summaryGrids";
    private String gridPath = "fdGrids";
    private String simulationName;
    private JRadioButton instantGridsRadioButton;
    private JRadioButton summaryGridsRadioButton;
    private ButtonGroup bg;
    private final int MINIMUM_IMAGE_SIZE = 400;
    private final String serverResultsAddress = "http://130.159.78.177:8000/idss/results/";
    private int timeStepHrs;
    private int simStartYear = 2000;
    private int simEndYear;
    private JComboBox gridDataCategory;
    private SurfaceColor sc;
    private JTextField simNameTextField = new JTextField(10);
    private JComboBox timeStepHrsCombo;

    public GridViewControlApplet() {
        super("Visualization", false, true, false, true, null);
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(1));
        vector.add(new Integer(6));
        vector.add(new Integer(12));
        vector.add(new Integer(24));
        vector.add(new Integer(240));
        this.timeStepHrsCombo = new JComboBox(vector);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(new JLabel("SimName:"));
        jPanel.add(this.simNameTextField);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel("Timestep hrs:"));
        jPanel.add(this.timeStepHrsCombo);
        this.fromTS = new TimestampPanel("From: ", 2000, 2100);
        this.toTS = new TimestampPanel("To: ", 2000, 2100);
        JLabel jLabel = new JLabel("Grid type:");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("okButtonCommand");
        this.instantGridsRadioButton = new JRadioButton("Instant", true);
        this.summaryGridsRadioButton = new JRadioButton("Summary", false);
        this.instantGridsRadioButton.addActionListener(this);
        this.summaryGridsRadioButton.addActionListener(this);
        this.instantGridsRadioButton.setActionCommand(INSTANT);
        this.summaryGridsRadioButton.setActionCommand(SUMMARY);
        this.bg = new ButtonGroup();
        this.bg.add(this.instantGridsRadioButton);
        this.bg.add(this.summaryGridsRadioButton);
        this.gridDataCategory = new JComboBox(GridCell.getParametersVector());
        this.gridDataCategory.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add(this.instantGridsRadioButton);
        jPanel2.add(this.summaryGridsRadioButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(jLabel);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createHorizontalGlue());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(this.gridDataCategory);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.okButton);
        ((JInternalFrame)((Object)this)).getContentPane().setLayout(new BoxLayout(((JInternalFrame)((Object)this)).getContentPane(), 1));
        ((JInternalFrame)((Object)this)).getContentPane().add((Component)this.fromTS);
        ((JInternalFrame)((Object)this)).getContentPane().add((Component)this.toTS);
        ((JInternalFrame)((Object)this)).getContentPane().add(Box.createVerticalStrut(10));
        ((JInternalFrame)((Object)this)).getContentPane().add(jPanel3);
        ((JInternalFrame)((Object)this)).getContentPane().add(Box.createVerticalStrut(5));
        ((JInternalFrame)((Object)this)).getContentPane().add(jPanel4);
        ((JInternalFrame)((Object)this)).getContentPane().add(Box.createVerticalStrut(10));
        ((JInternalFrame)((Object)this)).getContentPane().add(jPanel);
        ((JInternalFrame)((Object)this)).getContentPane().setBackground(Color.lightGray);
        ((JInternalFrame)((Object)this)).pack();
        ((JComponent)((Object)this)).setVisible(true);
    }

    public void resetYearCombo(int n, int n2) {
        this.fromTS.resetYearCombo(n, n2);
        this.toTS.resetYearCombo(n, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("okButtonCommand")) {
            System.out.println("OK button pressed, gridPath : " + this.gridPath);
            this.simulationName = this.simNameTextField.getText();
            this.timeStepHrs = (Integer)this.timeStepHrsCombo.getSelectedItem();
            System.out.println("timeStepHrs : " + this.timeStepHrs);
            if (this.simulationName != null && this.simulationName.length() > 0) {
                Object object;
                System.out.println("simulationName.length() : " + this.simulationName.length());
                System.out.println("simulationName : " + this.simulationName);
                Vector vector = new Vector();
                if (this.gridPath == fdGrids) {
                    object = this.getURLNames();
                    vector = this.getImages((Vector)object);
                } else if (this.gridPath == summaryGrids) {
                    object = this.getURLNames2();
                    vector = this.getImages2((Vector)object);
                }
                object = new AnimationFrameApplet(this.simulationName, vector);
                ((Component)((Object)this)).firePropertyChange("addToModelView", null, object);
                if (this.sc != null) {
                    ImageDisplay imageDisplay = new ImageDisplay("Legend", this.sc.getLegendWidth(), this.sc.getLegendHeight());
                    ((Component)((Object)this)).firePropertyChange("addToModelView", null, imageDisplay);
                    this.sc.drawLegend(imageDisplay);
                }
            }
        } else if (actionEvent.getActionCommand().equals(INSTANT)) {
            this.gridPath = fdGrids;
            this.gridDataCategory.setEnabled(false);
            System.out.println("RadioButton clicked, gridPath : " + this.gridPath);
        } else if (actionEvent.getActionCommand().equals(SUMMARY)) {
            this.gridPath = summaryGrids;
            this.gridDataCategory.setEnabled(true);
            System.out.println("RadioButton clicked, gridPath : " + this.gridPath);
        }
    }

    private Vector getImages(Vector vector) {
        Serializable serializable;
        double d = 9999.0;
        double d2 = -9999.0;
        Vector<Grid> vector2 = new Vector<Grid>();
        int n = 0;
        while (n < vector.size()) {
            serializable = (URL)vector.elementAt(n);
            Grid grid = (Grid)ObjectReadWrite.read((URL)serializable);
            if (grid != null) {
                grid.setZMinMax();
                vector2.add(grid);
                d = Math.min(d, grid.getZMin());
                d2 = Math.max(d2, grid.getZMax());
            }
            ++n;
        }
        this.sc = new SurfaceColor("Flood Grids", d, d2, SurfaceColor.FLOOD);
        serializable = new Vector();
        int n2 = 0;
        while (n2 < vector2.size()) {
            Grid grid = (Grid)vector2.elementAt(n2);
            String string = grid.getName();
            BufferedImage bufferedImage = grid.getImage(this.sc);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(string);
            vector3.add(bufferedImage);
            ((Vector)serializable).add(vector3);
            ++n2;
        }
        return serializable;
    }

    private Vector getImages2(Vector vector) {
        Grid2 grid2;
        URL uRL;
        double d = 9999.0;
        double d2 = -9999.0;
        String string = (String)this.gridDataCategory.getSelectedItem();
        Vector<Grid> vector2 = new Vector<Grid>();
        int n = 0;
        while (n < vector.size()) {
            Grid grid;
            uRL = (URL)vector.elementAt(n);
            grid2 = (Grid2)ObjectReadWrite.read((URL)uRL);
            if (grid2 != null && (grid = grid2.getGrid(string)) != null) {
                grid.setZMinMax();
                vector2.add(grid);
                d = Math.min(d, grid.getZMin());
                d2 = Math.max(d2, grid.getZMax());
            }
            ++n;
        }
        uRL = new SurfaceColor("Flood Grids", d, d2, SurfaceColor.FLOOD);
        grid2 = new SurfaceColor("Probability Grids", 0.0, 1.0, SurfaceColor.DEM);
        double d3 = 3.1536E10;
        SurfaceColor surfaceColor = new SurfaceColor("Time Length", SurfaceColor.TIMECOLORSCHEMEUPTOAYEAR);
        this.sc = string == "highestDepthOfFlooding" ? uRL : (string == "minimumProbabilityOfSurvival" ? grid2 : surfaceColor);
        Vector vector3 = new Vector();
        int n2 = 0;
        while (n2 < vector2.size()) {
            Grid grid = (Grid)vector2.elementAt(n2);
            String string2 = grid.getName();
            BufferedImage bufferedImage = grid.getImage(this.sc);
            Vector<Object> vector4 = new Vector<Object>();
            vector4.add(string2);
            vector4.add(bufferedImage);
            vector3.add(vector4);
            ++n2;
        }
        return vector3;
    }

    private Vector getURLNames2() {
        Object object;
        Vector<URL> vector = new Vector<URL>();
        try {
            String string = this.fromTS.getYear();
            object = this.toTS.getYear();
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt((String)object);
            String string2 = "http://130.159.78.177:8000/idss/results/" + this.simulationName + "/" + this.gridPath + "/";
            int n3 = n;
            while (n3 <= n2) {
                String string3 = String.valueOf(n3);
                String string4 = string2 + "SUM" + string3;
                URL uRL = new URL(string4);
                vector.add(uRL);
                ++n3;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("GridViewControlApplet.getURLNames2()" + malformedURLException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("GridViewControlApplet.getURLNames2()" + numberFormatException.toString());
        }
        int n = 0;
        while (n < vector.size()) {
            object = (URL)vector.elementAt(n);
            System.out.println(((URL)object).toString());
            ++n;
        }
        return vector;
    }

    private Vector getURLNames() {
        String string = this.fromTS.getYear();
        String string2 = this.fromTS.getMonth();
        String string3 = this.fromTS.getDay();
        String string4 = this.toTS.getYear();
        String string5 = this.toTS.getMonth();
        String string6 = this.toTS.getDay();
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.simStartYear, 0, 1, 0, 0, 0);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        Timestamp timestamp2 = Timestamp.valueOf(string + "-" + string2 + "-" + string3 + " 00:00:00");
        Timestamp timestamp3 = Timestamp.valueOf(string4 + "-" + string5 + "-" + string6 + " 00:00:00");
        while (timestamp.before(timestamp2)) {
            long l = ((Date)timestamp).getTime() + (long)(this.timeStepHrs * 3600000);
            timestamp = new Timestamp(l);
        }
        Timestamp timestamp4 = timestamp;
        while (timestamp.before(timestamp3)) {
            long l = ((Date)timestamp).getTime() + (long)(this.timeStepHrs * 3600000);
            timestamp = new Timestamp(l);
        }
        Timestamp timestamp5 = timestamp;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Vector<URL> vector = new Vector<URL>();
        long l = ((Date)timestamp4).getTime();
        long l2 = ((Date)timestamp5).getTime();
        long l3 = this.timeStepHrs * 3600000;
        String string7 = "http://130.159.78.177:8000/idss/results/" + this.simulationName + "/" + this.gridPath + "/";
        try {
            long l4 = l;
            while (l4 <= l2) {
                Timestamp timestamp6 = new Timestamp(l4);
                String string8 = "FD" + simpleDateFormat.format(timestamp6);
                URL uRL = new URL(string7 + string8);
                vector.add(uRL);
                l4 += l3;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("GridViewControlApplet.getURLNames()" + malformedURLException.toString());
        }
        int n = 0;
        while (n < vector.size()) {
            URL uRL = (URL)vector.elementAt(n);
            System.out.println(uRL.toString());
            ++n;
        }
        return vector;
    }
}

